package alma.acs.tmcdb;
// Generated Jun 28, 2010 4:49:06 PM by Hibernate Tools 3.2.4.GA


import alma.hibernate.util.HibernateXmlType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

/**
 * Component generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="COMPONENT"
    , uniqueConstraints = @UniqueConstraint(columnNames={"PATH", "COMPONENTNAME", "CONFIGURATIONID"}) 
)
@TypeDef(name="xmltype", typeClass=HibernateXmlType.class)
public class Component extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer componentId;
     protected Container container;
     protected ComponentType componentType;
     protected Configuration configuration;
     protected String componentName;
     protected String implLang;
     protected Boolean realTime;
     protected String code;
     protected String path;
     protected Boolean isAutostart;
     protected Boolean isDefault;
     protected Boolean isStandaloneDefined;
     protected Boolean isControl;
     protected Integer keepAliveTime;
     protected Byte minLogLevel;
     protected Byte minLogLevelLocal;
     protected String XMLDoc;
     private Set<MasterComponent> masterComponents = new HashSet<MasterComponent>(0);
     private Set<BACIProperty> BACIProperties = new HashSet<BACIProperty>(0);

    public Component() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="Component_seq")}
	)

    
    @Column(name="COMPONENTID", unique=true, nullable=false)
    public Integer getComponentId() {
        return this.componentId;
    }
    
    public void setComponentId(Integer componentId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("componentId", this.componentId, this.componentId = componentId);
        else
            this.componentId = componentId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTAINERID")
    public Container getContainer() {
        return this.container;
    }
    
    public void setContainer(Container container) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("container", this.container, this.container = container);
        else
            this.container = container;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMPONENTTYPEID", nullable=false)
    public ComponentType getComponentType() {
        return this.componentType;
    }
    
    public void setComponentType(ComponentType componentType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("componentType", this.componentType, this.componentType = componentType);
        else
            this.componentType = componentType;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONFIGURATIONID", nullable=false)
    public Configuration getConfiguration() {
        return this.configuration;
    }
    
    public void setConfiguration(Configuration configuration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("configuration", this.configuration, this.configuration = configuration);
        else
            this.configuration = configuration;
    }


    
    @Column(name="COMPONENTNAME", nullable=false, length=256)
    public String getComponentName() {
        return this.componentName;
    }
    
    public void setComponentName(String componentName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("componentName", this.componentName, this.componentName = componentName);
        else
            this.componentName = componentName;
    }


    
    @Column(name="IMPLLANG", nullable=false, length=0)
    public String getImplLang() {
        return this.implLang;
    }
    
    public void setImplLang(String implLang) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("implLang", this.implLang, this.implLang = implLang);
        else
            this.implLang = implLang;
    }


    
    @Column(name="REALTIME", nullable=false)
    public Boolean getRealTime() {
        return this.realTime;
    }
    
    public void setRealTime(Boolean realTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("realTime", this.realTime, this.realTime = realTime);
        else
            this.realTime = realTime;
    }


    
    @Column(name="CODE", nullable=false, length=256)
    public String getCode() {
        return this.code;
    }
    
    public void setCode(String code) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("code", this.code, this.code = code);
        else
            this.code = code;
    }


    
    @Column(name="PATH", nullable=false, length=256)
    public String getPath() {
        return this.path;
    }
    
    public void setPath(String path) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("path", this.path, this.path = path);
        else
            this.path = path;
    }


    
    @Column(name="ISAUTOSTART", nullable=false)
    public Boolean getIsAutostart() {
        return this.isAutostart;
    }
    
    public void setIsAutostart(Boolean isAutostart) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("isAutostart", this.isAutostart, this.isAutostart = isAutostart);
        else
            this.isAutostart = isAutostart;
    }


    
    @Column(name="ISDEFAULT", nullable=false)
    public Boolean getIsDefault() {
        return this.isDefault;
    }
    
    public void setIsDefault(Boolean isDefault) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("isDefault", this.isDefault, this.isDefault = isDefault);
        else
            this.isDefault = isDefault;
    }


    
    @Column(name="ISSTANDALONEDEFINED")
    public Boolean getIsStandaloneDefined() {
        return this.isStandaloneDefined;
    }
    
    public void setIsStandaloneDefined(Boolean isStandaloneDefined) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("isStandaloneDefined", this.isStandaloneDefined, this.isStandaloneDefined = isStandaloneDefined);
        else
            this.isStandaloneDefined = isStandaloneDefined;
    }


    
    @Column(name="ISCONTROL", nullable=false)
    public Boolean getIsControl() {
        return this.isControl;
    }
    
    public void setIsControl(Boolean isControl) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("isControl", this.isControl, this.isControl = isControl);
        else
            this.isControl = isControl;
    }


    
    @Column(name="KEEPALIVETIME", nullable=false)
    public Integer getKeepAliveTime() {
        return this.keepAliveTime;
    }
    
    public void setKeepAliveTime(Integer keepAliveTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("keepAliveTime", this.keepAliveTime, this.keepAliveTime = keepAliveTime);
        else
            this.keepAliveTime = keepAliveTime;
    }


    
    @Column(name="MINLOGLEVEL")
    public Byte getMinLogLevel() {
        return this.minLogLevel;
    }
    
    public void setMinLogLevel(Byte minLogLevel) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("minLogLevel", this.minLogLevel, this.minLogLevel = minLogLevel);
        else
            this.minLogLevel = minLogLevel;
    }


    
    @Column(name="MINLOGLEVELLOCAL")
    public Byte getMinLogLevelLocal() {
        return this.minLogLevelLocal;
    }
    
    public void setMinLogLevelLocal(Byte minLogLevelLocal) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("minLogLevelLocal", this.minLogLevelLocal, this.minLogLevelLocal = minLogLevelLocal);
        else
            this.minLogLevelLocal = minLogLevelLocal;
    }


    
    @Column(name="XMLDOC", length=0)
    @Type(type="xmltype")
    public String getXMLDoc() {
        return this.XMLDoc;
    }
    
    public void setXMLDoc(String XMLDoc) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("XMLDoc", this.XMLDoc, this.XMLDoc = XMLDoc);
        else
            this.XMLDoc = XMLDoc;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="component")
    public Set<MasterComponent> getMasterComponents() {
        return this.masterComponents;
    }
    
    public void setMasterComponents(Set<MasterComponent> masterComponents) {    
    	this.masterComponents = masterComponents;
    }

	public void addMasterComponents(Set<MasterComponent> elements) {
		if( this.masterComponents != null )
			for(Iterator<MasterComponent> it = elements.iterator(); it.hasNext(); )
				addMasterComponentToMasterComponents((MasterComponent)it.next());
	}

	public void addMasterComponentToMasterComponents(MasterComponent element) {
		if( !this.masterComponents.contains(element) ) {
			this.masterComponents.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="component")
    @Cascade( {CascadeType.ALL, CascadeType.DELETE_ORPHAN} )
    public Set<BACIProperty> getBACIProperties() {
        return this.BACIProperties;
    }
    
    public void setBACIProperties(Set<BACIProperty> BACIProperties) {    
    	this.BACIProperties = BACIProperties;
    }

	public void addBACIProperties(Set<BACIProperty> elements) {
		if( this.BACIProperties != null )
			for(Iterator<BACIProperty> it = elements.iterator(); it.hasNext(); )
				addBACIPropertyToBACIProperties((BACIProperty)it.next());
	}

	public void addBACIPropertyToBACIProperties(BACIProperty element) {
		if( !this.BACIProperties.contains(element) ) {
			this.BACIProperties.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof Component) ) return false;
		 Component castOther = ( Component ) other; 
         
		 return ( (this.getConfiguration()==castOther.getConfiguration()) || ( this.getConfiguration()!=null && castOther.getConfiguration()!=null && this.getConfiguration().equals(castOther.getConfiguration()) ) )
 && ( (this.getComponentName()==castOther.getComponentName()) || ( this.getComponentName()!=null && castOther.getComponentName()!=null && this.getComponentName().equals(castOther.getComponentName()) ) )
 && ( (this.getPath()==castOther.getPath()) || ( this.getPath()!=null && castOther.getPath()!=null && this.getPath().equals(castOther.getPath()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         
         
         result = 37 * result + ( getConfiguration() == null ? 0 : this.getConfiguration().hashCode() );
         result = 37 * result + ( getComponentName() == null ? 0 : this.getComponentName().hashCode() );
         
         
         
         result = 37 * result + ( getPath() == null ? 0 : this.getPath().hashCode() );
         
         
         
         
         
         
         
         
         
         
         return result;
   }   


}


