/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 *    Created on Aug 24, 2004
 *
 */

// $Author: hmeuss $
// $Date: 2009/10/30 15:49:58 $
// $Log: ArchiveSubsystemMasterImpl.java,v $
// Revision 1.64.2.1  2009/10/30 15:49:58  hmeuss
// moved initialization of distributors to initpass 1
//
// Revision 1.64  2009/09/09 13:36:15  hmeuss
// removed references to bulksender, unused now
//
// Revision 1.63  2009/04/20 09:44:36  hmeuss
// Corrected bug that NGASarchiveClient was tried to shutdown even when not running.
//
// Revision 1.62  2009/04/14 11:57:09  hmeuss
// changed IF for admin.close and other Archive only methods
//
// Revision 1.61  2009/01/29 14:38:36  achen
//
// to get control of ngasArhciveClient in BulkReceiver
//
// Revision 1.60  2008/12/11 13:50:42  hmeuss
// Alarms were identified wrongly due to wrong usage of resource names. This is now corrected.
//
// Revision 1.59  2008/10/07 14:04:04  hmeuss
// Renamed RecoverableResourceErrorHandler (which was already existing in ACS, but is now removed) to ArchiveResourceErrorHandler
//
// Revision 1.58  2008/09/10 09:07:17  hmeuss
// Added possibility to modify ping interval for BulkReceiver via CDB.
// Improved test for reinit.
//
// Revision 1.57  2008/08/05 09:38:35  hmeuss
// Finally fixed the reinit problem
//
// Revision 1.56  2008/06/23 15:43:15  hmeuss
// Added call to admin.reinit() when reinit is called. Still needs more to do in order to reread dbConfig.
//
// Revision 1.55  2008/03/27 15:10:00  hmeuss
// ping is moved to BulkReceiver, in addition repaired recovery
//
// Revision 1.54  2008/03/17 15:16:15  hmeuss
// catching corba exception in shutdown
//
// Revision 1.53  2007/08/02 14:45:04  nbarriga
// Deleted misplaced "}" that made compilation fail.
//
// Revision 1.52  2007/07/31 08:45:26  hmeuss
// sends alarm if resource is in bad state (for recoverableResourceErrorHandler).
//
// Revision 1.51  2007/07/30 13:06:09  nbarriga
// Fixed mistake: at some point I removed the use of the custom error handler that sends an alarm when a PingableResource doesn't respond correctly.
//
// Revision 1.50  2007/07/27 13:48:08  nbarriga
// Fixed small error(bulkreceivers where being monitored twice).
//
// Revision 1.49  2007/07/26 09:03:13  nbarriga
// If one of the bulkreceiver fails, a restart and reconnection of the component is tried first, if that doesn't work, then go to error state. The previuos behaviuor was to go to error state inmediately.
//
// Revision 1.48  2007/07/24 11:39:24  hmeuss
// When alarm fails, a log is printed now.
//
// Revision 1.47  2007/06/28 13:47:41  nbarriga
// Improved resource monitoring in the master component.
// archiveBulkSender.idl now implements ACS.PingableResource instead of archive.ArchivePingableResource
//
// Revision 1.46  2007/06/21 15:07:54  nbarriga
// Eliminated activation of MonitorStore component.
// Rewrote the resource monitoring.
// The methods for initializing and shutting down the subsystem now only call private methods that do the job. This was to be able to call the same methods from reinitSubsys().
//
// Revision 1.45  2007/05/21 07:12:29  nbarriga
// Merge from branch nbarriga-mastercomponent-B:
//     Eliminated backward compatibility in master component for connecting bulk receivers and distributors.
//     Updated all the test CDBs.
//
// Revision 1.44.2.1  2007/05/11 11:53:56  nbarriga
// Eliminated backward compatibility in master component for connecting bulk receiver and distributor.
// Updated all the test CDBs.
// Commited in a branch for testing before merging to the HEAD.
//
// Revision 1.44  2007/05/08 15:21:33  hmeuss
// adapted to last minute changes in bulkData
//
// Revision 1.43  2007/04/26 16:10:03  hmeuss
// implemented first step for recovery in case ping is working again after failure. Needs improvement!
//
// Revision 1.42  2007/04/05 13:50:42  hmeuss
// put back the CORBA exception
//
// Revision 1.41  2007/04/05 13:21:54  hmeuss
// added alarm for NGAS
//
// Revision 1.40  2007/03/30 11:21:05  hmeuss
// reverted back to the version compatible with HEAD of ACS
//
// Revision 1.39  2007/03/30 09:40:59  hmeuss
// reverted to older version compatible with ACS 6.0.2 for making a tag.
//
// Revision 1.38  2007/03/27 06:58:16  nbarriga
// Added a catch{} in a multiDisconnect call, because the idl for the bulkDataDistributer added a throw statement for a new exception.
//
// Revision 1.37  2007/03/14 10:03:56  nbarriga
// Added ArchiveMasterComponent.xsd: adds information about connections of distributor-receivers.
//
// Distributor-receiver connection information read from CDB. If information is not found, fall back to old behaviuor with a log message indicating so.(for backwards compatibility)
//
// Revision 1.36  2006/10/24 17:56:30  hmeuss
// stops monitoring in shutdown
//
// Revision 1.35  2006/10/24 14:37:34  hmeuss
// added more components for resource checking
//
// Revision 1.34  2006/10/19 08:16:07  hsommer
// NPE fix in shutdown (found in BulkSender test that failed for other reasons)
//
// Revision 1.33  2006/10/16 11:10:55  hsommer
// added monitoring of subsystem resources;
// cleaned up logging and exception handling
// (together with hmeuss)
//
// Revision 1.32  2006/10/10 15:02:07  hsommer
// ContainerException now called AcsJContainerServicesEx
//
// Revision 1.31  2006/09/19 15:50:53  swilliam
// Create new archive SysV-style script, retire old archiveStart/archiveStop scripts
// Remove archive dependency startup from ACS component
// Change test dbConfig to port 8180
//
// Revision 1.30  2006/07/20 12:36:28  hmeuss
// uses the new connectByName methods in bulkData
//
// Revision 1.29  2006/07/17 15:56:46  hmeuss
// integrated new exception thrown by bulkData
//
// Revision 1.28  2006/06/27 09:30:46  hmeuss
// Integrated the revived BUlkStore again (init())
//
// Revision 1.27  2006/02/16 13:59:46  mpasquat
// added comments about exception handling problems
//
// Revision 1.26  2006/01/17 15:44:14  hmeuss
// using getDefaultComponent for getting the ARCHIVE_BULKRECEIVER now. Just a first step as a test, more to be implemented (for other components).
//
// Revision 1.25  2006/01/16 15:52:19  hmeuss
// made reinit more consistent: It does now exactly the same as shutdown and init. In the future this should be improved.
//
// Revision 1.24  2005/12/15 10:13:36  hmeuss
// corrected small bug
//
// Revision 1.23  2005/12/14 13:54:08  hmeuss
// corrected bug in shutdown, thanks to Joe for detecting it
//
// Revision 1.22  2005/11/25 16:25:28  hmeuss
// changed name from BulkDataDistributer to ARCHIVE_CORR_DISTRIBUTOR
//
// Revision 1.21  2005/11/21 16:36:23  hmeuss
// improved archiveStart command
//
// Revision 1.20  2005/09/26 15:46:52  hmeuss
// improved shutdown procedure
//
// Revision 1.19  2005/09/26 12:02:49  hmeuss
// event store is now initialized even when BulkDistributor is not alive.
//
// Revision 1.18  2005/09/15 09:21:28  hmeuss
// Created new script archiveStart which initializes the master component
//
// Revision 1.17  2005/09/13 14:27:45  hmeuss
// Added call to BulkReceiver for initializing event sending
//
// Revision 1.16  2005/08/02 14:01:56  hmeuss
// added ping() method in internalIF and Administrative component
//
// Revision 1.15  2005/07/29 14:37:14  hmeuss
// Added ping() method to BulkSender
//
// Revision 1.14  2005/07/26 13:09:47  hmeuss
// archiveStart is now called in init() of master component.
//
// Revision 1.13  2005/05/02 12:42:51  hmeuss
// removed bulkstore
//
// Revision 1.12  2005/03/31 14:41:38  hmeuss
// Adapted to changes in ACS mastercomp
//
// Revision 1.11  2005/02/08 12:21:56  hmeuss
// Only componets are initialized that are part of CDB
//
// Revision 1.10  2005/02/02 15:46:28  hmeuss
// implemented new naming conventions
//
// Revision 1.9  2004/11/30 09:51:20  hmeuss
// Added release of components in shutdown
//
// Revision 1.8  2004/11/24 13:34:10  hmeuss
// moved component getters from initialize to initSubsysPass1
//
// Revision 1.7  2004/09/21 13:09:33  hmeuss
// Fixed the latest problems
//
// Revision 1.6  2004/09/21 08:46:40  hmeuss
// *** empty log message ***
//
// Revision 1.5  2004/09/20 15:39:35  hmeuss
// Moved all IDLs to IDL module, master component implementation back SubsytemAdministration module
//
// Revision 1.1  2004/09/17 15:18:39  hmeuss
// Moved the subsystem master component to here (due to cyclic references)
//
// Revision 1.4  2004/09/17 09:37:44  hmeuss
// *** empty log message ***
//
// Revision 1.3  2004/09/14 09:32:10  hmeuss
// put component names into variables
//
// Revision 1.2  2004/09/14 09:26:32  hmeuss
// removed old files
// some implementation added to master component
//
// Revision 1.1  2004/08/26 14:21:11  hmeuss
// First steps using the master component IDL
// 
package alma.archive.manager;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.IOException;
import java.lang.ProcessBuilder;

import com.cosylab.CDB.DAO;

import alma.ACS.MasterComponentImpl.MasterComponentImplBase;
import alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions;
import alma.ACS.MasterComponentPackage.SubsystemStateEvent;
import alma.ACS.PingableResourceOperations;
import alma.ACSBulkDataError.AVConnectErrorEx;
import alma.ACSBulkDataError.AVDisconnectErrorEx;
import alma.ACSBulkDataError.wrappers.AcsJAVConnectErrorEx;
import alma.ACSBulkDataError.wrappers.AcsJAVDisconnectErrorEx;
import alma.ACSErrTypeCommon.IllegalStateEventEx;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.genfw.runtime.sm.AcsStateActionException;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.FaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import alma.archive.ArchiveBulkReceiver;
import alma.archive.ArchiveBulkReceiverHelper;
import alma.archive.ArchiveSubsystemMasterIFOperations;
import alma.bulkdata.BulkDataDistributer;
import alma.bulkdata.BulkDataDistributerHelper;
import alma.bulkdata.BulkStore;
import alma.bulkdata.BulkStoreHelper;
import alma.bulkdata.BulkStorePackage.BulkStoreException;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.cdbErrType.WrongCDBDataTypeEx;
import alma.cdbErrType.wrappers.AcsJCDBFieldDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBRecordDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import alma.cdbErrType.wrappers.AcsJWrongCDBDataTypeEx;
import alma.monitorstream.MonitorStreamListener;
import alma.xmlstore.Administrative;
import alma.xmlstore.ArchiveConnection;
import alma.xmlstore.ArchiveConnectionHelper;
import alma.xmlstore.ArchiveInternalError;
import alma.xmlstore.ArchiveConnectionPackage.ArchiveException;
import alma.xmlstore.ArchiveConnectionPackage.PermissionException;
import alma.xmlstore.ArchiveConnectionPackage.UserDoesNotExistException;
import alma.ACS.MasterComponentImpl.SubsysResourceMonitor;

/**
 * @author hmeuss
 * 
 */
public class ArchiveSubsystemMasterImpl extends MasterComponentImplBase
		implements ArchiveSubsystemMasterIFOperations, AlmaSubsystemActions {

	/** Name of the ArchiveConnection compoment */
	public static final String connName = "ARCHIVE_CONNECTION";

	/** Name of the Monitorstore compoment */
	public static final String monitorName = "ARCHIVE_MONITORSTORE";

	/** Names of the BulkReceiver components */
	public static String[] receiverName;

	/** Name of the BulkReceiver compoment */
	public static final String bulkJavaName = "ARCHIVE_BULKSTORE";

	/** Type of BulkReceiver component */
	public static final String receiverType = "IDL:alma/archive/ArchiveBulkReceiver:1.0";

	/** Names of the Distributor compoments */
	public static String[] distrName;

	/** handles to the ARCHIVE components: */
	ArchiveConnection conn;

	/** The Administrative offshoot obtained from ArchiveConnection */
	Administrative admin;

	/** The MonitorStreamListener component obtained by name 'monitorName' */
	MonitorStreamListener monitor;
	
	BulkStore bulkJava;

	ArchiveBulkReceiver[] bulkReceiver;

	BulkDataDistributer[] bulkDistributor;
	
	/** number of seconds between ping to BulkReceiver components **/
	int bulkReceiverPingInterval = -1; 

	/** Number of distributor-receiver connections */
	int numConns;

	// file that store pid of ngasArchiveClient
	File pidFile;

    private String m_password = "almabtrieb"; // for calling protected methods of the admin interface

	/**
	 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase#getActionHandler()
	 */
	protected AlmaSubsystemActions getActionHandler() {
		return this;
	}

	/**
	 * @see alma.archive.ArchiveSubsystemMasterIFOperations#componentNeedsAttention(java.lang.String,
	 *      short, java.lang.String)
	 */
	public void componentNeedsAttention(String componentName,
			short troubleCode, String troubleMessage) {
		// TODO handle this!
		m_logger.warning(troubleMessage);
	}

	private void myInitSubsysPass1() throws AcsStateActionException {
		m_logger.fine("Initializing Archive subsystem: pass 1");
		/* first get references to Archive XMLStore components: */

		try {
			m_logger
					.info("Archive master: connecting and initializing XMLstore/ARCHIVE_CONNECTION.");
			conn = ArchiveConnectionHelper.narrow(m_containerServices
					.getComponent(connName));

			admin = conn.getAdministrative("archive_master");
			
			/* Now init Archive components: */
			try {
				admin.init(m_password);
			} catch (ArchiveInternalError e) {
				m_logger.log(Level.SEVERE, "Failed to initialize XMLstore/admin!",
						e);
				throw new AcsStateActionException(e);
			}

//			qm_logger.info("SLEEPING 20 secs");
//			Thread.sleep(20000);
			
			monitorComponent(conn);

			monitorPingableResource(
					admin,
					"ARCHIVE_CONNECTION/ADMINISTRATIVE",
					new ArchiveResourceErrorHandler<PingableResourceOperations>(
							"ARCHIVE_CONNECTION/ADMINISTRATIVE", true));
		} catch (AcsJContainerServicesEx e) {
			String msg = "Could not connect to component ARCHIVE_CONNECTION: "
					+ e.getContextInfo();
			m_logger.log(Level.SEVERE, msg, e);
			throw new AcsStateActionException(msg, e);
		} catch (Throwable e) {
			String msg = "Could not retrieve ADMINISTRATIVE interface:";
			m_logger.log(Level.SEVERE, msg, e);
			throw new AcsStateActionException(msg, e);
		}
		
		try {
			if (m_containerServices.findComponents(bulkJavaName, null).length > 0) {
				try {
					m_logger.info("connecting and initializing bulkStore.");
					bulkJava = BulkStoreHelper.narrow(m_containerServices
							.getComponent(bulkJavaName));
					bulkJava.init();
					monitorComponent(bulkJava);
				} catch (AcsJContainerServicesEx e) {
					String msg = "Could not connect to component "
							+ bulkJavaName + ": " + e.getContextInfo();
					m_logger.log(Level.SEVERE, msg, e);
					throw new AcsStateActionException(msg, e);
				} catch (BulkStoreException e) {
					String msg = "Could not initialize bulkstore component "
							+ bulkJavaName;
					m_logger.log(Level.SEVERE, msg, e);
					throw new AcsStateActionException(msg, e);
				}
			} else {
				// TODO: require property or CDB entry to allow skipping the
				// bulk store. If not present, throw exception
				m_logger
						.info("Bulk store component '"
								+ bulkJavaName
								+ "' not configured in the CDB. Will have to run without.");
			}
		} catch (AcsJContainerServicesEx e1) {
			m_logger
					.log(
							Level.SEVERE,
							"Unexpected exception: failed to check whether bulk store component is configured in CDB");
			throw new AcsStateActionException(e1);
		}
		
		m_logger.fine("Initializing bulkdistributor(s) and receiver(s).");
		String conNames[] = null;
		DAO myDAO = null;
		try {
			myDAO = m_containerServices.getCDB().get_DAO_Servant(
					"alma/ARCHIVE_MASTER_COMP");
			try {
			bulkReceiverPingInterval = myDAO.get_long("bulkRcvPingInterval"); // if illegal value is returned: no problem, default will be used
			m_logger.info("PING interval for BulkReceiver components read from CDB: "+bulkReceiverPingInterval);
			} catch (Throwable e) {
				// no problem, we use -1 in order to get default value:
				bulkReceiverPingInterval=-1;
				m_logger.info("Could not read PING interval for BulkReceiver components, using default.");
			}
			conNames = myDAO.get_string_seq("connection");
			numConns = conNames.length;
			bulkReceiver = new ArchiveBulkReceiver[numConns];
			bulkDistributor = new BulkDataDistributer[numConns];
			distrName = new String[numConns];
			receiverName = new String[numConns];
			for (int i = 0; i < numConns; i++) {
				distrName[i] = myDAO.get_string("connection/" + conNames[i]
						+ "/distributor");
				receiverName[i] = myDAO.get_string("connection/" + conNames[i]
						+ "/receiver");
			}
		} catch (CDBXMLErrorEx ex) {
			AcsJCDBXMLErrorEx ex2 = new AcsJCDBXMLErrorEx(ex);
			ex2.log(m_logger);
			throw new AcsStateActionException(ex);
		} catch (CDBRecordDoesNotExistEx ex) {
			AcsJCDBRecordDoesNotExistEx ex2 = new AcsJCDBRecordDoesNotExistEx(
					ex);
			ex2.log(m_logger);
			m_logger.severe("Please update your master component XML file");
			throw new AcsStateActionException(ex);
		} catch (CDBFieldDoesNotExistEx ex) {
			AcsJCDBFieldDoesNotExistEx ex2 = new AcsJCDBFieldDoesNotExistEx(ex);
			ex2.log(m_logger);
			m_logger.severe("Please update your master component XML file");
			throw new AcsStateActionException(ex);
		} catch (WrongCDBDataTypeEx ex) {
			AcsJWrongCDBDataTypeEx ex2 = new AcsJWrongCDBDataTypeEx(ex);
			ex2.log(m_logger);
			throw new AcsStateActionException(ex);
		} catch (AcsJContainerServicesEx ex) {
			ex.log(m_logger);
			throw new AcsStateActionException(ex);
		}try {
			// connect bulkreceiver to the distributor
			// first get distributor
			for (int i = 0; i < numConns; i++) {
				if (m_containerServices.findComponents(distrName[i], null).length > 0) {
					try {
						m_logger.info("Archive master: connecting to "
								+ distrName[i]);
						bulkDistributor[i] = BulkDataDistributerHelper
								.narrow(m_containerServices
										.getComponent(distrName[i]));
						monitorComponent(bulkDistributor[i]);
					} catch (AcsJContainerServicesEx e) {
						m_logger.severe(e.getContextInfo());
						throw new AcsStateActionException(
								"Could not connect to component "
										+ distrName[i] + ".\n" + e.toString());
					}
				} else {
					m_logger.warning("No CDB entry for " + distrName[i]
							+ "!! Archive cannot receive bulkData!");
					// ok to continue?? throws ex if configured in CDB but
					// failed load...
					// MPA: is it correct to say that there is not a CDB entry
					// or
					// the componet could not connect? Also corretc to not
					// rethrow the exception?
					// In the previous situations a different error message was
					// generated. So is it
					// it a uqestion of connection or CDB "serach" daone by the
					// function "findComponent" ?
				}

				// next get receiver
				if (m_containerServices.findComponents(receiverName[i], null).length > 0) {
					try {
						m_logger
								.info("Archive master: connecting to "
										+ receiverName[i]
										+ ", using default component");
						bulkReceiver[i] = ArchiveBulkReceiverHelper
								.narrow(m_containerServices
										.getComponent(receiverName[i]));

						// all bulkReceivers components do the ping, not
						// necessary, but does not really harm:
//						monitorPingableResource(bulkReceiver[i],
//								receiverName[i], new BulkReceiverErrorHandler(
//										receiverName[i]));

						// the following code is copied from monitorPingableResource and is replacing the line above,
						// since we need to configure the delaySeconds.
						SubsysResourceMonitor.ResourceChecker<ArchiveBulkReceiver> checker = new SubsysResourceMonitor.PingableResourceChecker(bulkReceiver[i], receiverName[i]);
						monitorResource(checker, new BulkReceiverErrorHandler(receiverName[i]), bulkReceiverPingInterval);
						
						
						// monitorComponent(bulkReceiver[i]);
						// BulkReceiverErrorHandler errHandler= new
						// BulkReceiverErrorHandler(receiverName[i]);
						// monitorComponent(bulkReceiver[i],errHandler);
					} catch (AcsJContainerServicesEx e) {
						m_logger.severe(e.getContextInfo());
						throw new AcsStateActionException(
								"Could not connect to component "
										+ receiverName[i] + ".\n"
										+ e.toString());
					}
				} else {
					m_logger.warning("No CDB entry for " + receiverName[i]
							+ "!! Archive cannot receive bulkData!");
					// MPA: idem, see previous comment
				}
			}
		} catch (AcsJContainerServicesEx e) {
			throw new AcsStateActionException(e);
		}

		
	}

	private void myInitSubsysPass2() throws AcsStateActionException {

		m_logger.fine("Initializing Archive subsystem: pass 2");

			// connect bulkreceiver to the distributor
			// first get distributor
			for (int i = 0; i < numConns; i++) {
				// finally connect receiver to distributor
				if (bulkDistributor[i] != null && bulkReceiver[i] != null) {
					// connect
					m_logger.info("Attaching " + receiverName[i] + " to "
							+ distrName[i] + " as receiver.");
					try {
						// bulkDistributor.multiConnect(bulkReceiver);
						bulkDistributor[i].connectByName(receiverName[i]);
					} catch (AVConnectErrorEx e2) {
						m_logger
								.severe("Could not connect bulk receiver to bulk distributor component:\n"
										+ e2.toString());
						throw new AcsStateActionException(
								"Could not connect bulk receiver to bulk distributor component:\n"
										+ e2.toString());
					}
				}

				if (bulkReceiver[i] != null) {
					m_logger
							.info("Triggering BulkReceiver intitialization (callback connection).");
					bulkReceiver[i].passSupplier2cbs();
				}
			} //end for

		// check wheather to start ngasArchiveClient:
		try {
			conn = ArchiveConnectionHelper.narrow(m_containerServices.getComponent(connName));
			admin = conn.getAdministrative("ArchiveMaster");
		} catch (Throwable e) {
			String msg = "Could not retrieve ADMINISTRATIVE interface:";
			m_logger.log(Level.SEVERE, msg, e);
			throw new AcsStateActionException(msg, e);
		}
		if (admin != null && admin.config("archive.ngast.storeInNgast").matches("Delayed")){
			bulkReceiver[0].shutdownNGASArchiveClient();
			bulkReceiver[0].startNGASArchiveClient();
/* original method to start ngasArhciveClient from master component
			// set NGAS configuration
			String ngas_host, ngas_port;
			String seq = "";
		//for syncronization of NGAS server parameter in dbconfig

			String ngasClientStartCmd = "ngasArchiveClient --servers=";
			for (char x = 'A';; x++) {
				ngas_host = admin.config("archive.ngast.server" + seq);
				if (ngas_host.length() == 0) break;
				ngas_port = admin.config("archive.ngast.port" + seq);
				if (ngas_port.length() == 0) ngas_port = "7777";

				ngasClientStartCmd += ngas_host + ":" + ngas_port + ",";
				seq = String.valueOf(x);
			} // end for
			if(!ngasClientStartCmd.endsWith(",")){
				// no defination, use default value
				ngasClientStartCmd = "ngasArchiveClient --servers=almadev1.hq.eso.org:7777 ";
			} else {
				//replace last "," with " "
				int index = ngasClientStartCmd.lastIndexOf(",");
				ngasClientStartCmd = ngasClientStartCmd.substring(0, index) + " ";
			}				

			String ngasClientParams = admin.config("archive.ngast.clientParams");
			String ngasClientStartCmd = "ngasArchiveClient " + ngasClientParams; //--servers=ngas02:7777,ngas03:7777,ngas04:7777,ngas05:7777 --rootDir=/mnt/RAM/NGAS/ 
											     //--logFile=ngasArchiveClient.log --logLevel=1 --logRotation=12:00:00 --mimeType=multialma/related 
											     //--pollTime=0 --cleanUpTimeOut=0 --streams=32 --verbose=1

			m_logger.info("Starting ngamsArchiveClient...");
			pidFile = new File(admin.config("archive.ngast.testDir") + ".ngasArchiveClient-PID");

			// check if there already exist a ngasArchiveClient
			if (pidFile.exists()) myShutDownngasArchiveClient();

			// Finally, start the client:
			m_logger.info("Starting ngamsArchiveClient with " + ngasClientStartCmd);
			try {
				Process p = new ProcessBuilder(Arrays.asList(ngasClientStartCmd.split(" "))).start();
				//Runtime.getRuntime().exec(ngasClientStartCmd);
			} catch (IOException e) {
				String msg = "Could not start ngamsArchiveClient. Aborting...";
				m_logger.log(Level.SEVERE, msg, e);
				throw new AcsStateActionException(msg, e);
			}
*/
		}
	}
/*
	private void myShutDownngasArchiveClient()throws AcsStateActionException{
		BufferedReader pidReader;
		try {
			pidReader = new BufferedReader(new FileReader(pidFile));
			String pid;
			pid = pidReader.readLine();
			String cmd = "kill -15 " + pid;
			m_logger.info("Found running ngamsArchiveClient. Killing it with command: " + cmd);

			Runtime runtime = Runtime.getRuntime();
			Process proc = runtime.exec(cmd);
			if (proc.waitFor() != 0) {
				// error
				m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
			}
			// make sure file is away now:
			Thread.sleep(5000);
			if (pidFile.exists()) {
				cmd = "kill -9 " + pid;
				m_logger.info("ngamsArchiveClient didn't die with SIGTERM. Killing it with command: " + cmd);
				proc = runtime.exec(cmd);
				if (proc.waitFor() != 0) {
					// error
					m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
				} else {
					// remove pid file by hand:
					pidFile.delete();
				}
			}
		} catch (FileNotFoundException e) {
			// should not happen...
			m_logger.warning("Strange!! Could not find PID file for ngasArchiveClient.");
		} catch (IOException e) {
			m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
			throw new AcsStateActionException("Could not kill existing ngamsArchiveClient process.", e);
		} catch (InterruptedException e) {
			m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
			throw new AcsStateActionException("Could not kill existing ngamsArchiveClient process.", e);
		}
	}
*/
	private void myShutDownSubsysPass1() {
		m_logger.fine("Shutting down Archive subsystem: pass 1.");
		stopMonitoringAllResources();
	}

	private void myShutDownSubsysPass2() throws AcsStateActionException {
		m_logger.fine("Shutting down Archive subsystem: pass 2.");

		// close ngasArchiveClient if exists

		// check wheather to start ngasArchiveClient:
		try {
			conn = ArchiveConnectionHelper.narrow(m_containerServices.getComponent(connName));
			admin = conn.getAdministrative("ArchiveMaster");
		} catch (Throwable e) {
			String msg = "Could not retrieve ADMINISTRATIVE interface:";
			m_logger.log(Level.SEVERE, msg, e);
			throw new AcsStateActionException(msg, e);
		}
		if (admin != null && admin.config("archive.ngast.storeInNgast").matches("Delayed")){
			bulkReceiver[0].shutdownNGASArchiveClient();
		}
		
		// close Bulkstore, xmlStore
		if (admin != null) { // == null if shutdown is called on a MC that
			// was never initialized.
			try {
				admin.close(m_password);
			} catch (ArchiveInternalError e) {
				m_logger.log(Level.WARNING,
						"Problems when shutting down XMLstore", e);
				// no rethrow
			} catch (org.omg.CORBA.SystemException e) {
				m_logger.log(Level.WARNING,
						"Problems when shutting down XMLstore", e);
				// no rethrow
			}
		}
		for (int i = 0; i < numConns; i++) {
			if (bulkDistributor[i] != null && bulkReceiver[i] != null) {
				m_logger.finer("Disconnecting receiver from distributor");
				try {
					bulkDistributor[i].name();// this is weird, but if I don't
												// put these line and the
												// component is not up, then it
												// throws an exception during
												// multiDisconnect
					bulkReceiver[i].name();
					bulkDistributor[i].multiDisconnect(bulkReceiver[i]);
				} catch (AVDisconnectErrorEx e) {
					// don't do anything, as we are releasing the components
					// anyway
					// throw new AcsStateActionException(e);
					// m_logger.log(Level.WARNING,"Couldn't disconnect
					// "+distrName[i]+" and "+receiverName[i]);
					AcsJAVDisconnectErrorEx ex = new AcsJAVDisconnectErrorEx(e);
					ex.log(m_logger);
				} catch (org.omg.CORBA.SystemException ex) {
					m_logger.log(Level.WARNING,
							"CORBA.SystemException caught when calling "
									+ distrName[i] + ".multiDisconnect("
									+ receiverName[i] + "), ignoring it.");
				}

			}
		}
		// the following for the problem that some components don't shutdown:
//		try {
//		conn.releaseOffshoot(admin);
//		} catch (Exception e) {
//			m_logger.warning("Couldn't release admin component, continuing... "+e);
//		}
		
		// release bulkSender, connection, distributor
		m_containerServices.releaseComponent(connName);
		m_containerServices.releaseComponent(bulkJavaName);
		for (int i = 0; i < numConns; i++) {
			m_containerServices.releaseComponent(distrName[i]);
			m_containerServices.releaseComponent(receiverName[i]);
		}
	}

	/**
	 * 
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#initSubsysPass1()
	 */
	public void initSubsysPass1() throws AcsStateActionException {
		myInitSubsysPass1();
	}

	/**
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#initSubsysPass2()
	 */
	public void initSubsysPass2() throws AcsStateActionException {
		myInitSubsysPass2();
	}

	/**
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#shutDownSubsysPass1()
	 */
	public void shutDownSubsysPass1() {
		myShutDownSubsysPass1();
	}

	/**
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#shutDownSubsysPass2()
	 */
	public void shutDownSubsysPass2() throws AcsStateActionException {
		myShutDownSubsysPass2();
	}

	/**
	 * TODO: restart monitoring of all resources (not necessary/possible to stop
	 * it)
	 * 
	 * @see alma.ACS.MasterComponentImpl.statemachine.AlmaSubsystemActions#reinitSubsystem()
	 */
	public void reinitSubsystem() throws AcsStateActionException {
		myShutDownSubsysPass1();
		myShutDownSubsysPass2();			
		
		try {
			conn = ArchiveConnectionHelper.narrow(m_containerServices
					.getComponent(connName));

			admin = conn.getAdministrative("archive_master");
		} catch (Throwable e) {
			m_logger.severe("Could not reinit Archive subsystem: "+e.toString());
			throw new AcsStateActionException(e);
		}
		
		/* Now init Archive components: */
		try {
			m_logger.fine("Reinit XMLstore");
			admin.reinit(m_password);
		} catch (ArchiveInternalError e) {
			m_logger.log(Level.SEVERE, "Failed to re-initialize XMLstore/admin!",
					e);
			throw new AcsStateActionException(e);
		}

		myInitSubsysPass1();
		myInitSubsysPass2();

	}

	// /////////////////////////////////////////////////////////////////////////////////////
	// Rersource monitoring framework classes
	// /////////////////////////////////////////////////////////////////////////////////////

	/*
	 * As soon as we can actually do some error hanlding on the
	 * bulkReceivers-bulkDistributors, we should modify and use this class
	 */
	protected class BulkReceiverErrorHandler extends
			ArchiveResourceErrorHandler<ArchiveBulkReceiver> {
		int receiverNumber = -1;

		BulkReceiverErrorHandler(String rcvName) {
			super(rcvName, true);

			for (int i = 0; i < numConns; i++) {
				if (receiverName[i].compareTo(rcvName) == 0) {
					receiverNumber = i;
					break;
				}
			}
		}

		/*
		 * If the receiver is unreachable,release and try to get it again, if
		 * this works rely on resourceRecovered to connect it again, if it
		 * doesn't, the go to error state, and don't continue monitoring the
		 * resource.
		 * 
		 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase$DefaultResourceErrorHandler#resourceUnreachable(java.lang.Object)
		 * 
		 * Something wrong here: We should decide between ping failed and
		 * resource unreachable!
		 */
		public boolean resourceUnreachable(ArchiveBulkReceiver receiver) {
			m_logger.info(resourceName
					+ " component unreachable, will try to reconnect.");
			try {
				m_containerServices.releaseComponent(resourceName);
				bulkReceiver[receiverNumber] = ArchiveBulkReceiverHelper
						.narrow(m_containerServices.getComponent(resourceName));
				if (!bulkReceiver[receiverNumber].ping()) {
					// ping not working again: go to error state
					m_logger.log(Level.WARNING, "Couldn't recover "
							+ resourceName
							+ ", Archive will go to ERROR state.");
					try {
						doTransition(SubsystemStateEvent.SUBSYSEVENT_ERROR);
					} catch (IllegalStateEventEx ex) {
						AcsJIllegalStateEventEx ex2 = new AcsJIllegalStateEventEx(
								ex);
						ex2.log(m_logger);
					}
					return true;// don't continue monitoring this receiver
				}
			} catch (AcsJContainerServicesEx e) {
				m_logger.log(Level.WARNING, "Couldn't recover " + resourceName
						+ ", Archive will go to ERROR state.");
				super.resourceUnreachable(receiver);
				// @TODO think if we really need this alarm
				// no it's done in super()
				//send_alarm("NGAS", true);
				try {
					doTransition(SubsystemStateEvent.SUBSYSEVENT_ERROR);
				} catch (IllegalStateEventEx ex) {
					AcsJIllegalStateEventEx ex2 = new AcsJIllegalStateEventEx(
							ex);
					ex2.log(m_logger);
				}
				return true;// don't continue monitoring this receiver
			}
			return false;// continue monitoring, so resourceRecovered can try
							// to reconnect it
		}

		/*
		 * If the receiver is recovered disconnect, release, get and connect. If
		 * something fails go to error state.
		 * 
		 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase$DefaultResourceErrorHandler#resourceRecovered(java.lang.Object)
//		 */
		// not necesssary, we take default from ArchiveResourceErrorHandler
//		public void resourceRecovered(ArchiveBulkReceiver receiver) {
//			try {
//				m_logger.info("Disconnecting " + distrName[receiverNumber]
//						+ " and " + resourceName);
//				bulkDistributor[receiverNumber].disconnectByName(resourceName);
//			} catch (AVDisconnectErrorEx e) {
//				AcsJAVDisconnectErrorEx ex = new AcsJAVDisconnectErrorEx(e);
//				ex.log(m_logger);
//			}
//			try {
//				m_containerServices.releaseComponent(resourceName);
//				bulkReceiver[receiverNumber] = ArchiveBulkReceiverHelper
//						.narrow(m_containerServices.getComponent(resourceName));
//				bulkDistributor[receiverNumber].connectByName(resourceName);
//			} catch (AcsJContainerServicesEx ex) {
//				m_logger.log(Level.WARNING, "Couldn't recover " + resourceName
//						+ ", Archive will go to ERROR state..");
//				try {
//					doTransition(SubsystemStateEvent.SUBSYSEVENT_ERROR);
//				} catch (IllegalStateEventEx ex2) {
//					AcsJIllegalStateEventEx ex3 = new AcsJIllegalStateEventEx(
//							ex2);
//					ex3.log(m_logger);
//				}
//			} catch (AVConnectErrorEx ex) {
//				AcsJAVConnectErrorEx ex2 = new AcsJAVConnectErrorEx(ex);
//				ex2.log(m_logger);
//				m_logger.log(Level.WARNING, "Couldn't recover " + resourceName
//						+ ", Archive will go to ERROR state.");
//				try {
//					doTransition(SubsystemStateEvent.SUBSYSEVENT_ERROR);
//				} catch (IllegalStateEventEx ex3) {
//					AcsJIllegalStateEventEx ex4 = new AcsJIllegalStateEventEx(
//							ex3);
//					ex4.log(m_logger);
//				}
//			}
//		}

		/*
		 * If the receiver is in a bad state, try to disconnect, release it so
		 * unreachableResource will take over.
		 * 
		 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase$DefaultResourceErrorHandler#badState(java.lang.Object,
		 *      java.lang.String)
		 */
		// not necesssary, we take default from ArchiveResourceErrorHandler
//		public void badState(ArchiveBulkReceiver resource, String stateName) {
//			m_logger.info(resourceName + " component found in a bad state("
//					+ stateName + "), will release it.");
//			try {
//				m_logger.info("Disconnecting " + distrName[receiverNumber]
//						+ " and " + resourceName);
//				bulkDistributor[receiverNumber].disconnectByName(resourceName);
//			} catch (AVDisconnectErrorEx e) {
//				AcsJAVDisconnectErrorEx ex = new AcsJAVDisconnectErrorEx(e);
//				ex.log(m_logger);
//			} catch (Throwable e) {
//				m_logger.warning(e.toString());
//			}
//			m_containerServices.releaseComponent(resourceName);
//		}
	}

	/*
	 * same functionality as DefaultResourceErrorHandler, but additionally
	 * allows to go back to operational state if ping works again. And also
	 * sends alarm, if in bad state.
	 */
	protected class ArchiveResourceErrorHandler<T> extends
			DefaultResourceErrorHandler<T> {

		ArchiveResourceErrorHandler(String resourceName, boolean isComponent) {
			super(resourceName, isComponent);
		}

		public boolean resourceUnreachable(T resource) {
			super.resourceUnreachable(resource);
			// @TODO think if we really need this alarm
			// @TODO this must be changed as this class checks not only the
			// bulksender
			//m_logger.severe("YYY Sending alarm (unreachable(: "+resourceName);
			send_alarm(resourceName.equals(connName+"/ADMINISTRATIVE") ? "Oracle" : "NGAS",
					true);

			// we change the return value and want the checks of the component
			// states to continue:
			return true;
		}

		/*
		 * If the resource is in a bad state, send an alarm, and delegate to
		 * superclass.
		 * 
		 * @see alma.ACS.MasterComponentImpl.MasterComponentImplBase$DefaultResourceErrorHandler#badState(java.lang.Object,
		 *      java.lang.String)
		 */
		public void badState(T resource, String stateName) {
			super.badState(resource, stateName);
			//m_logger.severe("YYY Sending alarm (bad state): "+resourceName);
			send_alarm(resourceName.equals(connName+"/ADMINISTRATIVE") ? "Oracle" : "NGAS",
					true);
		}

		/**
		 * we will now reinit the subsystem
		 */
		public void resourceRecovered(T resource) {
			try {
				m_logger.info((isComponent ? "Component" : "Resource") + " '"
						+ resourceName
						+ "' has recoveres, will REINIT Archive subsystem.");
				doTransition(SubsystemStateEvent.SUBSYSEVENT_REINIT);
				//m_logger.severe("YYY UNSending alarm: "+resourceName);
				// unset alarm:
				send_alarm(resourceName.equals(connName+"/ADMINISTRATIVE") ? "Oracle" : "NGAS",
						false);
			} catch (Throwable thr) {
				m_logger.log(Level.WARNING,
						"exception caught while REINITing Archive subsystem.",
						thr);
			}
		}
	}

	/**
	 * convenience method for send_alarm/4 Has to imp[roved in order to
	 * deactivate alarms etc. See AdministrativeImpl for example
	 * 
	 */
	protected void send_alarm(String faultMember, boolean active) {
		String faultFamily = "Backend";
		int faultCode = 1;
		String faultState;
		if (active) {
			faultState = ACSFaultState.ACTIVE;
		} else {
			faultState=ACSFaultState.TERMINATE;
		}
		send_alarm(faultFamily, faultMember, faultCode, faultState);
	}

	/**
	 * sends an alarm to the ACS alarm system. Alarms must be configured in the
	 * CDB.
	 * 
	 * @param faultFamily
	 * @param faultMember
	 * @param faultCode
	 * @param faultState
	 * @throws ACSASFactoryNotInitedEx
	 * @throws SourceCreationErrorEx
	 * @throws FaultStateCreationErrorEx
	 */
	protected void send_alarm(String faultFamily, String faultMember,
			int faultCode, String faultState) {
		try {
			ACSAlarmSystemInterface alarmSource = ACSAlarmSystemInterfaceFactory
					.createSource("ARCHIVE_MASTER_COMP");
			ACSFaultState fs = ACSAlarmSystemInterfaceFactory.createFaultState(
					faultFamily, faultMember, faultCode);
			fs.setDescriptor(faultState);
			fs.setUserTimestamp(new Timestamp(System.currentTimeMillis()));

			Properties props = new Properties();
			props.setProperty(ACSFaultState.ASI_PREFIX_PROPERTY, "prefix");
			props.setProperty(ACSFaultState.ASI_SUFFIX_PROPERTY, "suffix");
			fs.setUserProperties(props);
			alarmSource.push(fs);

		} catch (Exception e) {
			m_logger.warning("Failure when sending alarm: " + e);
			// throw new ArchiveEception(e.toString());
		}
	}
}
