/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.shared.ldap;

import alma.archive.projectcode.ProjectCode;
import alma.userrepository.domainmodel.Address;
import alma.userrepository.domainmodel.AddressBookEntry;
import alma.userrepository.domainmodel.User;
import alma.userrepository.projectdirectory.ProjectRole;
import alma.userrepository.roledirectory.Role;

public class DnDirectory {
    public static final String PEOPLE_BASE = "ou=people,ou=master,dc=alma,dc=info";
    public static final String PROJECT_BASE = "ou=projects,ou=master,dc=alma,dc=info";
    public static final String ROLE_BASE = "ou=roles,ou=master,dc=alma,dc=info";

    public static String getUserRdn(String uid) {
        return "uid=" + uid;
    }

    public static String getUserDn(String uid) {
        return getUserRdn(uid) + "," + PEOPLE_BASE;
    }

    public static String getUserDn(User user) {
        String uid = user.getUid();
        return getUserDn(uid);
    }

    public static String getUserDn(AddressBookEntry entry) {
        User user = entry.getUser();
        return getUserDn(user);
    }

    public static String getAddressRdn(String uid) {
        String rdn = "uid=" + uid;
        return rdn;
    }

    public static String getAddressRdn(Address address) {
        String rdn = "uid=" + address.getUid();
        return rdn;
    }

    public static String getAddressDn(Address address, User user) {
        String dn = getAddressRdn(address) + "," + getUserDn(user);
        return dn;
    }

    public static String getAddressDn(Address address, AddressBookEntry entry) {
        String dn = getAddressRdn(address) + "," + getUserDn(entry);
        return dn;
    }

    public static String getRoleDn(Role inRole) {
        return "cn=" + inRole.getRoleName() + "," + "ou="
                + inRole.getApplicationName() + "," + ROLE_BASE;
    }

    public static String getProjectRdn(ProjectCode inCode) {
        return "almaProjectCode=" + inCode;

    }

    public static String getProjectDn(ProjectCode inCode) {
        return getProjectRdn(inCode) + "," + DnDirectory.PROJECT_BASE;

    }

    public static String getProjectRoleGroupRdn(ProjectRole inRole) {
        return "almaProjectRoleName=" + inRole.getRoleName();
    }

    public static String getProjectRoleGroupDn(ProjectRole inRole,
            ProjectCode inCode) {
        return getProjectRoleGroupRdn(inRole) + "," + getProjectDn(inCode);
    }

    public static String getUserId(String inUserDn) {
        int index = inUserDn.indexOf(',');
        String rdn = null;
        if (index != -1) {
            rdn = inUserDn.substring(0, index);
        } else {
            rdn = inUserDn;
        }
        index = rdn.indexOf('=');
        return rdn.substring(index + 1);
    }
}
