package alma.userrepository.shared;

import java.util.logging.Logger;

import alma.userrepository.addressbook.AddressBookSession;
import alma.userrepository.errors.UserRepositoryException;
import alma.userrepository.projectdirectory.ProjectDirectorySession;
import alma.userrepository.roledirectory.RoleDirectorySession;

public abstract class DirectorySessionFactory {

    private static DirectorySessionFactory instance;

    protected Logger myLogger = Logger.getAnonymousLogger();

    protected DirectorySessionFactory(Logger inLogger) {
        if (inLogger != null) {
            this.myLogger = inLogger;
        }
    }

    public static DirectorySessionFactory getInstance(Logger inLogger) {
        if (instance == null) {
            synchronized (DirectorySessionFactory.class) {
                if (instance == null) {
                    instance = new LdapDirectorySessionFactory(inLogger);
                }
            }
        }
        return instance;
    }

    public abstract AddressBookSession newAddressBookSession(String userId,
            String password) throws UserRepositoryException;

    public abstract ProjectDirectorySession newProjectDirectorySession(
            String userId, String password) throws UserRepositoryException;

    public abstract RoleDirectorySession newRoleDirectorySession(String userId,
            String password) throws UserRepositoryException;

    public abstract boolean isAlive();

    public static boolean authenticate(String userId, String password,
            Logger inLogger) throws UserRepositoryException {
        return getInstance(inLogger).authenticateImpl(userId, password);
    }

    abstract boolean authenticateImpl(String userId, String password)
            throws UserRepositoryException;

    public static void setFactory(DirectorySessionFactory inFactory) {
        instance = inFactory;
    }
}
