package alma.userrepository.roledirectory;

public class RoleHelper {
    /**
     * Gets the enum matching the given String. The given String will be made
     * into upper case and have all spaces replaced with underscores. The
     * matching is then made against the String returned by {@link #name()} on
     * the enums.
     * <p>
     * This method is convenient to use to, for instance, match the string
     * returned from {@link #toString()} since this string does not exactly
     * match what is returned from {@link #name()}.
     * 
     * @param inString
     *            the String to try to match to an enum.
     * 
     * @return an enum if found.
     * 
     * @throws IlleagalArgumentException
     *             if no enum is found.
     * @throws NullPointerException
     *             if inString is <code>null</code>.
     */
//    public static MASTERRole string2enum(String inString) {
//        return Enum.valueOf(MASTERRole.class, inString.toUpperCase()
//                .replace(' ', '_'));
//    }

    /**
     * Gets a camel case version of the name of the enum.
     * 
     * @return a String
     */
    public static String toString(Enum inEnum) {
        StringBuilder builder = new StringBuilder();
        char[] chars = inEnum.name().toCharArray();
        boolean nextUpper = true;
        for (char character : chars) {
            if (nextUpper) {
                builder.append(character);
                nextUpper = false;
            } else if (character == '_') {
                builder.append(" ");
                nextUpper = true;
            } else {
                builder.append(Character.toLowerCase(character));
            }
        }
        return builder.toString();
    }

}
