package alma.userrepository.roledirectory;

public class Role implements Comparable<Role> {
    private String myRoleName;

    private String myApplicationName;

    /**
     * Creates a new Role with the given name and belonging to the given
     * application.
     * 
     * @param inRoleName
     *            a String stating the role name.
     * 
     * @param inApplicationName
     *            a String stating the application name.
     * 
     * @throws IllegalArgumentException
     *             in case inRoleName or inApplicationName is <code>null</code>
     *             or empty string.
     */
    public Role(String inRoleName, String inApplicationName) {
        if (inRoleName == null || "".equals(inRoleName)) {
            throw new IllegalArgumentException(
                    "inRoleName cannot be null or empty string.");
        }
        if (inApplicationName == null || "".equals(inApplicationName)) {
            throw new IllegalArgumentException(
                    "inApplicationName cannot be null or empty string.");
        }
        this.myRoleName = inRoleName;
        this.myApplicationName = inApplicationName;
    }

    @Override
    public int compareTo(Role inRole) {
        int outValue = this.myApplicationName.compareTo(inRole
                .getApplicationName());
        if (outValue == 0) {
            outValue = this.myRoleName.compareTo(inRole.getRoleName());
        }
        return outValue;
    }

    @Override
    public int hashCode() {
        return this.myRoleName.hashCode();
    }

    @Override
    public boolean equals(Object inObject) {
        boolean outResult = false;
        if (inObject instanceof Role) {
            if (compareTo((Role) inObject) == 0) {
                outResult = true;
            }
        }
        return outResult;
    }

    /**
     * Gets the contained data in a readable way. Good for debugging.
     * 
     * @return a String.
     */
    public String getData() {
        StringBuilder builder = new StringBuilder();
        builder.append("Role Name: ");
        builder.append(this.myRoleName);
        builder.append(" Application Name: ");
        builder.append(this.myApplicationName);
        return builder.toString();
    }

    /**
     * Gets the name of the role.
     * 
     * @return a String.
     */
    public String getRoleName() {
        return this.myRoleName;
    }

    /**
     * Gets the name of the application this role relates to.
     * 
     * @return a String.
     */
    public String getApplicationName() {
        return this.myApplicationName;
    }

    /**
     * Gets a camel case version of the name of the role name (application name
     * is NOT included).
     * 
     * @return a String.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        char[] chars = getRoleName().toCharArray();
        boolean nextUpper = true;
        for (char character : chars) {
            if (nextUpper) {
                builder.append(character);
                nextUpper = false;
            } else if (character == '_') {
                builder.append(" ");
                nextUpper = true;
            } else {
                builder.append(Character.toLowerCase(character));
            }
        }
        return builder.toString();
    }
}
