package alma.userrepository.projectdirectory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import alma.archive.projectcode.ProjectCode;

public class ProjectRoleDirectory {
    /**
     * The code identifying the project this role directory is related to.
     */
    private ProjectCode myProjectCode;

    /**
     * Map containing the roles for the project and the various members.
     */
    private Map<ProjectRole, List<String>> myRoleMap = new HashMap<ProjectRole, List<String>>();

    /**
     * Constructor taking the project code of the project this role directory is
     * valid for.
     * 
     * @param inProjectCode
     *            a ProjectCode defining the project this directory belongs to.
     * 
     * @throws IllegalArgumentException
     *             in case the specified project code is <code>null</code>.
     */
    public ProjectRoleDirectory(ProjectCode inProjectCode) {
        if (inProjectCode == null) {
            throw new IllegalArgumentException("inProjectCode cannot be null");
        }
        this.myProjectCode = inProjectCode;
    }

    public boolean add(ProjectRole inRole, String inMember) {
        boolean outValue = false;
        List<String> list = this.myRoleMap.get(inRole);
        if (list == null) {
            list = new ArrayList<String>();
            this.myRoleMap.put(inRole, list);
        }
        if (!list.contains(inMember)) {
            outValue = list.add(inMember);
        }
        return outValue;
    }

    public boolean addAll(ProjectRole inRole, List<String> inMemberList) {
        boolean outValue = false;
        for (String member : inMemberList) {
            if (add(inRole, member)) {
                outValue = true;
            }
        }
        return outValue;
    }

    public ProjectCode getProjectCode() {
        return this.myProjectCode;
    }

    public List<String> getMembers() {
        List<String> outList = new ArrayList<String>();
        for (ProjectRole role : this.myRoleMap.keySet()) {
            for (String userID : this.myRoleMap.get(role))
                if (!outList.contains(userID)) {
                    outList.add(userID);
                }
        }
        Collections.sort(outList);
        return outList;
    }

    public List<String> getMembers(ProjectRole inRole) {
        List<String> outList = this.myRoleMap.get(inRole);
        if (outList != null) {
            // make a copy for the client to play with.
            outList = new ArrayList<String>(outList);
            Collections.sort(outList);
        } else {
            outList = new ArrayList<String>();
        }
        return outList;
    }

    public List<ProjectRole> getRoles(String inUserID) {
        List<ProjectRole> outList = new ArrayList<ProjectRole>();
        for (ProjectRole role : this.myRoleMap.keySet()) {
            if (this.myRoleMap.get(role).contains(inUserID)) {
                outList.add(role);
            }
        }
        Collections.sort(outList);
        return outList;
    }

    public List<ProjectRole> getAllRoles() {
        return new ArrayList<ProjectRole>(this.myRoleMap.keySet());
    }

    public boolean hasRole(String inUserID, ProjectRole inRole) {
        return getRoles(inUserID).contains(inRole);
    }
}
