/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.domainmodel;

import java.util.List;
import java.util.Map;

import alma.userrepository.roledirectory.Role;
import alma.userrepository.roledirectory.RoleDirectory;

public interface User {

    /**
     * @return the firstName
     */
    public String getFirstName();

    /**
     * @param firstName
     *            the firstName to set
     */
    public void setFirstName(String firstName);

    /**
     * @return the fullName
     */
    public String getFullName();

    /**
     * @param fullName
     *            the fullName to set
     */
    public void setFullName(String fullName);

    /**
     * @return the notes
     */
    public String getNotes();

    /**
     * @param notes
     *            the notes to set
     */
    public void setNotes(String notes);

    /**
     * @return the roles associated with this user
     */
    public RoleDirectory getRoles();

    /**
     * Convenience method for checking if a certain role is assigned to the
     * user.
     * 
     * @param inRole
     *            a Role object being the role to check for.
     * 
     * @return a boolean indicating if the user has the role or not.
     */
    public boolean hasRole(Role inRole);

    /**
     * @return the surname
     */
    public String getSurname();

    /**
     * @param surname
     *            the surname to set
     */
    public void setSurname(String surname);

    /**
     * @return the uid
     */
    public String getUid();

    /**
     * @param uid
     *            the uid to set
     */
    public void setUid(String uid);
}
