package alma.userrepository.addressbook.ldap.beans;

import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

import alma.userrepository.addressbook.ldap.AttributeUtilities;
import alma.userrepository.addressbook.ldap.UserInfoProperties;
import alma.userrepository.domainmodel.Preferences;
import alma.userrepository.errors.UserRepositoryException;

/**
 * @author stewart
 * 
 */
public class LdapPreferences implements Preferences {
    private String preference1;
    private String preference2;
    private String preference3;
    private String preference4;

    private static UserInfoProperties ldapMapping = UserInfoProperties
            .getInstance();

    // - constructors ---------------------------------------------------------

    public LdapPreferences() {
    }

    public LdapPreferences(Preferences preferences) {
        if (preferences != null) {
            preference1 = preferences.getPreference1();
            preference2 = preferences.getPreference2();
            preference3 = preferences.getPreference3();
            preference4 = preferences.getPreference4();
        }
    }

    public LdapPreferences(Attributes attrs) throws UserRepositoryException {
        preference1 = AttributeUtilities.getAttributeDefinition(attrs,
                ldapMapping.getPreference1());
        preference2 = AttributeUtilities.getAttributeDefinition(attrs,
                ldapMapping.getPreference2());
        preference3 = AttributeUtilities.getAttributeDefinition(attrs,
                ldapMapping.getPreference3());
        preference4 = AttributeUtilities.getAttributeDefinition(attrs,
                ldapMapping.getPreference4());
    }

    // - public methods -------------------------------------------------------

    public Attributes toAttributes() {
        Attributes attrs = new BasicAttributes(true);

        AttributeUtilities.addPropertyToAttributes(
                ldapMapping.getPreference1(), preference1, attrs);
        AttributeUtilities.addPropertyToAttributes(
                ldapMapping.getPreference2(), preference2, attrs);
        AttributeUtilities.addPropertyToAttributes(
                ldapMapping.getPreference3(), preference3, attrs);
        AttributeUtilities.addPropertyToAttributes(
                ldapMapping.getPreference4(), preference4, attrs);

        return attrs;
    }

    // - getters and setters --------------------------------------------------

    public String getPreference1() {
        return preference1;
    }

    public void setPreference1(String preference1) {
        this.preference1 = preference1;
    }

    public String getPreference2() {
        return preference2;
    }

    public void setPreference2(String preference2) {
        this.preference2 = preference2;
    }

    public String getPreference3() {
        return preference3;
    }

    public void setPreference3(String preference3) {
        this.preference3 = preference3;
    }

    public String getPreference4() {
        return preference4;
    }

    public void setPreference4(String preference4) {
        this.preference4 = preference4;
    }
}
