/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.ldap;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirStateFactory;

import alma.userrepository.addressbook.ldap.beans.LdapAddress;
import alma.userrepository.addressbook.ldap.beans.LdapUser;

/**
 * @author Stewart
 * 
 */
public class UserRepositoryStateFactory implements DirStateFactory {

	public UserRepositoryStateFactory() {
	}

	// DirStateFactory version
	public DirStateFactory.Result getStateToBind(Object obj, Name name,
			Context ctx, Hashtable<?, ?> env, Attributes inAttrs)
			throws NamingException {

		if (obj instanceof LdapUser) {
			LdapUser user = (LdapUser) obj;
			Attributes outAttrs = user.toAttributes();
			return new DirStateFactory.Result(null, outAttrs);
		}

		if (obj instanceof LdapAddress) {
			LdapAddress address = (LdapAddress) obj;
			Attributes outAttrs = address.toAttributes();
			return new DirStateFactory.Result(null, outAttrs);
		}

		return null;
	}

	// StateFactory version
	public Object getStateToBind(Object obj, Name name, Context ctx,
			Hashtable<?, ?> env) throws NamingException {
		// non-Attributes version not relevant here
		return null;
	}

}
