/*
 * This class was automatically generated with 
 * <a href="http://www.castor.org">Castor 0.9.6</a>, using an XML
 * Schema.
 * $Id$
 */

package alma.acs.ncconfig;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import alma.acs.ncconfig.types.EventChannelConnectionReliabilityType;
import alma.acs.ncconfig.types.EventChannelDiscardPolicyType;
import alma.acs.ncconfig.types.EventChannelEventReliabilityType;
import alma.acs.ncconfig.types.EventChannelOrderPolicyType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.ContentHandler;

/**
 * Schema which describes an ACS event channel. At the moment, the
 * only info included here are some
 *  Quality of Service and Administrative properties that are
 * applicable to the type of notification channels ACS utilizes.
 *  All of the inline schema documentation found here is also
 * available in the ACS notification channel tutorial or
 *  directly from OMG -
 * http://www.omg.org/technology/documents/formal/notification_service.htm
 *  
 * 
 * @version $Revision$ $Date$
 */
public class EventChannel implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Giving this attribute a true value results in INFO logs for
     * every sending and receiving of an event.
     *  This produces a huge number of log messages, and is only
     * useful for debugging, but never in operations.
     *  @TODO: rename to something like "IsTraceEventsEnabled"
     * because the historic 
     *  coupling of tracing events with software integrations can
     * be misleading.
     *  
     */
    private boolean _integrationLogs = false;

    /**
     * keeps track of state for field: _integrationLogs
     */
    private boolean _has_integrationLogs;

    /**
     * The maximum number of events that will be queued by the
     *  channel before the channel begins discarding events
     * (according to the Discard
     *  Policy QoS parameter) or rejecting new events (depending on
     * the setting of the
     *  RejectNewEvents admin property) upon receipt of each new
     * event.
     *  
     */
    private long _maxQueueLength = 0;

    /**
     * keeps track of state for field: _maxQueueLength
     */
    private boolean _has_maxQueueLength;

    /**
     * The maximum number of consumers that can be connected to the
     *  channel at any given time.
     *  
     */
    private long _maxConsumers = 0;

    /**
     * keeps track of state for field: _maxConsumers
     */
    private boolean _has_maxConsumers;

    /**
     * The maximum number of suppliers that can be connected to the
     *  channel at any given time.
     *  
     */
    private long _maxSuppliers = 0;

    /**
     * keeps track of state for field: _maxSuppliers
     */
    private boolean _has_maxSuppliers;

    /**
     * This value associated with this property is of type Boolean,
     * where TRUE and
     *  FALSE have the following meanings:
     *  * TRUE: Attempts to push new events to the channel by
     * push-style suppliers will result 
     *  in the IMPL_LIMIT system exception being raised.
     *  * FALSE: When the total number of undelivered events within
     * the channel is equal to
     *  MaxQueueLength, attempts to push new events to the channel
     * by a push-style supplier will
     *  result in one of the currently queued undelivered events
     * being discarded by the
     *  channel to make room for the new event. The discarded event
     * will be chosen based
     *  on the setting of the DiscardPolicy QoS property.
     *  
     */
    private boolean _rejectNewEvents = true;

    /**
     * keeps track of state for field: _rejectNewEvents
     */
    private boolean _has_rejectNewEvents;

    /**
     * This QoS property enables a user of the Notification Service
     * to specify in what order
     *  the channel or a proxy supplier should begin discarding
     * events in the case of an
     *  internal buffer overflow. This property applies on a
     * per-channel basis only if it is set on
     *  a channel that has the RejectNewEvents admin property set
     * to FALSE. If set on such a
     *  channel, the chosen discard policy will be applied whenever
     * a supplier attempts to
     *  send a new event to the channel, and the total number of
     * events already queued within
     *  the channel is equal to the MaxQueueLength administrative
     * property. If set on a per-
     *  ConsumerAdmin basis, the chosen discard policy will be
     * applied whenever the number
     *  of events queued on behalf of one of the consumers
     * connected to one of the proxy
     *  suppliers created by the ConsumerAdmin exceeds the
     * MaxEventsPerConsumer
     *  setting for that consumer. If set on a per-proxy supplier
     * basis, the chosen discard policy
     *  will be applied whenever the number of events queued on
     * behalf of the consumer
     *  connected to the proxy supplier exceeds the
     * MaxEventsPerConsumer setting for
     *  that proxy supplier. Note that in these latter two cases,
     * an event will only be
     *  discarded with respect to its scheduled delivery to the
     * consumer(s) on whose behalf
     *  the policy is being applied. In other words, if the event
     * targeted for discarding is
     *  scheduled for delivery to any consumer(s) on whose behalf
     * the discard policy was not
     *  invoked, the event remains queued for those consumers.
     *  Constant values to represent the following settings are
     * defined:
     *  * AnyOrder - Any event may be discarded on overflow. This
     * is the default setting for this
     *  property.
     *  * FifoOrder - The first event received will be the first
     * discarded.
     *  * LifoOrder - The last event received will be the first
     * discarded.
     *  * PriorityOrder - Events should be discarded in priority
     * order, such that lower priority
     *  events will be discarded before higher priority events.
     *  * DeadlineOrder - Events should be discarded in the order
     * of shortest expiry deadline
     *  first.
     *  
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     */
    private alma.acs.ncconfig.types.EventChannelDiscardPolicyType _discardPolicy = alma.acs.ncconfig.types.EventChannelDiscardPolicyType.valueOf("AnyOrder");

    /**
     * The value portion of this attribute has two well-defined
     * settings: 
     *  BestEffort (0) and Persistent (1). If set to 0, event can
     * be
     *  treated as non-persistent and lost upon failure of the
     * channel. At least
     *  one attempt must be made to transmit the event to each
     * registered
     *  consumer, but in the case of a failure to send to any
     * consumer, no
     *  further action need be taken. If set to 1, channel should
     * make the
     *  event persistent, and attempt to retransmit upon channel
     * recovery
     *  from failure. This setting only has meaning when
     *  ConnectionReliability is also set to 1, in which the
     * combination
     *  essentially means guaranteed delivery.
     *  
     */
    private alma.acs.ncconfig.types.EventChannelEventReliabilityType _eventReliability = alma.acs.ncconfig.types.EventChannelEventReliabilityType.valueOf("BestEffort");

    /**
     * Connection reliability takes on the same enumerated values
     * as EventReliability.
     *  This property defines whether the connection to the
     * Notification Service between
     *  consumers and suppliers is persistent.
     *  
     */
    private alma.acs.ncconfig.types.EventChannelConnectionReliabilityType _connectionReliability = alma.acs.ncconfig.types.EventChannelConnectionReliabilityType.valueOf("BestEffort");

    /**
     * The event service does not define the order in which events
     * are delivered to a
     *  consumer. One way to be explicit is to allow delivery to be
     * based on the priority of an
     *  event. Priority is represented as a short value, where
     * -32,767 is the lowest priority and
     *  32,767 the highest. The default priority for all events is
     * 0. By default, the notification
     *  channel will attempt to deliver messages to consumers in
     * priority order.
     *  
     */
    private long _priority = 0;

    /**
     * keeps track of state for field: _priority
     */
    private boolean _has_priority;

    /**
     * Timeout, a TimeBase::TimeT encoded value, states a relative
     * expiry time (e.g., 10
     *  minutes from now), after which the event can be discarded.
     * It is possible for a
     *  consumer to override the value associated with this
     * property through the use of
     *  mapping filters. Note that the time value
     *  associated with the Timeout QoS property is viewed as
     * relative to the time when the
     *  channel (i.e., the receiving proxy consumer) first received
     * the event.
     *  
     */
    private long _timeout = 0;

    /**
     * keeps track of state for field: _timeout
     */
    private boolean _has_timeout;

    /**
     * This QoS property sets the policy used by a given proxy to
     * order the events it has
     *  buffered for delivery (either to another proxy or a
     * consumer). Constant values to
     *  represent the following settings are defined:
     *  * AnyOrder - Any ordering policy is permitted.
     *  * FifoOrder - Events should be delivered in the order of
     * their arrival.
     *  * PriorityOrder - Events should be buffered in priority
     * order, such that higher priority
     *  events will be delivered before lower priority events.
     *  * DeadlineOrder - Events should be buffered in the order of
     * shortest expiry deadline
     *  first, such that events that are destined to timeout
     * soonest should be delivered first.
     * 
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     */
    private alma.acs.ncconfig.types.EventChannelOrderPolicyType _orderPolicy = alma.acs.ncconfig.types.EventChannelOrderPolicyType.valueOf("AnyOrder");

    /**
     * QoS property is defined which has an associated boolean
     * value, indicating 
     *  whether or not the setting of StartTime on a per-message
     * basis is supported.
     *  
     */
    private boolean _startTimeSupported = false;

    /**
     * keeps track of state for field: _startTimeSupported
     */
    private boolean _has_startTimeSupported;

    /**
     * QoS property is defined that has an associated boolean
     * value, indicating whether 
     *  or not the setting of StopTime on a per-message basis is
     * supported.
     *  
     */
    private boolean _stopTimeSupported = false;

    /**
     * keeps track of state for field: _stopTimeSupported
     */
    private boolean _has_stopTimeSupported;

    /**
     * An administrative property can be set on the channel to
     * bound the maximum number of
     *  events a given channel is allowed to queue at any given
     * point in time. Note, however,
     *  that a single badly behaved consumer could result in the
     * channel holding the maximum
     *  number of events it is allowed to queue for an extended
     * period of time, preventing
     *  further event communication through the channel. Thus, the
     *  MaximumEventsPerConsumer property helps to avoid this
     * situation by bounding the
     *  maximum number of events the channel will queue on behalf
     * of a given consumer. If
     *  set only on a per-channel basis, the value of this property
     * applies to all consumers
     *  connected to the channel. If set on a per-ConsumerAdmin
     * basis, this property applies
     *  to all consumers connected to proxy suppliers created by
     * that ConsumerAdmin. If set
     *  on a per-proxy supplier basis, this property applies to the
     * consumer connected to the
     *  given proxy supplier. Note that setting this property on a
     * SupplierAdmin or proxy
     *  consumer has no meaning. Also note that the default setting
     * of this property is 0,
     *  meaning that the proxy imposes no limits on the maximum
     * number of events that may
     *  be queued for its consumer.
     *  
     */
    private long _maxEventsPerConsumer = 0;

    /**
     * keeps track of state for field: _maxEventsPerConsumer
     */
    private boolean _has_maxEventsPerConsumer;

    /**
     * Defines special properties of events. The "Name" attribute
     * of each Event should be unique.
     *  
     */
    private alma.acs.ncconfig.Events _events;


      //----------------/
     //- Constructors -/
    //----------------/

    public EventChannel() {
        super();
        setDiscardPolicy(alma.acs.ncconfig.types.EventChannelDiscardPolicyType.valueOf("AnyOrder"));
        setEventReliability(alma.acs.ncconfig.types.EventChannelEventReliabilityType.valueOf("BestEffort"));
        setConnectionReliability(alma.acs.ncconfig.types.EventChannelConnectionReliabilityType.valueOf("BestEffort"));
        setOrderPolicy(alma.acs.ncconfig.types.EventChannelOrderPolicyType.valueOf("AnyOrder"));
    } //-- alma.acs.ncconfig.EventChannel()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method deleteIntegrationLogs
     * 
     */
    public void deleteIntegrationLogs()
    {
        this._has_integrationLogs= false;
    } //-- void deleteIntegrationLogs() 

    /**
     * Method deleteMaxConsumers
     * 
     */
    public void deleteMaxConsumers()
    {
        this._has_maxConsumers= false;
    } //-- void deleteMaxConsumers() 

    /**
     * Method deleteMaxEventsPerConsumer
     * 
     */
    public void deleteMaxEventsPerConsumer()
    {
        this._has_maxEventsPerConsumer= false;
    } //-- void deleteMaxEventsPerConsumer() 

    /**
     * Method deleteMaxQueueLength
     * 
     */
    public void deleteMaxQueueLength()
    {
        this._has_maxQueueLength= false;
    } //-- void deleteMaxQueueLength() 

    /**
     * Method deleteMaxSuppliers
     * 
     */
    public void deleteMaxSuppliers()
    {
        this._has_maxSuppliers= false;
    } //-- void deleteMaxSuppliers() 

    /**
     * Method deletePriority
     * 
     */
    public void deletePriority()
    {
        this._has_priority= false;
    } //-- void deletePriority() 

    /**
     * Method deleteRejectNewEvents
     * 
     */
    public void deleteRejectNewEvents()
    {
        this._has_rejectNewEvents= false;
    } //-- void deleteRejectNewEvents() 

    /**
     * Method deleteStartTimeSupported
     * 
     */
    public void deleteStartTimeSupported()
    {
        this._has_startTimeSupported= false;
    } //-- void deleteStartTimeSupported() 

    /**
     * Method deleteStopTimeSupported
     * 
     */
    public void deleteStopTimeSupported()
    {
        this._has_stopTimeSupported= false;
    } //-- void deleteStopTimeSupported() 

    /**
     * Method deleteTimeout
     * 
     */
    public void deleteTimeout()
    {
        this._has_timeout= false;
    } //-- void deleteTimeout() 

    /**
     * Returns the value of field 'connectionReliability'. The
     * field 'connectionReliability' has the following description:
     * Connection reliability takes on the same enumerated values
     * as EventReliability.
     *  This property defines whether the connection to the
     * Notification Service between
     *  consumers and suppliers is persistent.
     *  
     * 
     * @return EventChannelConnectionReliabilityType
     * @return the value of field 'connectionReliability'.
     */
    public alma.acs.ncconfig.types.EventChannelConnectionReliabilityType getConnectionReliability()
    {
        return this._connectionReliability;
    } //-- alma.acs.ncconfig.types.EventChannelConnectionReliabilityType getConnectionReliability() 

    /**
     * Returns the value of field 'discardPolicy'. The field
     * 'discardPolicy' has the following description: This QoS
     * property enables a user of the Notification Service to
     * specify in what order
     *  the channel or a proxy supplier should begin discarding
     * events in the case of an
     *  internal buffer overflow. This property applies on a
     * per-channel basis only if it is set on
     *  a channel that has the RejectNewEvents admin property set
     * to FALSE. If set on such a
     *  channel, the chosen discard policy will be applied whenever
     * a supplier attempts to
     *  send a new event to the channel, and the total number of
     * events already queued within
     *  the channel is equal to the MaxQueueLength administrative
     * property. If set on a per-
     *  ConsumerAdmin basis, the chosen discard policy will be
     * applied whenever the number
     *  of events queued on behalf of one of the consumers
     * connected to one of the proxy
     *  suppliers created by the ConsumerAdmin exceeds the
     * MaxEventsPerConsumer
     *  setting for that consumer. If set on a per-proxy supplier
     * basis, the chosen discard policy
     *  will be applied whenever the number of events queued on
     * behalf of the consumer
     *  connected to the proxy supplier exceeds the
     * MaxEventsPerConsumer setting for
     *  that proxy supplier. Note that in these latter two cases,
     * an event will only be
     *  discarded with respect to its scheduled delivery to the
     * consumer(s) on whose behalf
     *  the policy is being applied. In other words, if the event
     * targeted for discarding is
     *  scheduled for delivery to any consumer(s) on whose behalf
     * the discard policy was not
     *  invoked, the event remains queued for those consumers.
     *  Constant values to represent the following settings are
     * defined:
     *  * AnyOrder - Any event may be discarded on overflow. This
     * is the default setting for this
     *  property.
     *  * FifoOrder - The first event received will be the first
     * discarded.
     *  * LifoOrder - The last event received will be the first
     * discarded.
     *  * PriorityOrder - Events should be discarded in priority
     * order, such that lower priority
     *  events will be discarded before higher priority events.
     *  * DeadlineOrder - Events should be discarded in the order
     * of shortest expiry deadline
     *  first.
     *  
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     * 
     * @return EventChannelDiscardPolicyType
     * @return the value of field 'discardPolicy'.
     */
    public alma.acs.ncconfig.types.EventChannelDiscardPolicyType getDiscardPolicy()
    {
        return this._discardPolicy;
    } //-- alma.acs.ncconfig.types.EventChannelDiscardPolicyType getDiscardPolicy() 

    /**
     * Returns the value of field 'eventReliability'. The field
     * 'eventReliability' has the following description: The value
     * portion of this attribute has two well-defined settings: 
     *  BestEffort (0) and Persistent (1). If set to 0, event can
     * be
     *  treated as non-persistent and lost upon failure of the
     * channel. At least
     *  one attempt must be made to transmit the event to each
     * registered
     *  consumer, but in the case of a failure to send to any
     * consumer, no
     *  further action need be taken. If set to 1, channel should
     * make the
     *  event persistent, and attempt to retransmit upon channel
     * recovery
     *  from failure. This setting only has meaning when
     *  ConnectionReliability is also set to 1, in which the
     * combination
     *  essentially means guaranteed delivery.
     *  
     * 
     * @return EventChannelEventReliabilityType
     * @return the value of field 'eventReliability'.
     */
    public alma.acs.ncconfig.types.EventChannelEventReliabilityType getEventReliability()
    {
        return this._eventReliability;
    } //-- alma.acs.ncconfig.types.EventChannelEventReliabilityType getEventReliability() 

    /**
     * Returns the value of field 'events'. The field 'events' has
     * the following description: Defines special properties of
     * events. The "Name" attribute of each Event should be unique.
     *  
     * 
     * @return Events
     * @return the value of field 'events'.
     */
    public alma.acs.ncconfig.Events getEvents()
    {
        return this._events;
    } //-- alma.acs.ncconfig.Events getEvents() 

    /**
     * Returns the value of field 'integrationLogs'. The field
     * 'integrationLogs' has the following description: Giving this
     * attribute a true value results in INFO logs for every
     * sending and receiving of an event.
     *  This produces a huge number of log messages, and is only
     * useful for debugging, but never in operations.
     *  @TODO: rename to something like "IsTraceEventsEnabled"
     * because the historic 
     *  coupling of tracing events with software integrations can
     * be misleading.
     *  
     * 
     * @return boolean
     * @return the value of field 'integrationLogs'.
     */
    public boolean getIntegrationLogs()
    {
        return this._integrationLogs;
    } //-- boolean getIntegrationLogs() 

    /**
     * Returns the value of field 'maxConsumers'. The field
     * 'maxConsumers' has the following description: The maximum
     * number of consumers that can be connected to the
     *  channel at any given time.
     *  
     * 
     * @return long
     * @return the value of field 'maxConsumers'.
     */
    public long getMaxConsumers()
    {
        return this._maxConsumers;
    } //-- long getMaxConsumers() 

    /**
     * Returns the value of field 'maxEventsPerConsumer'. The field
     * 'maxEventsPerConsumer' has the following description: An
     * administrative property can be set on the channel to bound
     * the maximum number of
     *  events a given channel is allowed to queue at any given
     * point in time. Note, however,
     *  that a single badly behaved consumer could result in the
     * channel holding the maximum
     *  number of events it is allowed to queue for an extended
     * period of time, preventing
     *  further event communication through the channel. Thus, the
     *  MaximumEventsPerConsumer property helps to avoid this
     * situation by bounding the
     *  maximum number of events the channel will queue on behalf
     * of a given consumer. If
     *  set only on a per-channel basis, the value of this property
     * applies to all consumers
     *  connected to the channel. If set on a per-ConsumerAdmin
     * basis, this property applies
     *  to all consumers connected to proxy suppliers created by
     * that ConsumerAdmin. If set
     *  on a per-proxy supplier basis, this property applies to the
     * consumer connected to the
     *  given proxy supplier. Note that setting this property on a
     * SupplierAdmin or proxy
     *  consumer has no meaning. Also note that the default setting
     * of this property is 0,
     *  meaning that the proxy imposes no limits on the maximum
     * number of events that may
     *  be queued for its consumer.
     *  
     * 
     * @return long
     * @return the value of field 'maxEventsPerConsumer'.
     */
    public long getMaxEventsPerConsumer()
    {
        return this._maxEventsPerConsumer;
    } //-- long getMaxEventsPerConsumer() 

    /**
     * Returns the value of field 'maxQueueLength'. The field
     * 'maxQueueLength' has the following description: The maximum
     * number of events that will be queued by the
     *  channel before the channel begins discarding events
     * (according to the Discard
     *  Policy QoS parameter) or rejecting new events (depending on
     * the setting of the
     *  RejectNewEvents admin property) upon receipt of each new
     * event.
     *  
     * 
     * @return long
     * @return the value of field 'maxQueueLength'.
     */
    public long getMaxQueueLength()
    {
        return this._maxQueueLength;
    } //-- long getMaxQueueLength() 

    /**
     * Returns the value of field 'maxSuppliers'. The field
     * 'maxSuppliers' has the following description: The maximum
     * number of suppliers that can be connected to the
     *  channel at any given time.
     *  
     * 
     * @return long
     * @return the value of field 'maxSuppliers'.
     */
    public long getMaxSuppliers()
    {
        return this._maxSuppliers;
    } //-- long getMaxSuppliers() 

    /**
     * Returns the value of field 'orderPolicy'. The field
     * 'orderPolicy' has the following description: This QoS
     * property sets the policy used by a given proxy to order the
     * events it has
     *  buffered for delivery (either to another proxy or a
     * consumer). Constant values to
     *  represent the following settings are defined:
     *  * AnyOrder - Any ordering policy is permitted.
     *  * FifoOrder - Events should be delivered in the order of
     * their arrival.
     *  * PriorityOrder - Events should be buffered in priority
     * order, such that higher priority
     *  events will be delivered before lower priority events.
     *  * DeadlineOrder - Events should be buffered in the order of
     * shortest expiry deadline
     *  first, such that events that are destined to timeout
     * soonest should be delivered first.
     * 
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     * 
     * @return EventChannelOrderPolicyType
     * @return the value of field 'orderPolicy'.
     */
    public alma.acs.ncconfig.types.EventChannelOrderPolicyType getOrderPolicy()
    {
        return this._orderPolicy;
    } //-- alma.acs.ncconfig.types.EventChannelOrderPolicyType getOrderPolicy() 

    /**
     * Returns the value of field 'priority'. The field 'priority'
     * has the following description: The event service does not
     * define the order in which events are delivered to a
     *  consumer. One way to be explicit is to allow delivery to be
     * based on the priority of an
     *  event. Priority is represented as a short value, where
     * -32,767 is the lowest priority and
     *  32,767 the highest. The default priority for all events is
     * 0. By default, the notification
     *  channel will attempt to deliver messages to consumers in
     * priority order.
     *  
     * 
     * @return long
     * @return the value of field 'priority'.
     */
    public long getPriority()
    {
        return this._priority;
    } //-- long getPriority() 

    /**
     * Returns the value of field 'rejectNewEvents'. The field
     * 'rejectNewEvents' has the following description: This value
     * associated with this property is of type Boolean, where TRUE
     * and
     *  FALSE have the following meanings:
     *  * TRUE: Attempts to push new events to the channel by
     * push-style suppliers will result 
     *  in the IMPL_LIMIT system exception being raised.
     *  * FALSE: When the total number of undelivered events within
     * the channel is equal to
     *  MaxQueueLength, attempts to push new events to the channel
     * by a push-style supplier will
     *  result in one of the currently queued undelivered events
     * being discarded by the
     *  channel to make room for the new event. The discarded event
     * will be chosen based
     *  on the setting of the DiscardPolicy QoS property.
     *  
     * 
     * @return boolean
     * @return the value of field 'rejectNewEvents'.
     */
    public boolean getRejectNewEvents()
    {
        return this._rejectNewEvents;
    } //-- boolean getRejectNewEvents() 

    /**
     * Returns the value of field 'startTimeSupported'. The field
     * 'startTimeSupported' has the following description: QoS
     * property is defined which has an associated boolean value,
     * indicating 
     *  whether or not the setting of StartTime on a per-message
     * basis is supported.
     *  
     * 
     * @return boolean
     * @return the value of field 'startTimeSupported'.
     */
    public boolean getStartTimeSupported()
    {
        return this._startTimeSupported;
    } //-- boolean getStartTimeSupported() 

    /**
     * Returns the value of field 'stopTimeSupported'. The field
     * 'stopTimeSupported' has the following description: QoS
     * property is defined that has an associated boolean value,
     * indicating whether 
     *  or not the setting of StopTime on a per-message basis is
     * supported.
     *  
     * 
     * @return boolean
     * @return the value of field 'stopTimeSupported'.
     */
    public boolean getStopTimeSupported()
    {
        return this._stopTimeSupported;
    } //-- boolean getStopTimeSupported() 

    /**
     * Returns the value of field 'timeout'. The field 'timeout'
     * has the following description: Timeout, a TimeBase::TimeT
     * encoded value, states a relative expiry time (e.g., 10
     *  minutes from now), after which the event can be discarded.
     * It is possible for a
     *  consumer to override the value associated with this
     * property through the use of
     *  mapping filters. Note that the time value
     *  associated with the Timeout QoS property is viewed as
     * relative to the time when the
     *  channel (i.e., the receiving proxy consumer) first received
     * the event.
     *  
     * 
     * @return long
     * @return the value of field 'timeout'.
     */
    public long getTimeout()
    {
        return this._timeout;
    } //-- long getTimeout() 

    /**
     * Method hasIntegrationLogs
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasIntegrationLogs()
    {
        return this._has_integrationLogs;
    } //-- boolean hasIntegrationLogs() 

    /**
     * Method hasMaxConsumers
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasMaxConsumers()
    {
        return this._has_maxConsumers;
    } //-- boolean hasMaxConsumers() 

    /**
     * Method hasMaxEventsPerConsumer
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasMaxEventsPerConsumer()
    {
        return this._has_maxEventsPerConsumer;
    } //-- boolean hasMaxEventsPerConsumer() 

    /**
     * Method hasMaxQueueLength
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasMaxQueueLength()
    {
        return this._has_maxQueueLength;
    } //-- boolean hasMaxQueueLength() 

    /**
     * Method hasMaxSuppliers
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasMaxSuppliers()
    {
        return this._has_maxSuppliers;
    } //-- boolean hasMaxSuppliers() 

    /**
     * Method hasPriority
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasPriority()
    {
        return this._has_priority;
    } //-- boolean hasPriority() 

    /**
     * Method hasRejectNewEvents
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasRejectNewEvents()
    {
        return this._has_rejectNewEvents;
    } //-- boolean hasRejectNewEvents() 

    /**
     * Method hasStartTimeSupported
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasStartTimeSupported()
    {
        return this._has_startTimeSupported;
    } //-- boolean hasStartTimeSupported() 

    /**
     * Method hasStopTimeSupported
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasStopTimeSupported()
    {
        return this._has_stopTimeSupported;
    } //-- boolean hasStopTimeSupported() 

    /**
     * Method hasTimeout
     * 
     * 
     * 
     * @return boolean
     */
    public boolean hasTimeout()
    {
        return this._has_timeout;
    } //-- boolean hasTimeout() 

    /**
     * Method isValid
     * 
     * 
     * 
     * @return boolean
     */
    public boolean isValid()
    {
        try {
            validate();
        }
        catch (org.exolab.castor.xml.ValidationException vex) {
            return false;
        }
        return true;
    } //-- boolean isValid() 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param out
     */
    public void marshal(java.io.Writer out)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, out);
    } //-- void marshal(java.io.Writer) 

    /**
     * Method marshal
     * 
     * 
     * 
     * @param handler
     */
    public void marshal(org.xml.sax.ContentHandler handler)
        throws java.io.IOException, org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        
        Marshaller.marshal(this, handler);
    } //-- void marshal(org.xml.sax.ContentHandler) 

    /**
     * Sets the value of field 'connectionReliability'. The field
     * 'connectionReliability' has the following description:
     * Connection reliability takes on the same enumerated values
     * as EventReliability.
     *  This property defines whether the connection to the
     * Notification Service between
     *  consumers and suppliers is persistent.
     *  
     * 
     * @param connectionReliability the value of field
     * 'connectionReliability'.
     */
    public void setConnectionReliability(alma.acs.ncconfig.types.EventChannelConnectionReliabilityType connectionReliability)
    {
        this._connectionReliability = connectionReliability;
    } //-- void setConnectionReliability(alma.acs.ncconfig.types.EventChannelConnectionReliabilityType) 

    /**
     * Sets the value of field 'discardPolicy'. The field
     * 'discardPolicy' has the following description: This QoS
     * property enables a user of the Notification Service to
     * specify in what order
     *  the channel or a proxy supplier should begin discarding
     * events in the case of an
     *  internal buffer overflow. This property applies on a
     * per-channel basis only if it is set on
     *  a channel that has the RejectNewEvents admin property set
     * to FALSE. If set on such a
     *  channel, the chosen discard policy will be applied whenever
     * a supplier attempts to
     *  send a new event to the channel, and the total number of
     * events already queued within
     *  the channel is equal to the MaxQueueLength administrative
     * property. If set on a per-
     *  ConsumerAdmin basis, the chosen discard policy will be
     * applied whenever the number
     *  of events queued on behalf of one of the consumers
     * connected to one of the proxy
     *  suppliers created by the ConsumerAdmin exceeds the
     * MaxEventsPerConsumer
     *  setting for that consumer. If set on a per-proxy supplier
     * basis, the chosen discard policy
     *  will be applied whenever the number of events queued on
     * behalf of the consumer
     *  connected to the proxy supplier exceeds the
     * MaxEventsPerConsumer setting for
     *  that proxy supplier. Note that in these latter two cases,
     * an event will only be
     *  discarded with respect to its scheduled delivery to the
     * consumer(s) on whose behalf
     *  the policy is being applied. In other words, if the event
     * targeted for discarding is
     *  scheduled for delivery to any consumer(s) on whose behalf
     * the discard policy was not
     *  invoked, the event remains queued for those consumers.
     *  Constant values to represent the following settings are
     * defined:
     *  * AnyOrder - Any event may be discarded on overflow. This
     * is the default setting for this
     *  property.
     *  * FifoOrder - The first event received will be the first
     * discarded.
     *  * LifoOrder - The last event received will be the first
     * discarded.
     *  * PriorityOrder - Events should be discarded in priority
     * order, such that lower priority
     *  events will be discarded before higher priority events.
     *  * DeadlineOrder - Events should be discarded in the order
     * of shortest expiry deadline
     *  first.
     *  
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     * 
     * @param discardPolicy the value of field 'discardPolicy'.
     */
    public void setDiscardPolicy(alma.acs.ncconfig.types.EventChannelDiscardPolicyType discardPolicy)
    {
        this._discardPolicy = discardPolicy;
    } //-- void setDiscardPolicy(alma.acs.ncconfig.types.EventChannelDiscardPolicyType) 

    /**
     * Sets the value of field 'eventReliability'. The field
     * 'eventReliability' has the following description: The value
     * portion of this attribute has two well-defined settings: 
     *  BestEffort (0) and Persistent (1). If set to 0, event can
     * be
     *  treated as non-persistent and lost upon failure of the
     * channel. At least
     *  one attempt must be made to transmit the event to each
     * registered
     *  consumer, but in the case of a failure to send to any
     * consumer, no
     *  further action need be taken. If set to 1, channel should
     * make the
     *  event persistent, and attempt to retransmit upon channel
     * recovery
     *  from failure. This setting only has meaning when
     *  ConnectionReliability is also set to 1, in which the
     * combination
     *  essentially means guaranteed delivery.
     *  
     * 
     * @param eventReliability the value of field 'eventReliability'
     */
    public void setEventReliability(alma.acs.ncconfig.types.EventChannelEventReliabilityType eventReliability)
    {
        this._eventReliability = eventReliability;
    } //-- void setEventReliability(alma.acs.ncconfig.types.EventChannelEventReliabilityType) 

    /**
     * Sets the value of field 'events'. The field 'events' has the
     * following description: Defines special properties of events.
     * The "Name" attribute of each Event should be unique.
     *  
     * 
     * @param events the value of field 'events'.
     */
    public void setEvents(alma.acs.ncconfig.Events events)
    {
        this._events = events;
    } //-- void setEvents(alma.acs.ncconfig.Events) 

    /**
     * Sets the value of field 'integrationLogs'. The field
     * 'integrationLogs' has the following description: Giving this
     * attribute a true value results in INFO logs for every
     * sending and receiving of an event.
     *  This produces a huge number of log messages, and is only
     * useful for debugging, but never in operations.
     *  @TODO: rename to something like "IsTraceEventsEnabled"
     * because the historic 
     *  coupling of tracing events with software integrations can
     * be misleading.
     *  
     * 
     * @param integrationLogs the value of field 'integrationLogs'.
     */
    public void setIntegrationLogs(boolean integrationLogs)
    {
        this._integrationLogs = integrationLogs;
        this._has_integrationLogs = true;
    } //-- void setIntegrationLogs(boolean) 

    /**
     * Sets the value of field 'maxConsumers'. The field
     * 'maxConsumers' has the following description: The maximum
     * number of consumers that can be connected to the
     *  channel at any given time.
     *  
     * 
     * @param maxConsumers the value of field 'maxConsumers'.
     */
    public void setMaxConsumers(long maxConsumers)
    {
        this._maxConsumers = maxConsumers;
        this._has_maxConsumers = true;
    } //-- void setMaxConsumers(long) 

    /**
     * Sets the value of field 'maxEventsPerConsumer'. The field
     * 'maxEventsPerConsumer' has the following description: An
     * administrative property can be set on the channel to bound
     * the maximum number of
     *  events a given channel is allowed to queue at any given
     * point in time. Note, however,
     *  that a single badly behaved consumer could result in the
     * channel holding the maximum
     *  number of events it is allowed to queue for an extended
     * period of time, preventing
     *  further event communication through the channel. Thus, the
     *  MaximumEventsPerConsumer property helps to avoid this
     * situation by bounding the
     *  maximum number of events the channel will queue on behalf
     * of a given consumer. If
     *  set only on a per-channel basis, the value of this property
     * applies to all consumers
     *  connected to the channel. If set on a per-ConsumerAdmin
     * basis, this property applies
     *  to all consumers connected to proxy suppliers created by
     * that ConsumerAdmin. If set
     *  on a per-proxy supplier basis, this property applies to the
     * consumer connected to the
     *  given proxy supplier. Note that setting this property on a
     * SupplierAdmin or proxy
     *  consumer has no meaning. Also note that the default setting
     * of this property is 0,
     *  meaning that the proxy imposes no limits on the maximum
     * number of events that may
     *  be queued for its consumer.
     *  
     * 
     * @param maxEventsPerConsumer the value of field
     * 'maxEventsPerConsumer'.
     */
    public void setMaxEventsPerConsumer(long maxEventsPerConsumer)
    {
        this._maxEventsPerConsumer = maxEventsPerConsumer;
        this._has_maxEventsPerConsumer = true;
    } //-- void setMaxEventsPerConsumer(long) 

    /**
     * Sets the value of field 'maxQueueLength'. The field
     * 'maxQueueLength' has the following description: The maximum
     * number of events that will be queued by the
     *  channel before the channel begins discarding events
     * (according to the Discard
     *  Policy QoS parameter) or rejecting new events (depending on
     * the setting of the
     *  RejectNewEvents admin property) upon receipt of each new
     * event.
     *  
     * 
     * @param maxQueueLength the value of field 'maxQueueLength'.
     */
    public void setMaxQueueLength(long maxQueueLength)
    {
        this._maxQueueLength = maxQueueLength;
        this._has_maxQueueLength = true;
    } //-- void setMaxQueueLength(long) 

    /**
     * Sets the value of field 'maxSuppliers'. The field
     * 'maxSuppliers' has the following description: The maximum
     * number of suppliers that can be connected to the
     *  channel at any given time.
     *  
     * 
     * @param maxSuppliers the value of field 'maxSuppliers'.
     */
    public void setMaxSuppliers(long maxSuppliers)
    {
        this._maxSuppliers = maxSuppliers;
        this._has_maxSuppliers = true;
    } //-- void setMaxSuppliers(long) 

    /**
     * Sets the value of field 'orderPolicy'. The field
     * 'orderPolicy' has the following description: This QoS
     * property sets the policy used by a given proxy to order the
     * events it has
     *  buffered for delivery (either to another proxy or a
     * consumer). Constant values to
     *  represent the following settings are defined:
     *  * AnyOrder - Any ordering policy is permitted.
     *  * FifoOrder - Events should be delivered in the order of
     * their arrival.
     *  * PriorityOrder - Events should be buffered in priority
     * order, such that higher priority
     *  events will be delivered before lower priority events.
     *  * DeadlineOrder - Events should be buffered in the order of
     * shortest expiry deadline
     *  first, such that events that are destined to timeout
     * soonest should be delivered first.
     * 
     *  Note that this property has no meaning if set on a
     * per-message basis.
     *  
     * 
     * @param orderPolicy the value of field 'orderPolicy'.
     */
    public void setOrderPolicy(alma.acs.ncconfig.types.EventChannelOrderPolicyType orderPolicy)
    {
        this._orderPolicy = orderPolicy;
    } //-- void setOrderPolicy(alma.acs.ncconfig.types.EventChannelOrderPolicyType) 

    /**
     * Sets the value of field 'priority'. The field 'priority' has
     * the following description: The event service does not define
     * the order in which events are delivered to a
     *  consumer. One way to be explicit is to allow delivery to be
     * based on the priority of an
     *  event. Priority is represented as a short value, where
     * -32,767 is the lowest priority and
     *  32,767 the highest. The default priority for all events is
     * 0. By default, the notification
     *  channel will attempt to deliver messages to consumers in
     * priority order.
     *  
     * 
     * @param priority the value of field 'priority'.
     */
    public void setPriority(long priority)
    {
        this._priority = priority;
        this._has_priority = true;
    } //-- void setPriority(long) 

    /**
     * Sets the value of field 'rejectNewEvents'. The field
     * 'rejectNewEvents' has the following description: This value
     * associated with this property is of type Boolean, where TRUE
     * and
     *  FALSE have the following meanings:
     *  * TRUE: Attempts to push new events to the channel by
     * push-style suppliers will result 
     *  in the IMPL_LIMIT system exception being raised.
     *  * FALSE: When the total number of undelivered events within
     * the channel is equal to
     *  MaxQueueLength, attempts to push new events to the channel
     * by a push-style supplier will
     *  result in one of the currently queued undelivered events
     * being discarded by the
     *  channel to make room for the new event. The discarded event
     * will be chosen based
     *  on the setting of the DiscardPolicy QoS property.
     *  
     * 
     * @param rejectNewEvents the value of field 'rejectNewEvents'.
     */
    public void setRejectNewEvents(boolean rejectNewEvents)
    {
        this._rejectNewEvents = rejectNewEvents;
        this._has_rejectNewEvents = true;
    } //-- void setRejectNewEvents(boolean) 

    /**
     * Sets the value of field 'startTimeSupported'. The field
     * 'startTimeSupported' has the following description: QoS
     * property is defined which has an associated boolean value,
     * indicating 
     *  whether or not the setting of StartTime on a per-message
     * basis is supported.
     *  
     * 
     * @param startTimeSupported the value of field
     * 'startTimeSupported'.
     */
    public void setStartTimeSupported(boolean startTimeSupported)
    {
        this._startTimeSupported = startTimeSupported;
        this._has_startTimeSupported = true;
    } //-- void setStartTimeSupported(boolean) 

    /**
     * Sets the value of field 'stopTimeSupported'. The field
     * 'stopTimeSupported' has the following description: QoS
     * property is defined that has an associated boolean value,
     * indicating whether 
     *  or not the setting of StopTime on a per-message basis is
     * supported.
     *  
     * 
     * @param stopTimeSupported the value of field
     * 'stopTimeSupported'.
     */
    public void setStopTimeSupported(boolean stopTimeSupported)
    {
        this._stopTimeSupported = stopTimeSupported;
        this._has_stopTimeSupported = true;
    } //-- void setStopTimeSupported(boolean) 

    /**
     * Sets the value of field 'timeout'. The field 'timeout' has
     * the following description: Timeout, a TimeBase::TimeT
     * encoded value, states a relative expiry time (e.g., 10
     *  minutes from now), after which the event can be discarded.
     * It is possible for a
     *  consumer to override the value associated with this
     * property through the use of
     *  mapping filters. Note that the time value
     *  associated with the Timeout QoS property is viewed as
     * relative to the time when the
     *  channel (i.e., the receiving proxy consumer) first received
     * the event.
     *  
     * 
     * @param timeout the value of field 'timeout'.
     */
    public void setTimeout(long timeout)
    {
        this._timeout = timeout;
        this._has_timeout = true;
    } //-- void setTimeout(long) 

    /**
     * Method unmarshalEventChannel
     * 
     * 
     * 
     * @param reader
     * @return EventChannel
     */
    public static alma.acs.ncconfig.EventChannel unmarshalEventChannel(java.io.Reader reader)
        throws org.exolab.castor.xml.MarshalException, org.exolab.castor.xml.ValidationException
    {
        return (alma.acs.ncconfig.EventChannel) Unmarshaller.unmarshal(alma.acs.ncconfig.EventChannel.class, reader);
    } //-- alma.acs.ncconfig.EventChannel unmarshalEventChannel(java.io.Reader) 

    /**
     * Method validate
     * 
     */
    public void validate()
        throws org.exolab.castor.xml.ValidationException
    {
        org.exolab.castor.xml.Validator validator = new org.exolab.castor.xml.Validator();
        validator.validate(this);
    } //-- void validate() 

}
