package alma.acs.tmcdb.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableInheritance_SwCore extends AbstractTableInheritance {

	public TableInheritance_SwCore() {

		map = new HashMap<String, String>();
			map.put("computer", "NetworkDevice");

		keymap = new HashMap<String, String>();
			keymap.put("computer","computernetwordfkey");

		List<String> keyColumns;
		keyColumnsMap = new HashMap<String, List<String>>();
				keyColumns = new ArrayList<String>();
				keyColumns.add("networkdeviceid");
			keyColumnsMap.put("computer", keyColumns);

		List<String> keyPieces;
		keyPiecesMap = new HashMap<String, List<String>>();
				keyPieces = new ArrayList<String>();
				keyPieces.add("idl");
			keyPiecesMap.put("componenttype", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("configurationname");
			keyPiecesMap.put("configuration", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("urn");
				keyPieces.add("configurationid");
			keyPiecesMap.put("schemas", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("networkname");
				keyPieces.add("configurationid");
			keyPiecesMap.put("networkdevice", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("loggingconfigid");
				keyPieces.add("name");
			keyPiecesMap.put("namedloggerconfig", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("configurationid");
				keyPieces.add("loggingconfigid");
				keyPieces.add("startup");
				keyPieces.add("servicecomponents");
				keyPieces.add("timeout");
				keyPieces.add("clientpinginterval");
				keyPieces.add("administratorpinginterval");
				keyPieces.add("containerpinginterval");
				keyPieces.add("serverthreads");
				keyPieces.add("deadlocktimeout");
			keyPiecesMap.put("manager", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("containername");
				keyPieces.add("path");
				keyPieces.add("configurationid");
			keyPiecesMap.put("container", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("path");
				keyPieces.add("componentname");
				keyPieces.add("configurationid");
			keyPiecesMap.put("component", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("propertyname");
				keyPieces.add("componentid");
			keyPiecesMap.put("baciproperty", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("building");
				keyPieces.add("floor");
				keyPieces.add("room");
				keyPieces.add("mnemonic");
				keyPieces.add("locationposition");
			keyPiecesMap.put("location", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("contactname");
			keyPiecesMap.put("contact", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("alarmcategoryname");
				keyPieces.add("configurationid");
			keyPiecesMap.put("alarmcategory", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("familyname");
				keyPieces.add("configurationid");
			keyPiecesMap.put("faultfamily", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("membername");
				keyPieces.add("faultfamilyid");
			keyPiecesMap.put("faultmember", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("faultfamilyid");
			keyPiecesMap.put("defaultmember", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("faultfamilyid");
				keyPieces.add("codevalue");
			keyPiecesMap.put("faultcode", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("faultmemberid");
				keyPieces.add("faultcodeid");
			keyPiecesMap.put("alarmdefinition", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("name");
				keyPieces.add("path");
				keyPieces.add("configurationid");
			keyPiecesMap.put("eventchannel", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("eventchannelid");
				keyPieces.add("name");
			keyPiecesMap.put("event", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("configurationid");
			keyPiecesMap.put("notificationservicemapping", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("notificationservicemappingid");
				keyPieces.add("name");
			keyPiecesMap.put("domainsmapping", keyPieces);
				keyPieces = new ArrayList<String>();
				keyPieces.add("notificationservicemappingid");
				keyPieces.add("name");
			keyPiecesMap.put("channelmapping", keyPieces);

		cascadingTypes = new HashMap<String, CascadeType>();
			cascadingTypes.put("schemasconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("networkdeviceconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("namedloggerconfigloggingconfig", CascadeType.AGGREGATION);
			cascadingTypes.put("managerloggingconfig", CascadeType.AGGREGATION);
			cascadingTypes.put("managerconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("containerconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("containerloggingconfig", CascadeType.AGGREGATION);
			cascadingTypes.put("containercomputer", CascadeType.AGGREGATION);
			cascadingTypes.put("contstartoptcontainer", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("componentidl", CascadeType.NONE);
			cascadingTypes.put("componentcontainer", CascadeType.NONE);
			cascadingTypes.put("componentconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("bacipropertycompid", CascadeType.COMPOSITION_INVERSE);
			cascadingTypes.put("alarmcategoryconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("faultfamilycontact", CascadeType.AGGREGATION);
			cascadingTypes.put("faultfamilyconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("acfcategoryid", CascadeType.AGGREGATION);
			cascadingTypes.put("acffamilyid", CascadeType.AGGREGATION);
			cascadingTypes.put("faultmemfamilyref", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("faultmemlocationref", CascadeType.AGGREGATION);
			cascadingTypes.put("defaultmemberfaultfamilyref", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("defaultmemberlocationref", CascadeType.AGGREGATION);
			cascadingTypes.put("codefaultfamilyref", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("alarmdefmmemberref", CascadeType.AGGREGATION);
			cascadingTypes.put("alarmdefcoderef", CascadeType.AGGREGATION);
			cascadingTypes.put("rlparentref", CascadeType.AGGREGATION);
			cascadingTypes.put("rlchildref", CascadeType.AGGREGATION);
			cascadingTypes.put("reductionlinkconfig", CascadeType.NONE);
			cascadingTypes.put("rtalarmref", CascadeType.AGGREGATION);
			cascadingTypes.put("rtconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("eventchannelconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("eventeventchannelref", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("notservmapconfig", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("domainsnotservmapref", CascadeType.AGGREGATION_INVERSE);
			cascadingTypes.put("channelnotservmapref", CascadeType.AGGREGATION_INVERSE);

		List<String> xmlClobColumns;
		xmlClobTableColumns = new HashMap<String, List<String>>();
				xmlClobColumns = new ArrayList<String>();
				xmlClobColumns.add("schema");
			xmlClobTableColumns.put("schemas", xmlClobColumns);
				xmlClobColumns = new ArrayList<String>();
				xmlClobColumns.add("xmldoc");
			xmlClobTableColumns.put("component", xmlClobColumns);

		sequences = new HashMap<String, String>();
			sequences.put("componenttype", "ComponT_seq");
			sequences.put("configuration", "Config_seq");
			sequences.put("schemas", "Schemas_seq");
			sequences.put("networkdevice", "NetworD_seq");
			sequences.put("loggingconfig", "LogginC_seq");
			sequences.put("namedloggerconfig", "NamedLC_seq");
			sequences.put("manager", "Manager_seq");
			sequences.put("container", "Container_seq");
			sequences.put("containerstartupoption", "ContaiSO_seq");
			sequences.put("component", "Component_seq");
			sequences.put("baciproperty", "BACIProperty_seq");
			sequences.put("location", "Location_seq");
			sequences.put("contact", "Contact_seq");
			sequences.put("alarmcategory", "AlarmC_seq");
			sequences.put("faultfamily", "FaultFamily_seq");
			sequences.put("faultmember", "FaultMember_seq");
			sequences.put("defaultmember", "DefaulM_seq");
			sequences.put("faultcode", "FaultCode_seq");
			sequences.put("alarmdefinition", "AlarmD_seq");
			sequences.put("eventchannel", "EventChannel_seq");
			sequences.put("event", "Event_seq");
			sequences.put("notificationservicemapping", "NotifiSM_seq");
			sequences.put("domainsmapping", "DomainM_seq");
			sequences.put("channelmapping", "ChanneM_seq");

		duplicatedForeignKeys = new HashMap<String, String>();

	}
}
