/*
 * 	  Created on 07-Oct-2003
 * 
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 */
package alma.archive.components;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.ComponentImplBase;
import alma.xmlstore.Administrative;
import alma.xmlstore.AdministrativeHelper;
import alma.xmlstore.AdministrativePOATie;
import alma.xmlstore.ArchiveConnectionOperations;
import alma.xmlstore.Operational;
import alma.xmlstore.OperationalHelper;
import alma.xmlstore.OperationalPOATie;
import alma.xmlstore.ArchiveConnectionPackage.ArchiveException;
import alma.xmlstore.ArchiveConnectionPackage.PermissionException;
import alma.xmlstore.ArchiveConnectionPackage.UserDoesNotExistException;

/**
 * @author simon
 * 
 * Used to create the initial connection to the Archive, the calls to return
 * individual components require a user.
 */
public class ArchiveConnectionImpl 
	extends ComponentImplBase 
	implements ArchiveConnectionOperations
{
//	private String componentName;
//	
//	public ArchiveConnectionImpl() {super();}
//	
//	public void setComponentName(String name)
//	{
//		componentName = name;
//	}

//	public void setLogger(Logger logger)
//	{
//		this.logger = logger;
//	}

//	public void initialize(ContainerServices containerServices) 
//	throws 
//		ComponentLifecycleException
//	{
//		super.initialize(containerServices);
//	}

	/**
	 * Returns an instance of the Operational interface to the Archive.
	 */
	public synchronized Operational getOperational(String user) 
		throws 
			ArchiveException, 
			UserDoesNotExistException, 
			PermissionException
	{
		OperationalPOATie operational = 
			new OperationalPOATie(
				new OperationalImpl(
					user,m_logger,m_containerServices)); 
		try
		{
			//TODO: check user permission
			return OperationalHelper.narrow(
				m_containerServices.activateOffShoot(operational));
		}
		catch (AcsJContainerServicesEx e) 
		{
			m_logger.severe(
				"The container had a problem starting the OffShoot: " + e.getContextInfo());
			throw new ArchiveException(e.getContextInfo());
		}
	}

	/**
	 * Returns an instance of the Administrative interface
	 */
	public synchronized Administrative getAdministrative(String user) 
		throws 
			ArchiveException, 
			UserDoesNotExistException, 
			PermissionException
	{
		AdministrativePOATie administrative;
		try {
			administrative = new AdministrativePOATie(new AdministrativeImpl(user,m_logger,m_containerServices));
		} catch (alma.archive.exceptions.ArchiveException e1) {
			throw new ArchiveException (e1.toString());
		}
		try
		{
			//TODO: check user permission
			return AdministrativeHelper.narrow(
				m_containerServices.activateOffShoot(administrative));
		}
		catch (AcsJContainerServicesEx e) {
			throw new ArchiveException(e.getContextInfo());
		}
	}
}
