/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 * ========================================================================
 * == THIS IS GENERATED CODE!!! DO NOT MODIFY! ALL CHANGES WILL BE LOST! ==
 * ======================================================================== 
 *
 */
 
package alma.maciErrType.wrappers;

import alma.ACSErr.Completion;
import alma.acs.exceptions.*;
import alma.maciErrType.wrappers.AcsJComponentSpecIncompatibleWithActiveComponentEx;

public class ComponentSpecIncompatibleWithActiveComponentAcsJCompletion extends AcsJCompletion
{
	/**
	 * Creates a new <code>ComponentSpecIncompatibleWithActiveComponentAcsJCompletion</code>
	 * with a corresponding exception (AcsJComponentSpecIncompatibleWithActiveComponentEx) attached.
	 */
	public ComponentSpecIncompatibleWithActiveComponentAcsJCompletion () {
		super(new AcsJComponentSpecIncompatibleWithActiveComponentEx()); 
	}

	/**
	 * Creates a new <code>ComponentSpecIncompatibleWithActiveComponentAcsJCompletion</code>
	 * with a corresponding exception (AcsJComponentSpecIncompatibleWithActiveComponentEx) attached 
	 * that wraps an existing exception (<code>acsJEx</code>.)
	 */
	public ComponentSpecIncompatibleWithActiveComponentAcsJCompletion (AcsJException acsJEx) {
		super(new AcsJComponentSpecIncompatibleWithActiveComponentEx(acsJEx));  
	}
	
	/**
	 * Creates a new <code>ComponentSpecIncompatibleWithActiveComponentAcsJCompletion</code>
	 * from another <code>AcsJCompletion</code> (<code>acsJComp</code>).
	 * <p>
	 * If present, the existing error trace is converted to Java exceptions
	 * and wrapped with an <code>AcsJComponentSpecIncompatibleWithActiveComponentEx</code>.
	 */
	public ComponentSpecIncompatibleWithActiveComponentAcsJCompletion(AcsJCompletion acsJComp) {		
			init(new AcsJComponentSpecIncompatibleWithActiveComponentEx(acsJComp.getAcsJException()));
	}
	
	/**
	 * Converts a Corba completion to an <code>ComponentSpecIncompatibleWithActiveComponentAcsJCompletion</code>
	 * such that a new <code>AcsJComponentSpecIncompatibleWithActiveComponentEx</code> is created as the attached error.
	 * If <code>corbaComp</code> carries error information, these <code>ErrorTrace</code>
	 * objects are converted to Java exceptions, which are attached as the course of
	 * the new <code>AcsJComponentSpecIncompatibleWithActiveComponentEx</code>.
	 * @param corbaComp
	 */
	public ComponentSpecIncompatibleWithActiveComponentAcsJCompletion(Completion corbaComp) {
		
		 this(AcsJCompletion.fromCorbaCompletion(corbaComp));
	}
	
       /**
        * Returns the short description of the error
        */
	public String getShortDescription() 
	{
	   return "Thrown if the resulting structure is incompatible with a component of the same name already active.";
	}	

	/////////////////////////////////////////////////////////////
	// Getter/Setter for members
	/////////////////////////////////////////////////////////////	

		
        public void setCURL(String value)
	{ 
		setProperty("CURL", ""+value);
	}            				
	
	public String getCURL()
	{ 
		return (getProperty("CURL")); 
	}
  
		
        public void setComponentType(String value)
	{ 
		setProperty("ComponentType", ""+value);
	}            				
	
	public String getComponentType()
	{ 
		return (getProperty("ComponentType")); 
	}
  
		
        public void setComponentCode(String value)
	{ 
		setProperty("ComponentCode", ""+value);
	}            				
	
	public String getComponentCode()
	{ 
		return (getProperty("ComponentCode")); 
	}
  
		
        public void setContainerName(String value)
	{ 
		setProperty("ContainerName", ""+value);
	}            				
	
	public String getContainerName()
	{ 
		return (getProperty("ContainerName")); 
	}
  
		
        public void setReason(String value)
	{ 
		setProperty("Reason", ""+value);
	}            				
	
	public String getReason()
	{ 
		return (getProperty("Reason")); 
	}
  
	
}
