package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * WeatherStation generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="WEATHERSTATION"
)
public class WeatherStation extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer baseElementId;
     protected BaseElement baseElement;
     protected Component component;
     protected String serialNumber;
     protected String weatherStationType;
     protected Long commissionDate;
     protected Double XPosition;
     protected Double YPosition;
     protected Double ZPosition;
     private Set<WeatherStationToPad> weatherStationToPads = new HashSet<WeatherStationToPad>(0);

    public WeatherStation() {
    }
   
     @GenericGenerator(name="generator", strategy="foreign", parameters=@Parameter(name="property", value="baseElement"))@Id @GeneratedValue(generator="generator")

    
    @Column(name="BASEELEMENTID", unique=true, nullable=false)
    public Integer getBaseElementId() {
        return this.baseElementId;
    }
    
    public void setBaseElementId(Integer baseElementId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementId", this.baseElementId, this.baseElementId = baseElementId);
        else
            this.baseElementId = baseElementId;
    }


@OneToOne(fetch=FetchType.LAZY)@PrimaryKeyJoinColumn
    public BaseElement getBaseElement() {
        return this.baseElement;
    }
    
    public void setBaseElement(BaseElement baseElement) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElement", this.baseElement, this.baseElement = baseElement);
        else
            this.baseElement = baseElement;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMPONENTID", nullable=false)
    public Component getComponent() {
        return this.component;
    }
    
    public void setComponent(Component component) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("component", this.component, this.component = component);
        else
            this.component = component;
    }


    
    @Column(name="SERIALNUMBER", nullable=false, length=128)
    public String getSerialNumber() {
        return this.serialNumber;
    }
    
    public void setSerialNumber(String serialNumber) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("serialNumber", this.serialNumber, this.serialNumber = serialNumber);
        else
            this.serialNumber = serialNumber;
    }


    
    @Column(name="WEATHERSTATIONTYPE", nullable=false, length=128)
    public String getWeatherStationType() {
        return this.weatherStationType;
    }
    
    public void setWeatherStationType(String weatherStationType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("weatherStationType", this.weatherStationType, this.weatherStationType = weatherStationType);
        else
            this.weatherStationType = weatherStationType;
    }


    
    @Column(name="COMMISSIONDATE", nullable=false)
    public Long getCommissionDate() {
        return this.commissionDate;
    }
    
    public void setCommissionDate(Long commissionDate) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("commissionDate", this.commissionDate, this.commissionDate = commissionDate);
        else
            this.commissionDate = commissionDate;
    }


    
    @Column(name="XPOSITION", nullable=false, precision=0, scale=0)
    public Double getXPosition() {
        return this.XPosition;
    }
    
    public void setXPosition(Double XPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("XPosition", this.XPosition, this.XPosition = XPosition);
        else
            this.XPosition = XPosition;
    }


    
    @Column(name="YPOSITION", nullable=false, precision=0, scale=0)
    public Double getYPosition() {
        return this.YPosition;
    }
    
    public void setYPosition(Double YPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("YPosition", this.YPosition, this.YPosition = YPosition);
        else
            this.YPosition = YPosition;
    }


    
    @Column(name="ZPOSITION", nullable=false, precision=0, scale=0)
    public Double getZPosition() {
        return this.ZPosition;
    }
    
    public void setZPosition(Double ZPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("ZPosition", this.ZPosition, this.ZPosition = ZPosition);
        else
            this.ZPosition = ZPosition;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="weatherStation")
    public Set<WeatherStationToPad> getWeatherStationToPads() {
        return this.weatherStationToPads;
    }
    
    public void setWeatherStationToPads(Set<WeatherStationToPad> weatherStationToPads) {    
    	this.weatherStationToPads = weatherStationToPads;
    }

	public void addWeatherStationToPads(Set<WeatherStationToPad> elements) {
		if( this.weatherStationToPads != null )
			for(Iterator<WeatherStationToPad> it = elements.iterator(); it.hasNext(); )
				addWeatherStationToPadToWeatherStationToPads((WeatherStationToPad)it.next());
	}

	public void addWeatherStationToPadToWeatherStationToPads(WeatherStationToPad element) {
		if( !this.weatherStationToPads.contains(element) ) {
			this.weatherStationToPads.add(element);
		}
	}





}


