package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * CorrQuadrantRack generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="CORRQUADRANTRACK"
    , uniqueConstraints = @UniqueConstraint(columnNames={"RACKNAME", "CORRQUADRANTID"}) 
)
public class CorrQuadrantRack extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer corrQuadrantRackId;
     protected CorrQuadrant corrQuadrant;
     protected String rackName;
     protected String rackType;
     protected Byte numberOfBins;
     protected Boolean active;
     private Set<CorrelatorBin> correlatorBins = new HashSet<CorrelatorBin>(0);
     private Set<CorrStationBin> corrStationBins = new HashSet<CorrStationBin>(0);

    public CorrQuadrantRack() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="CorrQuR_seq")}
	)

    
    @Column(name="CORRQUADRANTRACKID", unique=true, nullable=false)
    public Integer getCorrQuadrantRackId() {
        return this.corrQuadrantRackId;
    }
    
    public void setCorrQuadrantRackId(Integer corrQuadrantRackId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrQuadrantRackId", this.corrQuadrantRackId, this.corrQuadrantRackId = corrQuadrantRackId);
        else
            this.corrQuadrantRackId = corrQuadrantRackId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CORRQUADRANTID", nullable=false)
    public CorrQuadrant getCorrQuadrant() {
        return this.corrQuadrant;
    }
    
    public void setCorrQuadrant(CorrQuadrant corrQuadrant) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrQuadrant", this.corrQuadrant, this.corrQuadrant = corrQuadrant);
        else
            this.corrQuadrant = corrQuadrant;
    }


    
    @Column(name="RACKNAME", nullable=false, length=128)
    public String getRackName() {
        return this.rackName;
    }
    
    public void setRackName(String rackName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("rackName", this.rackName, this.rackName = rackName);
        else
            this.rackName = rackName;
    }


    
    @Column(name="RACKTYPE", nullable=false, length=0)
    public String getRackType() {
        return this.rackType;
    }
    
    public void setRackType(String rackType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("rackType", this.rackType, this.rackType = rackType);
        else
            this.rackType = rackType;
    }


    
    @Column(name="NUMBEROFBINS", nullable=false)
    public Byte getNumberOfBins() {
        return this.numberOfBins;
    }
    
    public void setNumberOfBins(Byte numberOfBins) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("numberOfBins", this.numberOfBins, this.numberOfBins = numberOfBins);
        else
            this.numberOfBins = numberOfBins;
    }


    
    @Column(name="ACTIVE", nullable=false)
    public Boolean getActive() {
        return this.active;
    }
    
    public void setActive(Boolean active) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("active", this.active, this.active = active);
        else
            this.active = active;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="corrQuadrantRack")
    public Set<CorrelatorBin> getCorrelatorBins() {
        return this.correlatorBins;
    }
    
    public void setCorrelatorBins(Set<CorrelatorBin> correlatorBins) {    
    	this.correlatorBins = correlatorBins;
    }

	public void addCorrelatorBins(Set<CorrelatorBin> elements) {
		if( this.correlatorBins != null )
			for(Iterator<CorrelatorBin> it = elements.iterator(); it.hasNext(); )
				addCorrelatorBinToCorrelatorBins((CorrelatorBin)it.next());
	}

	public void addCorrelatorBinToCorrelatorBins(CorrelatorBin element) {
		if( !this.correlatorBins.contains(element) ) {
			this.correlatorBins.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="corrQuadrantRack")
    public Set<CorrStationBin> getCorrStationBins() {
        return this.corrStationBins;
    }
    
    public void setCorrStationBins(Set<CorrStationBin> corrStationBins) {    
    	this.corrStationBins = corrStationBins;
    }

	public void addCorrStationBins(Set<CorrStationBin> elements) {
		if( this.corrStationBins != null )
			for(Iterator<CorrStationBin> it = elements.iterator(); it.hasNext(); )
				addCorrStationBinToCorrStationBins((CorrStationBin)it.next());
	}

	public void addCorrStationBinToCorrStationBins(CorrStationBin element) {
		if( !this.corrStationBins.contains(element) ) {
			this.corrStationBins.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof CorrQuadrantRack) ) return false;
		 CorrQuadrantRack castOther = ( CorrQuadrantRack ) other; 
         
		 return ( (this.getCorrQuadrant()==castOther.getCorrQuadrant()) || ( this.getCorrQuadrant()!=null && castOther.getCorrQuadrant()!=null && this.getCorrQuadrant().equals(castOther.getCorrQuadrant()) ) )
 && ( (this.getRackName()==castOther.getRackName()) || ( this.getRackName()!=null && castOther.getRackName()!=null && this.getRackName().equals(castOther.getRackName()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getCorrQuadrant() == null ? 0 : this.getCorrQuadrant().hashCode() );
         result = 37 * result + ( getRackName() == null ? 0 : this.getRackName().hashCode() );
         
         
         
         
         
         return result;
   }   


}


