package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * CorrQuadrant generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="CORRQUADRANT"
    , uniqueConstraints = @UniqueConstraint(columnNames={"CORRNAME", "QUADRANT", "BASEELEMENTID"}) 
)
public class CorrQuadrant extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer corrQuadrantId;
     protected CorrHWConfiguration corrHWConfiguration;
     protected Integer corrHWConfigId;
     protected String corrName;
     protected Byte quadrant;
     protected Byte channelNumber;
     protected Byte numberOfAntennas;
     protected Long commissionDate;
     protected Integer componentId;
     protected Byte numberOfRacks;
     protected Byte numberOfBins;
     protected Boolean active;
     private Set<CorrQuadrantRack> corrQuadrantRacks = new HashSet<CorrQuadrantRack>(0);
     private Set<AntennaToCorr> antennaToCorrs = new HashSet<AntennaToCorr>(0);

    public CorrQuadrant() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="CorrQuadrant_seq")}
	)

    
    @Column(name="CORRQUADRANTID", unique=true, nullable=false)
    public Integer getCorrQuadrantId() {
        return this.corrQuadrantId;
    }
    
    public void setCorrQuadrantId(Integer corrQuadrantId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrQuadrantId", this.corrQuadrantId, this.corrQuadrantId = corrQuadrantId);
        else
            this.corrQuadrantId = corrQuadrantId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BASEELEMENTID", nullable=false)
    public CorrHWConfiguration getCorrHWConfiguration() {
        return this.corrHWConfiguration;
    }
    
    public void setCorrHWConfiguration(CorrHWConfiguration corrHWConfiguration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrHWConfiguration", this.corrHWConfiguration, this.corrHWConfiguration = corrHWConfiguration);
        else
            this.corrHWConfiguration = corrHWConfiguration;
    }


    
    @Column(name="CORRHWCONFIGID", nullable=false)
    public Integer getCorrHWConfigId() {
        return this.corrHWConfigId;
    }
    
    public void setCorrHWConfigId(Integer corrHWConfigId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrHWConfigId", this.corrHWConfigId, this.corrHWConfigId = corrHWConfigId);
        else
            this.corrHWConfigId = corrHWConfigId;
    }


    
    @Column(name="CORRNAME", nullable=false, length=128)
    public String getCorrName() {
        return this.corrName;
    }
    
    public void setCorrName(String corrName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrName", this.corrName, this.corrName = corrName);
        else
            this.corrName = corrName;
    }


    
    @Column(name="QUADRANT", nullable=false)
    public Byte getQuadrant() {
        return this.quadrant;
    }
    
    public void setQuadrant(Byte quadrant) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("quadrant", this.quadrant, this.quadrant = quadrant);
        else
            this.quadrant = quadrant;
    }


    
    @Column(name="CHANNELNUMBER", nullable=false)
    public Byte getChannelNumber() {
        return this.channelNumber;
    }
    
    public void setChannelNumber(Byte channelNumber) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("channelNumber", this.channelNumber, this.channelNumber = channelNumber);
        else
            this.channelNumber = channelNumber;
    }


    
    @Column(name="NUMBEROFANTENNAS", nullable=false)
    public Byte getNumberOfAntennas() {
        return this.numberOfAntennas;
    }
    
    public void setNumberOfAntennas(Byte numberOfAntennas) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("numberOfAntennas", this.numberOfAntennas, this.numberOfAntennas = numberOfAntennas);
        else
            this.numberOfAntennas = numberOfAntennas;
    }


    
    @Column(name="COMMISSIONDATE", nullable=false)
    public Long getCommissionDate() {
        return this.commissionDate;
    }
    
    public void setCommissionDate(Long commissionDate) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("commissionDate", this.commissionDate, this.commissionDate = commissionDate);
        else
            this.commissionDate = commissionDate;
    }


    
    @Column(name="COMPONENTID", nullable=false)
    public Integer getComponentId() {
        return this.componentId;
    }
    
    public void setComponentId(Integer componentId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("componentId", this.componentId, this.componentId = componentId);
        else
            this.componentId = componentId;
    }


    
    @Column(name="NUMBEROFRACKS", nullable=false)
    public Byte getNumberOfRacks() {
        return this.numberOfRacks;
    }
    
    public void setNumberOfRacks(Byte numberOfRacks) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("numberOfRacks", this.numberOfRacks, this.numberOfRacks = numberOfRacks);
        else
            this.numberOfRacks = numberOfRacks;
    }


    
    @Column(name="NUMBEROFBINS", nullable=false)
    public Byte getNumberOfBins() {
        return this.numberOfBins;
    }
    
    public void setNumberOfBins(Byte numberOfBins) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("numberOfBins", this.numberOfBins, this.numberOfBins = numberOfBins);
        else
            this.numberOfBins = numberOfBins;
    }


    
    @Column(name="ACTIVE", nullable=false)
    public Boolean getActive() {
        return this.active;
    }
    
    public void setActive(Boolean active) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("active", this.active, this.active = active);
        else
            this.active = active;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="corrQuadrant")
    public Set<CorrQuadrantRack> getCorrQuadrantRacks() {
        return this.corrQuadrantRacks;
    }
    
    public void setCorrQuadrantRacks(Set<CorrQuadrantRack> corrQuadrantRacks) {    
    	this.corrQuadrantRacks = corrQuadrantRacks;
    }

	public void addCorrQuadrantRacks(Set<CorrQuadrantRack> elements) {
		if( this.corrQuadrantRacks != null )
			for(Iterator<CorrQuadrantRack> it = elements.iterator(); it.hasNext(); )
				addCorrQuadrantRackToCorrQuadrantRacks((CorrQuadrantRack)it.next());
	}

	public void addCorrQuadrantRackToCorrQuadrantRacks(CorrQuadrantRack element) {
		if( !this.corrQuadrantRacks.contains(element) ) {
			this.corrQuadrantRacks.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="corrQuadrant")
    public Set<AntennaToCorr> getAntennaToCorrs() {
        return this.antennaToCorrs;
    }
    
    public void setAntennaToCorrs(Set<AntennaToCorr> antennaToCorrs) {    
    	this.antennaToCorrs = antennaToCorrs;
    }

	public void addAntennaToCorrs(Set<AntennaToCorr> elements) {
		if( this.antennaToCorrs != null )
			for(Iterator<AntennaToCorr> it = elements.iterator(); it.hasNext(); )
				addAntennaToCorrToAntennaToCorrs((AntennaToCorr)it.next());
	}

	public void addAntennaToCorrToAntennaToCorrs(AntennaToCorr element) {
		if( !this.antennaToCorrs.contains(element) ) {
			this.antennaToCorrs.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof CorrQuadrant) ) return false;
		 CorrQuadrant castOther = ( CorrQuadrant ) other; 
         
		 return ( (this.getCorrHWConfiguration()==castOther.getCorrHWConfiguration()) || ( this.getCorrHWConfiguration()!=null && castOther.getCorrHWConfiguration()!=null && this.getCorrHWConfiguration().equals(castOther.getCorrHWConfiguration()) ) )
 && ( (this.getCorrName()==castOther.getCorrName()) || ( this.getCorrName()!=null && castOther.getCorrName()!=null && this.getCorrName().equals(castOther.getCorrName()) ) )
 && ( (this.getQuadrant()==castOther.getQuadrant()) || ( this.getQuadrant()!=null && castOther.getQuadrant()!=null && this.getQuadrant().equals(castOther.getQuadrant()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getCorrHWConfiguration() == null ? 0 : this.getCorrHWConfiguration().hashCode() );
         
         result = 37 * result + ( getCorrName() == null ? 0 : this.getCorrName().hashCode() );
         result = 37 * result + ( getQuadrant() == null ? 0 : this.getQuadrant().hashCode() );
         
         
         
         
         
         
         
         
         
         return result;
   }   


}


