package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * BaseElement generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="BASEELEMENT"
    , uniqueConstraints = @UniqueConstraint(columnNames={"BASEELEMENTNAME", "CONFIGURATIONID"}) 
)
public class BaseElement extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer baseElementId;
     protected HWConfiguration HWConfiguration;
     protected String baseType;
     protected String baseElementName;
     protected CentralRack centralRack;
     protected WeatherStation weatherStation;
     protected Antenna antenna;
     private Set<Array> arraies = new HashSet<Array>(0);
     private Set<BaseElementOnline> baseElementOnlines = new HashSet<BaseElementOnline>(0);
     protected HolographyTower holographyTower;
     private Set<AssociatedBaseElement> associatedBaseElementsForBaseelementid = new HashSet<AssociatedBaseElement>(0);
     private Set<AssociatedBaseElement> associatedBaseElementsForAssociatedid = new HashSet<AssociatedBaseElement>(0);
     protected CorrHWConfiguration corrHWConfiguration;
     protected Pad pad;
     protected MasterClock masterClock;
     protected FrontEnd frontEnd;
     private Set<BaseElementStartup> baseElementStartups = new HashSet<BaseElementStartup>(0);

    public BaseElement() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="BaseElement_seq")}
	)

    
    @Column(name="BASEELEMENTID", unique=true, nullable=false)
    public Integer getBaseElementId() {
        return this.baseElementId;
    }
    
    public void setBaseElementId(Integer baseElementId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementId", this.baseElementId, this.baseElementId = baseElementId);
        else
            this.baseElementId = baseElementId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONFIGURATIONID", nullable=false)
    public HWConfiguration getHWConfiguration() {
        return this.HWConfiguration;
    }
    
    public void setHWConfiguration(HWConfiguration HWConfiguration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("HWConfiguration", this.HWConfiguration, this.HWConfiguration = HWConfiguration);
        else
            this.HWConfiguration = HWConfiguration;
    }


    
    @Column(name="BASETYPE", nullable=false, length=0)
    public String getBaseType() {
        return this.baseType;
    }
    
    public void setBaseType(String baseType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseType", this.baseType, this.baseType = baseType);
        else
            this.baseType = baseType;
    }


    
    @Column(name="BASEELEMENTNAME", nullable=false, length=0)
    public String getBaseElementName() {
        return this.baseElementName;
    }
    
    public void setBaseElementName(String baseElementName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementName", this.baseElementName, this.baseElementName = baseElementName);
        else
            this.baseElementName = baseElementName;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public CentralRack getCentralRack() {
        return this.centralRack;
    }
    
    public void setCentralRack(CentralRack centralRack) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("centralRack", this.centralRack, this.centralRack = centralRack);
        else
            this.centralRack = centralRack;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public WeatherStation getWeatherStation() {
        return this.weatherStation;
    }
    
    public void setWeatherStation(WeatherStation weatherStation) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("weatherStation", this.weatherStation, this.weatherStation = weatherStation);
        else
            this.weatherStation = weatherStation;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Antenna getAntenna() {
        return this.antenna;
    }
    
    public void setAntenna(Antenna antenna) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("antenna", this.antenna, this.antenna = antenna);
        else
            this.antenna = antenna;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Set<Array> getArraies() {
        return this.arraies;
    }
    
    public void setArraies(Set<Array> arraies) {    
    	this.arraies = arraies;
    }

	public void addArraies(Set<Array> elements) {
		if( this.arraies != null )
			for(Iterator<Array> it = elements.iterator(); it.hasNext(); )
				addArrayToArraies((Array)it.next());
	}

	public void addArrayToArraies(Array element) {
		if( !this.arraies.contains(element) ) {
			this.arraies.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Set<BaseElementOnline> getBaseElementOnlines() {
        return this.baseElementOnlines;
    }
    
    public void setBaseElementOnlines(Set<BaseElementOnline> baseElementOnlines) {    
    	this.baseElementOnlines = baseElementOnlines;
    }

	public void addBaseElementOnlines(Set<BaseElementOnline> elements) {
		if( this.baseElementOnlines != null )
			for(Iterator<BaseElementOnline> it = elements.iterator(); it.hasNext(); )
				addBaseElementOnlineToBaseElementOnlines((BaseElementOnline)it.next());
	}

	public void addBaseElementOnlineToBaseElementOnlines(BaseElementOnline element) {
		if( !this.baseElementOnlines.contains(element) ) {
			this.baseElementOnlines.add(element);
		}
	}


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public HolographyTower getHolographyTower() {
        return this.holographyTower;
    }
    
    public void setHolographyTower(HolographyTower holographyTower) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("holographyTower", this.holographyTower, this.holographyTower = holographyTower);
        else
            this.holographyTower = holographyTower;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElementByBaseelementid")
    public Set<AssociatedBaseElement> getAssociatedBaseElementsForBaseelementid() {
        return this.associatedBaseElementsForBaseelementid;
    }
    
    public void setAssociatedBaseElementsForBaseelementid(Set<AssociatedBaseElement> associatedBaseElementsForBaseelementid) {    
    	this.associatedBaseElementsForBaseelementid = associatedBaseElementsForBaseelementid;
    }

	public void addAssociatedBaseElementsForBaseelementid(Set<AssociatedBaseElement> elements) {
		if( this.associatedBaseElementsForBaseelementid != null )
			for(Iterator<AssociatedBaseElement> it = elements.iterator(); it.hasNext(); )
				addAssociatedBaseElementToAssociatedBaseElementsForBaseelementid((AssociatedBaseElement)it.next());
	}

	public void addAssociatedBaseElementToAssociatedBaseElementsForBaseelementid(AssociatedBaseElement element) {
		if( !this.associatedBaseElementsForBaseelementid.contains(element) ) {
			this.associatedBaseElementsForBaseelementid.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElementByAssociatedid")
    public Set<AssociatedBaseElement> getAssociatedBaseElementsForAssociatedid() {
        return this.associatedBaseElementsForAssociatedid;
    }
    
    public void setAssociatedBaseElementsForAssociatedid(Set<AssociatedBaseElement> associatedBaseElementsForAssociatedid) {    
    	this.associatedBaseElementsForAssociatedid = associatedBaseElementsForAssociatedid;
    }

	public void addAssociatedBaseElementsForAssociatedid(Set<AssociatedBaseElement> elements) {
		if( this.associatedBaseElementsForAssociatedid != null )
			for(Iterator<AssociatedBaseElement> it = elements.iterator(); it.hasNext(); )
				addAssociatedBaseElementToAssociatedBaseElementsForAssociatedid((AssociatedBaseElement)it.next());
	}

	public void addAssociatedBaseElementToAssociatedBaseElementsForAssociatedid(AssociatedBaseElement element) {
		if( !this.associatedBaseElementsForAssociatedid.contains(element) ) {
			this.associatedBaseElementsForAssociatedid.add(element);
		}
	}


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public CorrHWConfiguration getCorrHWConfiguration() {
        return this.corrHWConfiguration;
    }
    
    public void setCorrHWConfiguration(CorrHWConfiguration corrHWConfiguration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("corrHWConfiguration", this.corrHWConfiguration, this.corrHWConfiguration = corrHWConfiguration);
        else
            this.corrHWConfiguration = corrHWConfiguration;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Pad getPad() {
        return this.pad;
    }
    
    public void setPad(Pad pad) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("pad", this.pad, this.pad = pad);
        else
            this.pad = pad;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public MasterClock getMasterClock() {
        return this.masterClock;
    }
    
    public void setMasterClock(MasterClock masterClock) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("masterClock", this.masterClock, this.masterClock = masterClock);
        else
            this.masterClock = masterClock;
    }


@OneToOne(fetch=FetchType.LAZY, mappedBy="baseElement")
    public FrontEnd getFrontEnd() {
        return this.frontEnd;
    }
    
    public void setFrontEnd(FrontEnd frontEnd) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("frontEnd", this.frontEnd, this.frontEnd = frontEnd);
        else
            this.frontEnd = frontEnd;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="baseElement")
    public Set<BaseElementStartup> getBaseElementStartups() {
        return this.baseElementStartups;
    }
    
    public void setBaseElementStartups(Set<BaseElementStartup> baseElementStartups) {    
    	this.baseElementStartups = baseElementStartups;
    }

	public void addBaseElementStartups(Set<BaseElementStartup> elements) {
		if( this.baseElementStartups != null )
			for(Iterator<BaseElementStartup> it = elements.iterator(); it.hasNext(); )
				addBaseElementStartupToBaseElementStartups((BaseElementStartup)it.next());
	}

	public void addBaseElementStartupToBaseElementStartups(BaseElementStartup element) {
		if( !this.baseElementStartups.contains(element) ) {
			this.baseElementStartups.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof BaseElement) ) return false;
		 BaseElement castOther = ( BaseElement ) other; 
         
		 return ( (this.getHWConfiguration()==castOther.getHWConfiguration()) || ( this.getHWConfiguration()!=null && castOther.getHWConfiguration()!=null && this.getHWConfiguration().equals(castOther.getHWConfiguration()) ) )
 && ( (this.getBaseElementName()==castOther.getBaseElementName()) || ( this.getBaseElementName()!=null && castOther.getBaseElementName()!=null && this.getBaseElementName().equals(castOther.getBaseElementName()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getHWConfiguration() == null ? 0 : this.getHWConfiguration().hashCode() );
         
         result = 37 * result + ( getBaseElementName() == null ? 0 : this.getBaseElementName().hashCode() );
         
         
         
         
         
         
         
         
         
         
         
         
         
         return result;
   }   


}


