package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * Array generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="ARRAY"
    , uniqueConstraints = @UniqueConstraint(columnNames={"STARTTIME", "BASEELEMENTID"}) 
)
public class Array extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer arrayId;
     protected BaseElement baseElement;
     protected Component component;
     protected String type;
     protected String userId;
     protected Long startTime;
     protected Long endTime;
     protected Boolean normalTermination;
     private Set<Antenna> antennas = new HashSet<Antenna>(0);
     private Set<SBExecution> SBExecutions = new HashSet<SBExecution>(0);

    public Array() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="Array_seq")}
	)

    
    @Column(name="ARRAYID", unique=true, nullable=false)
    public Integer getArrayId() {
        return this.arrayId;
    }
    
    public void setArrayId(Integer arrayId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("arrayId", this.arrayId, this.arrayId = arrayId);
        else
            this.arrayId = arrayId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BASEELEMENTID", nullable=false)
    public BaseElement getBaseElement() {
        return this.baseElement;
    }
    
    public void setBaseElement(BaseElement baseElement) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElement", this.baseElement, this.baseElement = baseElement);
        else
            this.baseElement = baseElement;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMPONENTID", nullable=false)
    public Component getComponent() {
        return this.component;
    }
    
    public void setComponent(Component component) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("component", this.component, this.component = component);
        else
            this.component = component;
    }


    
    @Column(name="TYPE", nullable=false, length=0)
    public String getType() {
        return this.type;
    }
    
    public void setType(String type) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("type", this.type, this.type = type);
        else
            this.type = type;
    }


    
    @Column(name="USERID", length=256)
    public String getUserId() {
        return this.userId;
    }
    
    public void setUserId(String userId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("userId", this.userId, this.userId = userId);
        else
            this.userId = userId;
    }


    
    @Column(name="STARTTIME", nullable=false)
    public Long getStartTime() {
        return this.startTime;
    }
    
    public void setStartTime(Long startTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("startTime", this.startTime, this.startTime = startTime);
        else
            this.startTime = startTime;
    }


    
    @Column(name="ENDTIME")
    public Long getEndTime() {
        return this.endTime;
    }
    
    public void setEndTime(Long endTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("endTime", this.endTime, this.endTime = endTime);
        else
            this.endTime = endTime;
    }


    
    @Column(name="NORMALTERMINATION", nullable=false)
    public Boolean getNormalTermination() {
        return this.normalTermination;
    }
    
    public void setNormalTermination(Boolean normalTermination) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("normalTermination", this.normalTermination, this.normalTermination = normalTermination);
        else
            this.normalTermination = normalTermination;
    }


@ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="ANTENNATOARRAY", joinColumns = { 
        @JoinColumn(name="ARRAYID", nullable=false, updatable=false) }, inverseJoinColumns = { 
        @JoinColumn(name="ANTENNAID", nullable=false, updatable=false) })
    public Set<Antenna> getAntennas() {
        return this.antennas;
    }
    
    public void setAntennas(Set<Antenna> antennas) {    
    	this.antennas = antennas;
    }

	public void addAntennas(Set<Antenna> elements) {
		if( this.antennas != null )
			for(Iterator<Antenna> it = elements.iterator(); it.hasNext(); )
				addAntennaToAntennas((Antenna)it.next());
	}

	public void addAntennaToAntennas(Antenna element) {
		if( !this.antennas.contains(element) ) {
			this.antennas.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="array")
    public Set<SBExecution> getSBExecutions() {
        return this.SBExecutions;
    }
    
    public void setSBExecutions(Set<SBExecution> SBExecutions) {    
    	this.SBExecutions = SBExecutions;
    }

	public void addSBExecutions(Set<SBExecution> elements) {
		if( this.SBExecutions != null )
			for(Iterator<SBExecution> it = elements.iterator(); it.hasNext(); )
				addSBExecutionToSBExecutions((SBExecution)it.next());
	}

	public void addSBExecutionToSBExecutions(SBExecution element) {
		if( !this.SBExecutions.contains(element) ) {
			this.SBExecutions.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof Array) ) return false;
		 Array castOther = ( Array ) other; 
         
		 return ( (this.getBaseElement()==castOther.getBaseElement()) || ( this.getBaseElement()!=null && castOther.getBaseElement()!=null && this.getBaseElement().equals(castOther.getBaseElement()) ) )
 && ( (this.getStartTime()==castOther.getStartTime()) || ( this.getStartTime()!=null && castOther.getStartTime()!=null && this.getStartTime().equals(castOther.getStartTime()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getBaseElement() == null ? 0 : this.getBaseElement().hashCode() );
         
         
         
         result = 37 * result + ( getStartTime() == null ? 0 : this.getStartTime().hashCode() );
         
         
         
         
         return result;
   }   


}


