package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * AntennaFocusModel generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="ANTENNAFOCUSMODEL"
    , uniqueConstraints = @UniqueConstraint(columnNames={"ANTENNAID", "RECEIVERBAND", "STARTVALIDTIME"}) 
)
public class AntennaFocusModel extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer focusModelId;
     protected Antenna antenna;
     protected String receiverBand;
     protected Long startValidTime;
     protected Long endValidTime;
     protected String asdmUID;
     private Set<AntennaFocusModelTerm> antennaFocusModelTerms = new HashSet<AntennaFocusModelTerm>(0);

    public AntennaFocusModel() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="AntennFM_seq")}
	)

    
    @Column(name="FOCUSMODELID", unique=true, nullable=false)
    public Integer getFocusModelId() {
        return this.focusModelId;
    }
    
    public void setFocusModelId(Integer focusModelId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("focusModelId", this.focusModelId, this.focusModelId = focusModelId);
        else
            this.focusModelId = focusModelId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ANTENNAID", nullable=false)
    public Antenna getAntenna() {
        return this.antenna;
    }
    
    public void setAntenna(Antenna antenna) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("antenna", this.antenna, this.antenna = antenna);
        else
            this.antenna = antenna;
    }


    
    @Column(name="RECEIVERBAND", nullable=false, length=128)
    public String getReceiverBand() {
        return this.receiverBand;
    }
    
    public void setReceiverBand(String receiverBand) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("receiverBand", this.receiverBand, this.receiverBand = receiverBand);
        else
            this.receiverBand = receiverBand;
    }


    
    @Column(name="STARTVALIDTIME", nullable=false)
    public Long getStartValidTime() {
        return this.startValidTime;
    }
    
    public void setStartValidTime(Long startValidTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("startValidTime", this.startValidTime, this.startValidTime = startValidTime);
        else
            this.startValidTime = startValidTime;
    }


    
    @Column(name="ENDVALIDTIME")
    public Long getEndValidTime() {
        return this.endValidTime;
    }
    
    public void setEndValidTime(Long endValidTime) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("endValidTime", this.endValidTime, this.endValidTime = endValidTime);
        else
            this.endValidTime = endValidTime;
    }


    
    @Column(name="ASDMUID", nullable=false, length=256)
    public String getAsdmUID() {
        return this.asdmUID;
    }
    
    public void setAsdmUID(String asdmUID) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("asdmUID", this.asdmUID, this.asdmUID = asdmUID);
        else
            this.asdmUID = asdmUID;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="antennaFocusModel")
    public Set<AntennaFocusModelTerm> getAntennaFocusModelTerms() {
        return this.antennaFocusModelTerms;
    }
    
    public void setAntennaFocusModelTerms(Set<AntennaFocusModelTerm> antennaFocusModelTerms) {    
    	this.antennaFocusModelTerms = antennaFocusModelTerms;
    }

	public void addAntennaFocusModelTerms(Set<AntennaFocusModelTerm> elements) {
		if( this.antennaFocusModelTerms != null )
			for(Iterator<AntennaFocusModelTerm> it = elements.iterator(); it.hasNext(); )
				addAntennaFocusModelTermToAntennaFocusModelTerms((AntennaFocusModelTerm)it.next());
	}

	public void addAntennaFocusModelTermToAntennaFocusModelTerms(AntennaFocusModelTerm element) {
		if( !this.antennaFocusModelTerms.contains(element) ) {
			this.antennaFocusModelTerms.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof AntennaFocusModel) ) return false;
		 AntennaFocusModel castOther = ( AntennaFocusModel ) other; 
         
		 return ( (this.getAntenna()==castOther.getAntenna()) || ( this.getAntenna()!=null && castOther.getAntenna()!=null && this.getAntenna().equals(castOther.getAntenna()) ) )
 && ( (this.getReceiverBand()==castOther.getReceiverBand()) || ( this.getReceiverBand()!=null && castOther.getReceiverBand()!=null && this.getReceiverBand().equals(castOther.getReceiverBand()) ) )
 && ( (this.getStartValidTime()==castOther.getStartValidTime()) || ( this.getStartValidTime()!=null && castOther.getStartValidTime()!=null && this.getStartValidTime().equals(castOther.getStartValidTime()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getAntenna() == null ? 0 : this.getAntenna().hashCode() );
         result = 37 * result + ( getReceiverBand() == null ? 0 : this.getReceiverBand().hashCode() );
         result = 37 * result + ( getStartValidTime() == null ? 0 : this.getStartValidTime().hashCode() );
         
         
         
         return result;
   }   


}


