package alma.acs.tmcdb;
// Generated Jun 28, 2010 6:17:13 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * Antenna generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="ANTENNA"
)
public class Antenna extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer baseElementId;
     protected BaseElement baseElement;
     protected Component component;
     protected String antennaName;
     protected String antennaType;
     protected Double dishDiameter;
     protected Long commissionDate;
     protected Double XPosition;
     protected Double YPosition;
     protected Double ZPosition;
     protected Double XOffset;
     protected Double YOffset;
     protected Double ZOffset;
     protected Double avgDelay;
     private Set<AntennaToFrontEnd> antennaToFrontEnds = new HashSet<AntennaToFrontEnd>(0);
     private Set<Array> arraies = new HashSet<Array>(0);
     private Set<AntennaToCorr> antennaToCorrs = new HashSet<AntennaToCorr>(0);
     private Set<AntennaFocusModel> antennaFocusModels = new HashSet<AntennaFocusModel>(0);
     private Set<AntennaToPad> antennaToPads = new HashSet<AntennaToPad>(0);

    public Antenna() {
    }
   
     @GenericGenerator(name="generator", strategy="foreign", parameters=@Parameter(name="property", value="baseElement"))@Id @GeneratedValue(generator="generator")

    
    @Column(name="BASEELEMENTID", unique=true, nullable=false)
    public Integer getBaseElementId() {
        return this.baseElementId;
    }
    
    public void setBaseElementId(Integer baseElementId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElementId", this.baseElementId, this.baseElementId = baseElementId);
        else
            this.baseElementId = baseElementId;
    }


@OneToOne(fetch=FetchType.LAZY)@PrimaryKeyJoinColumn
    public BaseElement getBaseElement() {
        return this.baseElement;
    }
    
    public void setBaseElement(BaseElement baseElement) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("baseElement", this.baseElement, this.baseElement = baseElement);
        else
            this.baseElement = baseElement;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMPONENTID", nullable=false)
    public Component getComponent() {
        return this.component;
    }
    
    public void setComponent(Component component) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("component", this.component, this.component = component);
        else
            this.component = component;
    }


    
    @Column(name="ANTENNANAME", length=128)
    public String getAntennaName() {
        return this.antennaName;
    }
    
    public void setAntennaName(String antennaName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("antennaName", this.antennaName, this.antennaName = antennaName);
        else
            this.antennaName = antennaName;
    }


    
    @Column(name="ANTENNATYPE", nullable=false, length=0)
    public String getAntennaType() {
        return this.antennaType;
    }
    
    public void setAntennaType(String antennaType) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("antennaType", this.antennaType, this.antennaType = antennaType);
        else
            this.antennaType = antennaType;
    }


    
    @Column(name="DISHDIAMETER", nullable=false, precision=0, scale=0)
    public Double getDishDiameter() {
        return this.dishDiameter;
    }
    
    public void setDishDiameter(Double dishDiameter) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("dishDiameter", this.dishDiameter, this.dishDiameter = dishDiameter);
        else
            this.dishDiameter = dishDiameter;
    }


    
    @Column(name="COMMISSIONDATE", nullable=false)
    public Long getCommissionDate() {
        return this.commissionDate;
    }
    
    public void setCommissionDate(Long commissionDate) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("commissionDate", this.commissionDate, this.commissionDate = commissionDate);
        else
            this.commissionDate = commissionDate;
    }


    
    @Column(name="XPOSITION", nullable=false, precision=0, scale=0)
    public Double getXPosition() {
        return this.XPosition;
    }
    
    public void setXPosition(Double XPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("XPosition", this.XPosition, this.XPosition = XPosition);
        else
            this.XPosition = XPosition;
    }


    
    @Column(name="YPOSITION", nullable=false, precision=0, scale=0)
    public Double getYPosition() {
        return this.YPosition;
    }
    
    public void setYPosition(Double YPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("YPosition", this.YPosition, this.YPosition = YPosition);
        else
            this.YPosition = YPosition;
    }


    
    @Column(name="ZPOSITION", nullable=false, precision=0, scale=0)
    public Double getZPosition() {
        return this.ZPosition;
    }
    
    public void setZPosition(Double ZPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("ZPosition", this.ZPosition, this.ZPosition = ZPosition);
        else
            this.ZPosition = ZPosition;
    }


    
    @Column(name="XOFFSET", nullable=false, precision=0, scale=0)
    public Double getXOffset() {
        return this.XOffset;
    }
    
    public void setXOffset(Double XOffset) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("XOffset", this.XOffset, this.XOffset = XOffset);
        else
            this.XOffset = XOffset;
    }


    
    @Column(name="YOFFSET", nullable=false, precision=0, scale=0)
    public Double getYOffset() {
        return this.YOffset;
    }
    
    public void setYOffset(Double YOffset) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("YOffset", this.YOffset, this.YOffset = YOffset);
        else
            this.YOffset = YOffset;
    }


    
    @Column(name="ZOFFSET", nullable=false, precision=0, scale=0)
    public Double getZOffset() {
        return this.ZOffset;
    }
    
    public void setZOffset(Double ZOffset) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("ZOffset", this.ZOffset, this.ZOffset = ZOffset);
        else
            this.ZOffset = ZOffset;
    }


    
    @Column(name="AVGDELAY", precision=0, scale=0)
    public Double getAvgDelay() {
        return this.avgDelay;
    }
    
    public void setAvgDelay(Double avgDelay) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("avgDelay", this.avgDelay, this.avgDelay = avgDelay);
        else
            this.avgDelay = avgDelay;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="antenna")
    public Set<AntennaToFrontEnd> getAntennaToFrontEnds() {
        return this.antennaToFrontEnds;
    }
    
    public void setAntennaToFrontEnds(Set<AntennaToFrontEnd> antennaToFrontEnds) {    
    	this.antennaToFrontEnds = antennaToFrontEnds;
    }

	public void addAntennaToFrontEnds(Set<AntennaToFrontEnd> elements) {
		if( this.antennaToFrontEnds != null )
			for(Iterator<AntennaToFrontEnd> it = elements.iterator(); it.hasNext(); )
				addAntennaToFrontEndToAntennaToFrontEnds((AntennaToFrontEnd)it.next());
	}

	public void addAntennaToFrontEndToAntennaToFrontEnds(AntennaToFrontEnd element) {
		if( !this.antennaToFrontEnds.contains(element) ) {
			this.antennaToFrontEnds.add(element);
		}
	}


@ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="ANTENNATOARRAY", joinColumns = { 
        @JoinColumn(name="ANTENNAID", nullable=false, updatable=false) }, inverseJoinColumns = { 
        @JoinColumn(name="ARRAYID", nullable=false, updatable=false) })
    public Set<Array> getArraies() {
        return this.arraies;
    }
    
    public void setArraies(Set<Array> arraies) {    
    	this.arraies = arraies;
    }

	public void addArraies(Set<Array> elements) {
		if( this.arraies != null )
			for(Iterator<Array> it = elements.iterator(); it.hasNext(); )
				addArrayToArraies((Array)it.next());
	}

	public void addArrayToArraies(Array element) {
		if( !this.arraies.contains(element) ) {
			this.arraies.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="antenna")
    public Set<AntennaToCorr> getAntennaToCorrs() {
        return this.antennaToCorrs;
    }
    
    public void setAntennaToCorrs(Set<AntennaToCorr> antennaToCorrs) {    
    	this.antennaToCorrs = antennaToCorrs;
    }

	public void addAntennaToCorrs(Set<AntennaToCorr> elements) {
		if( this.antennaToCorrs != null )
			for(Iterator<AntennaToCorr> it = elements.iterator(); it.hasNext(); )
				addAntennaToCorrToAntennaToCorrs((AntennaToCorr)it.next());
	}

	public void addAntennaToCorrToAntennaToCorrs(AntennaToCorr element) {
		if( !this.antennaToCorrs.contains(element) ) {
			this.antennaToCorrs.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="antenna")
    public Set<AntennaFocusModel> getAntennaFocusModels() {
        return this.antennaFocusModels;
    }
    
    public void setAntennaFocusModels(Set<AntennaFocusModel> antennaFocusModels) {    
    	this.antennaFocusModels = antennaFocusModels;
    }

	public void addAntennaFocusModels(Set<AntennaFocusModel> elements) {
		if( this.antennaFocusModels != null )
			for(Iterator<AntennaFocusModel> it = elements.iterator(); it.hasNext(); )
				addAntennaFocusModelToAntennaFocusModels((AntennaFocusModel)it.next());
	}

	public void addAntennaFocusModelToAntennaFocusModels(AntennaFocusModel element) {
		if( !this.antennaFocusModels.contains(element) ) {
			this.antennaFocusModels.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="antenna")
    public Set<AntennaToPad> getAntennaToPads() {
        return this.antennaToPads;
    }
    
    public void setAntennaToPads(Set<AntennaToPad> antennaToPads) {    
    	this.antennaToPads = antennaToPads;
    }

	public void addAntennaToPads(Set<AntennaToPad> elements) {
		if( this.antennaToPads != null )
			for(Iterator<AntennaToPad> it = elements.iterator(); it.hasNext(); )
				addAntennaToPadToAntennaToPads((AntennaToPad)it.next());
	}

	public void addAntennaToPadToAntennaToPads(AntennaToPad element) {
		if( !this.antennaToPads.contains(element) ) {
			this.antennaToPads.add(element);
		}
	}





}


