/**
 * <copyright>
 * </copyright>
 *
 */
package alma.acs.tmcdb.grammardef.tmcdbTables.util;

import alma.acs.tmcdb.grammardef.tmcdbTables.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see alma.acs.tmcdb.grammardef.tmcdbTables.TmcdbTablesPackage
 * @generated
 */
public class TmcdbTablesSwitch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static TmcdbTablesPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TmcdbTablesSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = TmcdbTablesPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public T doSwitch(EObject theEObject)
  {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(EClass theEClass, EObject theEObject)
  {
    if (theEClass.eContainer() == modelPackage)
    {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    else
    {
      List<EClass> eSuperTypes = theEClass.getESuperTypes();
      return
        eSuperTypes.isEmpty() ?
          defaultCase(theEObject) :
          doSwitch(eSuperTypes.get(0), theEObject);
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case TmcdbTablesPackage.TMCDB_MODEL:
      {
        TMCDBModel tmcdbModel = (TMCDBModel)theEObject;
        T result = caseTMCDBModel(tmcdbModel);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.HEADER:
      {
        Header header = (Header)theEObject;
        T result = caseHeader(header);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.NOTE:
      {
        Note note = (Note)theEObject;
        T result = caseNote(note);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.INCLUDE:
      {
        Include include = (Include)theEObject;
        T result = caseInclude(include);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.MODEL_NAME:
      {
        ModelName modelName = (ModelName)theEObject;
        T result = caseModelName(modelName);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TABLE:
      {
        Table table = (Table)theEObject;
        T result = caseTable(table);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.COLUMN:
      {
        Column column = (Column)theEObject;
        T result = caseColumn(column);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.KEY:
      {
        Key key = (Key)theEObject;
        T result = caseKey(key);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TYPE:
      {
        Type type = (Type)theEObject;
        T result = caseType(type);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.INT_TYPES:
      {
        IntTypes intTypes = (IntTypes)theEObject;
        T result = caseIntTypes(intTypes);
        if (result == null) result = caseType(intTypes);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.LENGTH_DEFINED_TYPES:
      {
        LengthDefinedTypes lengthDefinedTypes = (LengthDefinedTypes)theEObject;
        T result = caseLengthDefinedTypes(lengthDefinedTypes);
        if (result == null) result = caseType(lengthDefinedTypes);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TEXT_TYPES:
      {
        TextTypes textTypes = (TextTypes)theEObject;
        T result = caseTextTypes(textTypes);
        if (result == null) result = caseType(textTypes);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TIME_TYPES:
      {
        TimeTypes timeTypes = (TimeTypes)theEObject;
        T result = caseTimeTypes(timeTypes);
        if (result == null) result = caseType(timeTypes);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.OTHER_TYPES:
      {
        OtherTypes otherTypes = (OtherTypes)theEObject;
        T result = caseOtherTypes(otherTypes);
        if (result == null) result = caseType(otherTypes);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.INT_TYPE:
      {
        IntType intType = (IntType)theEObject;
        T result = caseIntType(intType);
        if (result == null) result = caseIntTypes(intType);
        if (result == null) result = caseType(intType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.SMALLINT_TYPE:
      {
        SmallintType smallintType = (SmallintType)theEObject;
        T result = caseSmallintType(smallintType);
        if (result == null) result = caseIntTypes(smallintType);
        if (result == null) result = caseType(smallintType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.BIGINT_TYPE:
      {
        BigintType bigintType = (BigintType)theEObject;
        T result = caseBigintType(bigintType);
        if (result == null) result = caseIntTypes(bigintType);
        if (result == null) result = caseType(bigintType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TINYINT_TYPE:
      {
        TinyintType tinyintType = (TinyintType)theEObject;
        T result = caseTinyintType(tinyintType);
        if (result == null) result = caseIntTypes(tinyintType);
        if (result == null) result = caseType(tinyintType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.LENGTH_TYPE:
      {
        LengthType lengthType = (LengthType)theEObject;
        T result = caseLengthType(lengthType);
        if (result == null) result = caseIntTypes(lengthType);
        if (result == null) result = caseType(lengthType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.CHAR_TYPE:
      {
        CharType charType = (CharType)theEObject;
        T result = caseCharType(charType);
        if (result == null) result = caseLengthDefinedTypes(charType);
        if (result == null) result = caseType(charType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.VARCHAR_TYPE:
      {
        VarcharType varcharType = (VarcharType)theEObject;
        T result = caseVarcharType(varcharType);
        if (result == null) result = caseLengthDefinedTypes(varcharType);
        if (result == null) result = caseType(varcharType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.LONGVARCHAR_TYPE:
      {
        LongvarcharType longvarcharType = (LongvarcharType)theEObject;
        T result = caseLongvarcharType(longvarcharType);
        if (result == null) result = caseLengthDefinedTypes(longvarcharType);
        if (result == null) result = caseType(longvarcharType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TEXT_TYPE:
      {
        TextType textType = (TextType)theEObject;
        T result = caseTextType(textType);
        if (result == null) result = caseTextTypes(textType);
        if (result == null) result = caseType(textType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.NAME_TYPE:
      {
        NameType nameType = (NameType)theEObject;
        T result = caseNameType(nameType);
        if (result == null) result = caseTextTypes(nameType);
        if (result == null) result = caseType(nameType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.LONGNAME_TYPE:
      {
        LongnameType longnameType = (LongnameType)theEObject;
        T result = caseLongnameType(longnameType);
        if (result == null) result = caseTextTypes(longnameType);
        if (result == null) result = caseType(longnameType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TSTAMP_TYPE:
      {
        TstampType tstampType = (TstampType)theEObject;
        T result = caseTstampType(tstampType);
        if (result == null) result = caseTimeTypes(tstampType);
        if (result == null) result = caseType(tstampType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.TIME_TYPE:
      {
        TimeType timeType = (TimeType)theEObject;
        T result = caseTimeType(timeType);
        if (result == null) result = caseTimeTypes(timeType);
        if (result == null) result = caseType(timeType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.BOOLEAN_TYPE:
      {
        BooleanType booleanType = (BooleanType)theEObject;
        T result = caseBooleanType(booleanType);
        if (result == null) result = caseOtherTypes(booleanType);
        if (result == null) result = caseType(booleanType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DOUBLE_TYPE:
      {
        DoubleType doubleType = (DoubleType)theEObject;
        T result = caseDoubleType(doubleType);
        if (result == null) result = caseOtherTypes(doubleType);
        if (result == null) result = caseType(doubleType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.FLOAT_TYPE:
      {
        FloatType floatType = (FloatType)theEObject;
        T result = caseFloatType(floatType);
        if (result == null) result = caseOtherTypes(floatType);
        if (result == null) result = caseType(floatType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.CLOB_TYPE:
      {
        ClobType clobType = (ClobType)theEObject;
        T result = caseClobType(clobType);
        if (result == null) result = caseOtherTypes(clobType);
        if (result == null) result = caseType(clobType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.XML_CLOB_TYPE:
      {
        XmlClobType xmlClobType = (XmlClobType)theEObject;
        T result = caseXmlClobType(xmlClobType);
        if (result == null) result = caseOtherTypes(xmlClobType);
        if (result == null) result = caseType(xmlClobType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.SPECIFIER:
      {
        Specifier specifier = (Specifier)theEObject;
        T result = caseSpecifier(specifier);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.NULLITY_SPECIFIER:
      {
        NullitySpecifier nullitySpecifier = (NullitySpecifier)theEObject;
        T result = caseNullitySpecifier(nullitySpecifier);
        if (result == null) result = caseSpecifier(nullitySpecifier);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DEFAULT_SPECIFIER:
      {
        DefaultSpecifier defaultSpecifier = (DefaultSpecifier)theEObject;
        T result = caseDefaultSpecifier(defaultSpecifier);
        if (result == null) result = caseSpecifier(defaultSpecifier);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DEFAULT_VALUE:
      {
        DefaultValue defaultValue = (DefaultValue)theEObject;
        T result = caseDefaultValue(defaultValue);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DEFAULT_INT_VALUE:
      {
        DefaultIntValue defaultIntValue = (DefaultIntValue)theEObject;
        T result = caseDefaultIntValue(defaultIntValue);
        if (result == null) result = caseDefaultValue(defaultIntValue);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DEFAULT_STRING_VALUE:
      {
        DefaultStringValue defaultStringValue = (DefaultStringValue)theEObject;
        T result = caseDefaultStringValue(defaultStringValue);
        if (result == null) result = caseDefaultValue(defaultStringValue);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.DEFAULT_BOOLEAN_VALUE:
      {
        DefaultBooleanValue defaultBooleanValue = (DefaultBooleanValue)theEObject;
        T result = caseDefaultBooleanValue(defaultBooleanValue);
        if (result == null) result = caseDefaultValue(defaultBooleanValue);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.CONSTRAINT:
      {
        Constraint constraint = (Constraint)theEObject;
        T result = caseConstraint(constraint);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.FOREIGN_CONSTRAINT:
      {
        ForeignConstraint foreignConstraint = (ForeignConstraint)theEObject;
        T result = caseForeignConstraint(foreignConstraint);
        if (result == null) result = caseConstraint(foreignConstraint);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.CHECK_CONSTRAINT:
      {
        CheckConstraint checkConstraint = (CheckConstraint)theEObject;
        T result = caseCheckConstraint(checkConstraint);
        if (result == null) result = caseConstraint(checkConstraint);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.CASCADE_TYPE:
      {
        CascadeType cascadeType = (CascadeType)theEObject;
        T result = caseCascadeType(cascadeType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.POSSIBLE_VALUES:
      {
        PossibleValues possibleValues = (PossibleValues)theEObject;
        T result = casePossibleValues(possibleValues);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.INTEGER_POSSIBLE_VALUES:
      {
        IntegerPossibleValues integerPossibleValues = (IntegerPossibleValues)theEObject;
        T result = caseIntegerPossibleValues(integerPossibleValues);
        if (result == null) result = casePossibleValues(integerPossibleValues);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TmcdbTablesPackage.STRING_POSSIBLE_VALUES:
      {
        StringPossibleValues stringPossibleValues = (StringPossibleValues)theEObject;
        T result = caseStringPossibleValues(stringPossibleValues);
        if (result == null) result = casePossibleValues(stringPossibleValues);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>TMCDB Model</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>TMCDB Model</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTMCDBModel(TMCDBModel object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Header</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Header</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseHeader(Header object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Note</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Note</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseNote(Note object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Include</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Include</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseInclude(Include object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Model Name</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Model Name</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseModelName(ModelName object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Table</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Table</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTable(Table object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Column</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Column</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseColumn(Column object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Key</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Key</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseKey(Key object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseType(Type object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Int Types</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Int Types</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntTypes(IntTypes object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Length Defined Types</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Length Defined Types</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLengthDefinedTypes(LengthDefinedTypes object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Text Types</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Text Types</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTextTypes(TextTypes object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Time Types</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Time Types</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTimeTypes(TimeTypes object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Other Types</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Other Types</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseOtherTypes(OtherTypes object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Int Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Int Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntType(IntType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Smallint Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Smallint Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSmallintType(SmallintType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Bigint Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Bigint Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBigintType(BigintType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Tinyint Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Tinyint Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTinyintType(TinyintType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Length Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Length Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLengthType(LengthType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Char Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Char Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCharType(CharType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Varchar Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Varchar Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseVarcharType(VarcharType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Longvarchar Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Longvarchar Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLongvarcharType(LongvarcharType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Text Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Text Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTextType(TextType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Name Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Name Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseNameType(NameType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Longname Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Longname Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLongnameType(LongnameType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Tstamp Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Tstamp Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTstampType(TstampType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Time Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Time Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTimeType(TimeType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Boolean Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Boolean Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBooleanType(BooleanType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Double Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Double Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDoubleType(DoubleType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Float Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Float Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFloatType(FloatType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Clob Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Clob Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseClobType(ClobType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Xml Clob Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Xml Clob Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseXmlClobType(XmlClobType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Specifier</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Specifier</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSpecifier(Specifier object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Nullity Specifier</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Nullity Specifier</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseNullitySpecifier(NullitySpecifier object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Default Specifier</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Default Specifier</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDefaultSpecifier(DefaultSpecifier object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Default Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Default Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDefaultValue(DefaultValue object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Default Int Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Default Int Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDefaultIntValue(DefaultIntValue object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Default String Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Default String Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDefaultStringValue(DefaultStringValue object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Default Boolean Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Default Boolean Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDefaultBooleanValue(DefaultBooleanValue object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Constraint</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Constraint</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConstraint(Constraint object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Foreign Constraint</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Foreign Constraint</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseForeignConstraint(ForeignConstraint object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Check Constraint</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Check Constraint</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCheckConstraint(CheckConstraint object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Cascade Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Cascade Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCascadeType(CascadeType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Possible Values</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Possible Values</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePossibleValues(PossibleValues object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Integer Possible Values</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Integer Possible Values</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIntegerPossibleValues(IntegerPossibleValues object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>String Possible Values</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>String Possible Values</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseStringPossibleValues(StringPossibleValues object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public T defaultCase(EObject object)
  {
    return null;
  }

} //TmcdbTablesSwitch
