lexer grammar InternalTmcdbTables;
@header {
package alma.acs.tmcdb.grammardef.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

T13 : 'TMCDB' ;
T14 : 'SQL' ;
T15 : 'TABLE' ;
T16 : 'DEFINITIONS' ;
T17 : 'VERSION' ;
T18 : 'NOTE' ;
T19 : 'ENDNOTE' ;
T20 : 'INCLUDE' ;
T21 : 'MODELNAME' ;
T22 : 'EXTENDS' ;
T23 : 'ENDTABLE' ;
T24 : 'KEY' ;
T25 : 'GENERATED' ;
T26 : 'FROM' ;
T27 : 'INTEGER' ;
T28 : 'SMALLINT' ;
T29 : 'BIGINT' ;
T30 : 'TINYINT' ;
T31 : 'LENGTH' ;
T32 : 'CHAR' ;
T33 : '(' ;
T34 : ')' ;
T35 : 'VARCHAR' ;
T36 : 'LONGVARCHAR' ;
T37 : 'TEXT' ;
T38 : 'NAME' ;
T39 : 'LONGNAME' ;
T40 : 'TSTAMP' ;
T41 : 'TIME' ;
T42 : 'BOOLEAN' ;
T43 : 'DOUBLE' ;
T44 : 'FLOAT' ;
T45 : 'CLOB' ;
T46 : 'XMLCLOB' ;
T47 : 'NOT' ;
T48 : 'NULL' ;
T49 : 'DEFAULT' ;
T50 : '-' ;
T51 : 'TRUE' ;
T52 : 'FALSE' ;
T53 : 'CONSTRAINT' ;
T54 : 'FOREIGN' ;
T55 : ',' ;
T56 : 'REFERENCES' ;
T57 : 'CHECK' ;
T58 : 'IN' ;
T59 : 'CASCADING' ;
T60 : 'INVERSE' ;
T61 : 'AGGREGATION' ;
T62 : 'COMPOSITION' ;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2931
RULE_VERSIONTYPE : RULE_INT ('.' RULE_INT)+;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2933
RULE_TIMESTAMPTYPE : RULE_INT '-' RULE_INT '-' RULE_INT 'T' RULE_INT ':' RULE_INT ':' RULE_INT '.' RULE_INT;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2935
RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2937
RULE_INT : ('0'..'9')+;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2939
RULE_STRING : ('"' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'"')))* '"'|'\'' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'\'')))* '\'');

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2941
RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2943
RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2945
RULE_WS : (' '|'\t'|'\r'|'\n')+;

// $ANTLR src "../codegen/src-gen/alma/acs/tmcdb/grammardef/parser/antlr/internal/InternalTmcdbTables.g" 2947
RULE_ANY_OTHER : .;


