/*
*ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2007
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

/**
 * @author  nbarriga
 * @version $Id: LTS2Java.xslt,v 1.7 2007/12/20 18:43:45 hsommer Exp $
 * @since
 */

package alma.AcsNCTraceLog;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.LinkedHashMap;
import java.util.Map;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.AcsLogRecord;


/**
 * Generated class that produces a type-safe log message, as configured in AcsNCTraceLog.xml.
 * <p>
 * The description for this log is: Disconnected from a notification channel <br>
 * The description for this group of logs is: ACS uses these messages to log notification service related activities such as creating channels, subscribing to a channel etc.
 */
public class LOG_NC_SubscriptionDisconnect_OK {
	public static final AcsLogLevel level = AcsLogLevel.DEBUG;
	private final Logger logger;
	private final Map<String, Object> nameValue;
	private final AcsLogRecord lr;	
	
	public LOG_NC_SubscriptionDisconnect_OK(Logger logger) {
		this.logger=logger;
		if (logger instanceof AcsLogger) {
			((AcsLogger)logger).addLoggerClass(this.getClass());
		}
		nameValue = new LinkedHashMap<String, Object>();
		nameValue.put("logName","LOG_NC_SubscriptionDisconnect_OK");
		lr = new AcsLogRecord(level, "Disconnected from a notification channel", nameValue, logger.getName());
		lr.setAudience("Developer");
	}
	public LOG_NC_SubscriptionDisconnect_OK(Logger logger, String array, String antenna) {
		this(logger);
		lr.setArray(array);
		lr.setAntenna(antenna);
	}	
	
	/**
	 * Convenience method for compact one-line logs.
	 * @since ACS 7.0.1
	 */
	public static void log(Logger logger, String ChannelName, String Service) {
		if (logger.isLoggable(level)) {	
			LOG_NC_SubscriptionDisconnect_OK instance = new LOG_NC_SubscriptionDisconnect_OK(logger);
			instance.setChannelName(ChannelName);
			instance.setService(Service);
			instance.log();
		}
	}
	
	public void setArray(String array) {
		lr.setArray(array);
	}
	public void setAntenna(String antenna) {
		lr.setAntenna(antenna);
	}
	public String getArray(){
		return lr.getArray();
	}
	public String getAntenna(){
		return lr.getAntenna();
	}
	
	/**
	 * Logs the message through the Logger supplied in the constructor, with the configured log level.
	 */	
	public void log() {
		logger.log(lr);
	}
	

	/**
	 * Sets log parameter ChannelName.
	 * @param ChannelName
	 *			Name of the channel subscribed to.
	 */
	public void setChannelName(String value) {
		nameValue.put("ChannelName", value);
	}
	/**
	 * Sets log parameter Service.
	 * @param Service
	 *			Name or ID of the notification service that hosts the channel.
	 */
	public void setService(String value) {
		nameValue.put("Service", value);
	}
}

