/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when      what
* --------  --------  ----------------------------------------------
*/

#include "rtLog.h"


/*
This test shall build and run on all machines RT and non RT as well.
*/

int main(int argc, char** argv) 
{
    rtlogRecord_t logRecord;
    int i;

    // we have to initialize the logging system
    LoggingProxy log(0, 0, 31, 0);
    LoggingProxy::init(&log);

    // do some logging
    for ( i = 0; i < 16; i++ )
	{
	RTLOG("rtlogTestNoRT", RTLOG_INFO, "%s", "hola mundo!");
	RTLOG("rtlogTestNoRT", RTLOG_ERROR,  "hola mundo (%d)!", i);
	}

    RTLOG("rtlogTestNoRT", RTLOG_ERROR,"test test!");

    RTLOG_TRACE("rtlogTestNoRT", "%s", "Trace: hola mundo !");
    RTLOG_DEBUG("rtlogTestNoRT", "Debug: hola mundo !");
    RTLOG_INFO("rtlogTestNoRT", "Info: hola mundo !");
    RTLOG_NOTICE("rtlogTestNoRT", "Notice: hola mundo !");
    RTLOG_WARNING("rtlogTestNoRT", "Warning: hola mundo !");
    RTLOG_ERROR("rtlogTestNoRT", "Error: hola mundo !");
    RTLOG_CRITICAL("rtlogTestNoRT", "Critical: hola mundo !");
    RTLOG_ALERT("rtlogTestNoRT", "Alert: hola mundo !");
    RTLOG_EMERGENCY("rtlogTestNoRT", "Emergency: hola mundo !");

    // wait that all log messages are actually sent 
    sleep(5);

    return 0;
}
