#ifndef _rtAlarmData_H_
#define _rtAlarmData_H_
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: rtAlarmData.h,v 1.1 2007/07/12 09:23:38 bjeram Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* bjeram  yyyy-mm-dd  created
*/

#ifndef NO_RTAI_HOME
#include <rtai_types.h>
#endif

#define RTALARM_MBX_SIZE 400 // if it is 500 or greater than rt_mbx_reacive returns -21 in the begining and destroy in user space does not work


/**
 * States for alarm description.
 */
typedef enum rtAlarmState 
{
  rtAlarm_ACTIVE,
  rtAlarm_TERMINATE
//  CHANGE (?)
} rtAlarmState_t;


/**
 * In RTOS alarms are represented as one number
 */
typedef unsigned int rtAlarmCode_t;

/**
 * rt alarm structure
 */
typedef struct rtAlarm 
{
    rtAlarmCode_t  alarmCode; /**< larm code */
    char property[256];       /**< property of the alarm. User's arbitrary data */
    RTIME timeStamp;   /**< time stamp of the alarm */
    rtAlarmState_t descriptor;  /**< description of the alarm */
} rtAlarm_t;


#endif 
