/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.net;

/**
 * Holder for binding information. Each client binding and server request 
 * contains an instance.
 *
 * @author Chris Wood
 * @version $Revision: 1.6 $ $Date: 2002/06/28 08:59:05 $ 
 */
public class TransportAssociationHolder
{
    public static final Object EMPTY_ASSOCIATION = new Object();

    private Object m_value;

    public Object getValue()
    {
        return m_value;
    }

    public void setValue( Object value )
    {
        m_value = value;
    }
}

