/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.object;

import org.openorb.compiler.parser.*;

/**
 * Cette classe represente l'objet IDL Sequence
 *
 * @author Jerome Daniel
 * @version $Revision: 1.4 $ $Date: 2002/08/21 08:19:22 $ 
 */

public class IdlSequence extends IdlObject implements org.openorb.compiler.idl.reflect.idlSequence
{
    /**
    * Taille de la sequence
    */
    private int size;

    /**
     * Cree un objet IDL Sequence
     */
    public IdlSequence( IdlObject father )
    {
        super( IdlType.e_sequence, father );
    }

    /**
     * Retourne la taille de la sequence
     *
     * @return la taille
     */
    public int getSize()
    {
        return size;
    }

    /**
     * Fixe la taille de la sequence
     *
     * @param sz la taille
     */
    public void setSize( int sz )
    {
        size = sz;
    }

    // ------------------------------------------------------------------------------------------
    // IDL Reflection
    // ------------------------------------------------------------------------------------------

    public int length()
    {
        return size;
    }

    public org.openorb.compiler.idl.reflect.idlObject internal()
    {
        reset();
        return current();
    }

    public java.util.Enumeration content()
    {
        return new org.openorb.compiler.idl.reflect.idlEnumeration( null );
    }

}

