/***** Copyright (c) 1999 Object Management Group. Unlimited rights to
     duplicate and use this code are hereby granted provided that this 
     copyright notice is included.
*****/

package org.omg.CORBA;

import org.apache.avalon.framework.CascadingThrowable;
import org.openorb.util.JREVersion;

public abstract class UserException extends java.lang.Exception
            implements org.omg.CORBA.portable.IDLEntity, CascadingThrowable
{
    private static final boolean JRE_1_4 = JREVersion.V1_4;

    private Throwable cause = this;

    public UserException()
    {
        super();
    }

    public UserException( final String value )
    {

        super( value );
    }

    public Throwable initCause( final Throwable cause ) 
    {
        if( JRE_1_4 )
        {
            return super.initCause( cause );
        }
        
        if( this.cause != this )
        {
            throw new IllegalStateException( "Can't overwrite cause" );
        }
        if( cause == this )
        {
            throw new IllegalArgumentException( "Self-causation not permitted" );
        }
        
        this.cause = cause;

        return this;
    }

    public Throwable getCause() 
    {
        if ( JRE_1_4 )
        {
            return super.getCause();
        }
        return ( ( cause == this ) ? null : cause);
    }
}
