-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE TMCDBVersion (
	DBName VARCHAR2 (32) NOT NULL,
	DBVersion VARCHAR2 (32) NOT NULL,
	DBDate VARCHAR2 (32) NOT NULL,
	CONSTRAINT TMCDBVersionKey PRIMARY KEY (DBName)
);


CREATE TABLE AcsService (
	AcsServiceId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	ServiceType VARCHAR2 (12) NOT NULL,
	ServiceInstanceName VARCHAR2 (256) NULL,
	ComputerId NUMBER (10) NOT NULL,
	CONSTRAINT AcsServiceConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT AcsServiceComputer FOREIGN KEY (ComputerId) REFERENCES Computer,
	CONSTRAINT AcsServiceServiceType CHECK (ServiceType IN ('NAMING', 'IFR', 'CDB', 'NOTIFICATION', 'LOGGING', 'MANAGER', 'ALARM', 'LOGPROXY')),
	CONSTRAINT AcsServiceKey PRIMARY KEY (AcsServiceId)
);

CREATE SEQUENCE AcsService_seq;

CREATE TABLE MasterComponent (
	MasterComponentId NUMBER (10) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	SubsystemName VARCHAR2 (256) NOT NULL,
	CONSTRAINT MasterCAltKey UNIQUE (ComponentId),
	CONSTRAINT MComponentId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT MasterCKey PRIMARY KEY (MasterComponentId)
);

CREATE SEQUENCE MasterC_seq;

CREATE TABLE NetworkDeviceSnmpConfig (
	NetworkDeviceId NUMBER (10) NOT NULL,
	SnmpXmlClob XMLTYPE NOT NULL,
	PropagateNA CHAR (1) DEFAULT '0',
	AcsAlarm VARCHAR2 (16) DEFAULT 'NEVER',
	SnmpCommunity VARCHAR2 (256) NULL,
	Netgroup VARCHAR2 (256) NULL,
	CONSTRAINT NetworDSCPropagateNA CHECK (PropagateNA IN ('0', '1')),
	CONSTRAINT NetDevSnmpConfigNetDev FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT NetDevSnmpConfigAcsAlarm CHECK (AcsAlarm IN ('NEVER', 'ALWAYS', 'ALLOWSUPPRESSION')),
	CONSTRAINT NetworDSCKey PRIMARY KEY (NetworkDeviceId)
) XMLTYPE COLUMN SnmpXmlClob STORE AS CLOB;


CREATE TABLE SnmpTrapSink (
	ConfigurationId NUMBER (10) NOT NULL,
	TrapSinkComputerId NUMBER (10) NOT NULL,
	TrapPort NUMBER (10) NOT NULL,
	TrapSourcesNetworkMask VARCHAR2 (256) NOT NULL,
	SnmpTrapCommunity VARCHAR2 (256) NULL,
	CONSTRAINT SnmpTrapSinkConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT SnmpTrapSinkComputer FOREIGN KEY (TrapSinkComputerId) REFERENCES Computer,
	CONSTRAINT SnmpTrapSinkKey PRIMARY KEY (ConfigurationId)
);


CREATE TABLE NetworkPowerstrip (
	NetworkDeviceId NUMBER (10),
	CONSTRAINT NetworPNetworDFKey FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT NetworPKey PRIMARY KEY (NetworkDeviceId)
);


CREATE TABLE PowerstripSocket (
	PowerstripSocketId NUMBER (10) NOT NULL,
	NetworkPowerstripId NUMBER (10) NOT NULL,
	SocketNumber NUMBER (10) NOT NULL,
	PoweredNetworkDeviceId NUMBER (10) NULL,
	SocketName VARCHAR2 (256) NULL,
	CONSTRAINT PowersSAltKey UNIQUE (NetworkPowerstripId, SocketNumber),
	CONSTRAINT PwrstripSockNetPowerstrip FOREIGN KEY (NetworkPowerstripId) REFERENCES NetworkPowerstrip,
	CONSTRAINT PwrstripSockNetDevice FOREIGN KEY (PoweredNetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT PowersSKey PRIMARY KEY (PowerstripSocketId)
);

CREATE SEQUENCE PowersS_seq;

 



INSERT INTO TMCDBVersion VALUES ( 'TMCDB', '2.1.13', '2009-10-17T0022:30:10.0' );

COMMIT;
