-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE ComponentType (
	ComponentTypeId NUMBER (10) NOT NULL,
	IDL VARCHAR2 (256) NOT NULL,
	URN VARCHAR2 (512) NULL,
	CONSTRAINT ComponTAltKey UNIQUE (IDL),
	CONSTRAINT ComponTKey PRIMARY KEY (ComponentTypeId)
);

CREATE SEQUENCE ComponT_seq;

CREATE TABLE Configuration (
	ConfigurationId NUMBER (10) NOT NULL,
	ConfigurationName VARCHAR2 (128) NOT NULL,
	FullName VARCHAR2 (256) NOT NULL,
	Active CHAR (1) NOT NULL,
	CreationTime TIMESTAMP (6) NOT NULL,
	Description VARCHAR2 (1024) NOT NULL,
	CONSTRAINT ConfigActive CHECK (Active IN ('0', '1')),
	CONSTRAINT ConfigAltKey UNIQUE (ConfigurationName),
	CONSTRAINT ConfigKey PRIMARY KEY (ConfigurationId)
);

CREATE SEQUENCE Config_seq;

CREATE TABLE Schemas (
	SchemaId NUMBER (10) NOT NULL,
	URN VARCHAR2 (512) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	Schema XMLTYPE NULL,
	CONSTRAINT SchemasAltKey UNIQUE (URN, ConfigurationId),
	CONSTRAINT SchemasConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT SchemasKey PRIMARY KEY (SchemaId)
) XMLTYPE COLUMN Schema STORE AS CLOB;

CREATE SEQUENCE Schemas_seq;

CREATE TABLE NetworkDevice (
	NetworkDeviceId NUMBER (10) NOT NULL,
	NetworkName VARCHAR2 (256) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	PhysicalLocation VARCHAR2 (256) NULL,
	Name VARCHAR2 (256) NULL,
	CONSTRAINT NetworDAltKey UNIQUE (NetworkName, ConfigurationId),
	CONSTRAINT NetworkDeviceConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT NetworDKey PRIMARY KEY (NetworkDeviceId)
);

CREATE SEQUENCE NetworD_seq;

CREATE TABLE Computer (
	NetworkDeviceId NUMBER (10),
	ProcessorType CHAR (3) NOT NULL,
	RealTime CHAR (1) NOT NULL,
	Diskless CHAR (1) NOT NULL,
	CONSTRAINT ComputerRealTime CHECK (RealTime IN ('0', '1')),
	CONSTRAINT ComputerDiskless CHECK (Diskless IN ('0', '1')),
	CONSTRAINT ChildComputerProcessorType CHECK (ProcessorType IN ('uni', 'smp')),
	CONSTRAINT ComputerNetworDFKey FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT ComputerKey PRIMARY KEY (NetworkDeviceId)
);


CREATE TABLE LoggingConfig (
	LoggingConfigId NUMBER (10) NOT NULL,
	MinLogLevelDefault NUMBER (3) DEFAULT 2,
	MinLogLevelLocalDefault NUMBER (3) DEFAULT 2,
	CentralizedLogger VARCHAR2 (16) DEFAULT 'Log',
	DispatchPacketSize NUMBER (3) DEFAULT 10,
	ImmediateDispatchLevel NUMBER (3) DEFAULT 10,
	FlushPeriodSeconds NUMBER (3) DEFAULT 10,
	MaxLogQueueSize NUMBER (10) DEFAULT 1000,
	CONSTRAINT LogginCKey PRIMARY KEY (LoggingConfigId)
);

CREATE SEQUENCE LogginC_seq;

CREATE TABLE NamedLoggerConfig (
	NamedLoggerConfigId NUMBER (10) NOT NULL,
	LoggingConfigId NUMBER (10) NOT NULL,
	Name VARCHAR2 (64) NOT NULL,
	MinLogLevel NUMBER (3) DEFAULT 2,
	MinLogLevelLocal NUMBER (3) DEFAULT 2,
	CONSTRAINT NamedLCAltKey UNIQUE (LoggingConfigId, Name),
	CONSTRAINT NamedLoggerConfigLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT NamedLCKey PRIMARY KEY (NamedLoggerConfigId)
);

CREATE SEQUENCE NamedLC_seq;

CREATE TABLE Manager (
	ManagerId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	LoggingConfigId NUMBER (10) NOT NULL,
	Startup VARCHAR2 (256) NULL,
	ServiceComponents VARCHAR2 (256) NULL,
	Timeout NUMBER (10) DEFAULT 50,
	ClientPingInterval NUMBER (10) DEFAULT 60,
	AdministratorPingInterval NUMBER (10) DEFAULT 45,
	ContainerPingInterval NUMBER (10) DEFAULT 30,
	ServerThreads NUMBER (3) DEFAULT 10,
	DeadlockTimeout NUMBER (10) DEFAULT 180,
	CONSTRAINT ManagerAltKey UNIQUE (ConfigurationId, LoggingConfigId, Startup, ServiceComponents, Timeout, ClientPingInterval, AdministratorPingInterval, ContainerPingInterval, ServerThreads, DeadlockTimeout),
	CONSTRAINT ManagerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT ManagerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ManagerKey PRIMARY KEY (ManagerId)
);

CREATE SEQUENCE Manager_seq;

CREATE TABLE Container (
	ContainerId NUMBER (10) NOT NULL,
	ContainerName VARCHAR2 (256) NOT NULL,
	Path VARCHAR2 (256) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	LoggingConfigId NUMBER (10) NOT NULL,
	ImplLang VARCHAR2 (6) NOT NULL,
	RealTime CHAR (1) DEFAULT '0',
	RealTimeType VARCHAR2 (4) DEFAULT 'NONE',
	KernelModuleLocation VARCHAR2 (1024) NULL,
	KernelModule VARCHAR2 (1024) NULL,
	ComputerId NUMBER (10) NULL,
	TypeModifiers VARCHAR2 (64) NULL,
	StartOnDemand CHAR (1) DEFAULT '0',
	KeepAliveTime NUMBER (10) DEFAULT -1,
	ServerThreads NUMBER (10) DEFAULT 5,
	ManagerRetry NUMBER (10) DEFAULT 10,
	CallTimeout NUMBER (10) DEFAULT 30,
	PingInterval NUMBER (10) NULL,
	Recovery CHAR (1) DEFAULT '1',
	AutoloadSharedLibs VARCHAR2 (128) NULL,
	CONSTRAINT ContainerRealTime CHECK (RealTime IN ('0', '1')),
	CONSTRAINT ContainerStartOD CHECK (StartOnDemand IN ('0', '1')),
	CONSTRAINT ContainerRecovery CHECK (Recovery IN ('0', '1')),
	CONSTRAINT ContainerAltKey UNIQUE (ContainerName, Path, ConfigurationId),
	CONSTRAINT ContainerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ContainerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT ContainerComputer FOREIGN KEY (ComputerId) REFERENCES Computer,
	CONSTRAINT ContainerImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT ContainerRealTimeType CHECK (RealTimeType IN ('NONE', 'ABM', 'CORR')),
	CONSTRAINT ContainerKey PRIMARY KEY (ContainerId)
);

CREATE SEQUENCE Container_seq;

CREATE TABLE ContainerStartupOption (
	ContStartOptId NUMBER (10) NOT NULL,
	ContainerId NUMBER (10) NOT NULL,
	OptionType VARCHAR2 (16) NOT NULL,
	OptionName VARCHAR2 (256) NOT NULL,
	OptionValue VARCHAR2 (256) NOT NULL,
	CONSTRAINT ContStartOptContainer FOREIGN KEY (ContainerId) REFERENCES Container,
	CONSTRAINT ContStartOptType CHECK (OptionType IN ('ENV_VAR', 'EXEC_ARG', 'EXEC_ARG_LANG', 'CONT_ARG')),
	CONSTRAINT ContaiSOKey PRIMARY KEY (ContStartOptId)
);

CREATE SEQUENCE ContaiSO_seq;

CREATE TABLE Component (
	ComponentId NUMBER (10) NOT NULL,
	ComponentTypeId NUMBER (10) NOT NULL,
	ComponentName VARCHAR2 (256) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	ContainerId NUMBER (10) NULL,
	ImplLang VARCHAR2 (6) NOT NULL,
	RealTime CHAR (1) NOT NULL,
	Code VARCHAR2 (256) NOT NULL,
	Path VARCHAR2 (256) NOT NULL,
	IsAutostart CHAR (1) NOT NULL,
	IsDefault CHAR (1) NOT NULL,
	IsStandaloneDefined CHAR (1) NULL,
	IsControl CHAR (1) NOT NULL,
	KeepAliveTime NUMBER (10) NOT NULL,
	MinLogLevel NUMBER (3) DEFAULT -1,
	MinLogLevelLocal NUMBER (3) DEFAULT -1,
	XMLDoc XMLTYPE NULL,
	CONSTRAINT ComponentRealTime CHECK (RealTime IN ('0', '1')),
	CONSTRAINT ComponentIsAutostart CHECK (IsAutostart IN ('0', '1')),
	CONSTRAINT ComponentIsDefault CHECK (IsDefault IN ('0', '1')),
	CONSTRAINT ComponentIsStanD CHECK (IsStandaloneDefined IN ('0', '1')),
	CONSTRAINT ComponentIsControl CHECK (IsControl IN ('0', '1')),
	CONSTRAINT ComponentAltKey UNIQUE (Path, ComponentName, ConfigurationId),
	CONSTRAINT ComponentIDL FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT ComponentContainer FOREIGN KEY (ContainerId) REFERENCES Container,
	CONSTRAINT ComponentConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT ComponentKey PRIMARY KEY (ComponentId)
) XMLTYPE COLUMN XMLDoc STORE AS CLOB;

CREATE SEQUENCE Component_seq;

CREATE TABLE BACIProperty (
	BACIPropertyId NUMBER (10) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	PropertyName VARCHAR2 (128) NOT NULL,
	description VARCHAR2 (1024) NOT NULL,
	isSequence CHAR (1) NOT NULL,
	format VARCHAR2 (16) NOT NULL,
	units VARCHAR2 (24) NOT NULL,
	resolution VARCHAR2 (10) NOT NULL,
	archive_priority NUMBER (10) NOT NULL,
	archive_min_int BINARY_DOUBLE NOT NULL,
	archive_max_int BINARY_DOUBLE NOT NULL,
	default_timer_trig BINARY_DOUBLE NOT NULL,
	min_timer_trig BINARY_DOUBLE NOT NULL,
	initialize_devio CHAR (1) NOT NULL,
	min_delta_trig BINARY_DOUBLE NULL,
	default_value VARCHAR2 (1024) NOT NULL,
	graph_min BINARY_DOUBLE NULL,
	graph_max BINARY_DOUBLE NULL,
	min_step BINARY_DOUBLE NULL,
	archive_delta BINARY_DOUBLE NOT NULL,
	alarm_high_on BINARY_DOUBLE NULL,
	alarm_low_on BINARY_DOUBLE NULL,
	alarm_high_off BINARY_DOUBLE NULL,
	alarm_low_off BINARY_DOUBLE NULL,
	alarm_timer_trig BINARY_DOUBLE NULL,
	min_value BINARY_DOUBLE NULL,
	max_value BINARY_DOUBLE NULL,
	bitDescription VARCHAR2 (1024) NULL,
	whenSet VARCHAR2 (1024) NULL,
	whenCleared VARCHAR2 (1024) NULL,
	statesDescription VARCHAR2 (1024) NULL,
	condition VARCHAR2 (1024) NULL,
	alarm_on VARCHAR2 (1024) NULL,
	alarm_off VARCHAR2 (1024) NULL,
	alarm_fault_family VARCHAR2 (1024) NULL,
	alarm_fault_member VARCHAR2 (1024) NULL,
	alarm_level NUMBER (10) NULL,
	Data VARCHAR2 (1024) NULL,
	CONSTRAINT BACIPropertyisSequence CHECK (isSequence IN ('0', '1')),
	CONSTRAINT BACIPropertyinitia CHECK (initialize_devio IN ('0', '1')),
	CONSTRAINT BACIPropertyAltKey UNIQUE (PropertyName, ComponentId),
	CONSTRAINT BACIPropertyCompId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT BACIPropertyKey PRIMARY KEY (BACIPropertyId)
);

CREATE SEQUENCE BACIProperty_seq;

CREATE TABLE Location (
	LocationId NUMBER (10) NOT NULL,
	Building VARCHAR2 (256) NULL,
	Floor VARCHAR2 (128) NULL,
	Room VARCHAR2 (256) NULL,
	Mnemonic VARCHAR2 (256) NULL,
	LocationPosition VARCHAR2 (256) NULL,
	CONSTRAINT LocationAltKey UNIQUE (Building, Floor, Room, Mnemonic, LocationPosition),
	CONSTRAINT LocationKey PRIMARY KEY (LocationId)
);

CREATE SEQUENCE Location_seq;

CREATE TABLE Contact (
	ContactId NUMBER (10) NOT NULL,
	ContactName VARCHAR2 (256) NOT NULL,
	Email VARCHAR2 (256) NULL,
	Gsm VARCHAR2 (256) NULL,
	CONSTRAINT ContactAltKey UNIQUE (ContactName),
	CONSTRAINT ContactKey PRIMARY KEY (ContactId)
);

CREATE SEQUENCE Contact_seq;

CREATE TABLE AlarmCategory (
	AlarmCategoryId NUMBER (10) NOT NULL,
	AlarmCategoryName VARCHAR2 (128) NOT NULL,
	Description VARCHAR2 (1024) NOT NULL,
	Path VARCHAR2 (256) NOT NULL,
	IsDefault CHAR (1) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	CONSTRAINT AlarmCIsDefault CHECK (IsDefault IN ('0', '1')),
	CONSTRAINT AlarmCAltKey UNIQUE (AlarmCategoryName, ConfigurationId),
	CONSTRAINT AlarmCategoryConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT AlarmCKey PRIMARY KEY (AlarmCategoryId)
);

CREATE SEQUENCE AlarmC_seq;

CREATE TABLE FaultFamily (
	FaultFamilyId NUMBER (10) NOT NULL,
	FamilyName VARCHAR2 (256) NOT NULL,
	AlarmSource VARCHAR2 (256) DEFAULT 'ALARM_SYSTEM_SOURCES',
	HelpURL VARCHAR2 (256) NULL,
	ContactId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	CONSTRAINT FaultFamilyAltKey UNIQUE (FamilyName, ConfigurationId),
	CONSTRAINT FaultFamilyContact FOREIGN KEY (ContactId) REFERENCES Contact,
	CONSTRAINT FaultFamilyConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT FaultFamilyKey PRIMARY KEY (FaultFamilyId)
);

CREATE SEQUENCE FaultFamily_seq;

CREATE TABLE AlarmCategoryFamily (
	AlarmCategoryId NUMBER (10) NOT NULL,
	FaultFamilyId NUMBER (10) NOT NULL,
	CONSTRAINT ACFCategoryId FOREIGN KEY (AlarmCategoryId) REFERENCES AlarmCategory,
	CONSTRAINT ACFFamilyId FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT AlarmCFKey PRIMARY KEY (AlarmCategoryId, FaultFamilyId)
);


CREATE TABLE FaultMember (
	FaultMemberId NUMBER (10) NOT NULL,
	MemberName VARCHAR2 (256) NOT NULL,
	FaultFamilyId NUMBER (10) NOT NULL,
	LocationId NUMBER (10) NULL,
	CONSTRAINT FaultMemberAltKey UNIQUE (MemberName, FaultFamilyId),
	CONSTRAINT FaultMemFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT FaultMemLocationRef FOREIGN KEY (LocationId) REFERENCES Location,
	CONSTRAINT FaultMemberKey PRIMARY KEY (FaultMemberId)
);

CREATE SEQUENCE FaultMember_seq;

CREATE TABLE DefaultMember (
	DefaultMemberId NUMBER (10) NOT NULL,
	FaultFamilyId NUMBER (10) NOT NULL,
	LocationID NUMBER (10) NULL,
	CONSTRAINT DefaulMAltKey UNIQUE (FaultFamilyId),
	CONSTRAINT DefaultMemberFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT DefaultMemberLocationRef FOREIGN KEY (LocationID) REFERENCES Location,
	CONSTRAINT DefaulMKey PRIMARY KEY (DefaultMemberId)
);

CREATE SEQUENCE DefaulM_seq;

CREATE TABLE FaultCode (
	FaultCodeId NUMBER (10) NOT NULL,
	FaultFamilyId NUMBER (10) NOT NULL,
	CodeValue NUMBER (10) NOT NULL,
	Priority NUMBER (10) NOT NULL,
	Cause VARCHAR2 (256) NULL,
	Action VARCHAR2 (1024) NULL,
	Consequence VARCHAR2 (1024) NULL,
	ProblemDescription VARCHAR2 (1024) NOT NULL,
	IsInstant CHAR (1) NOT NULL,
	CONSTRAINT FaultCodeIsInstant CHECK (IsInstant IN ('0', '1')),
	CONSTRAINT FaultCodeAltKey UNIQUE (FaultFamilyId, CodeValue),
	CONSTRAINT CodeFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT PriorityValue CHECK (Priority IN (0, 1, 2, 3)),
	CONSTRAINT FaultCodeKey PRIMARY KEY (FaultCodeId)
);

CREATE SEQUENCE FaultCode_seq;

CREATE TABLE AlarmDefinition (
	AlarmDefinitionId NUMBER (10) NOT NULL,
	FaultMemberId NUMBER (10) NOT NULL,
	FaultCodeId NUMBER (10) NOT NULL,
	CONSTRAINT AlarmDAltKey UNIQUE (FaultMemberId, FaultCodeId),
	CONSTRAINT AlarmDefMmemberRef FOREIGN KEY (FaultMemberId) REFERENCES FaultMember,
	CONSTRAINT AlarmDefCodeRef FOREIGN KEY (FaultCodeId) REFERENCES FaultCode,
	CONSTRAINT AlarmDKey PRIMARY KEY (AlarmDefinitionId)
);

CREATE SEQUENCE AlarmD_seq;

CREATE TABLE ReductionLink (
	ParentAlarmDefId NUMBER (10) NOT NULL,
	ChildAlarmDefId NUMBER (10) NOT NULL,
	Type VARCHAR2 (12) NOT NULL,
	Action VARCHAR2 (6) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	CONSTRAINT RLParentRef FOREIGN KEY (ParentAlarmDefId) REFERENCES AlarmDefinition,
	CONSTRAINT RLChildRef FOREIGN KEY (ChildAlarmDefId) REFERENCES AlarmDefinition,
	CONSTRAINT ReductionLinkConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ReductionLinkType CHECK (Type IN ('MULTIPLICITY', 'NODE')),
	CONSTRAINT ReductionLinkAction CHECK (Action IN ('CREATE', 'REMOVE')),
	CONSTRAINT ReductLKey PRIMARY KEY (ParentAlarmDefId, ChildAlarmDefId)
);


CREATE TABLE ReductionThreshold (
	AlarmDefinitionId NUMBER (10) NOT NULL,
	Value NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	CONSTRAINT RTAlarmRef FOREIGN KEY (AlarmDefinitionId) REFERENCES AlarmDefinition,
	CONSTRAINT RTConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ReductTKey PRIMARY KEY (AlarmDefinitionId)
);


CREATE TABLE EventChannel (
	EventChannelId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	Name VARCHAR2 (256) NOT NULL,
	Path VARCHAR2 (256) NOT NULL,
	IntegrationLogs CHAR (1) DEFAULT '0',
	MaxQueueLength NUMBER (10) DEFAULT 0,
	MaxConsumers NUMBER (10) DEFAULT 0,
	MaxSuppliers NUMBER (10) DEFAULT 0,
	RejectNewEvents CHAR (1) DEFAULT '1',
	DiscardPolicy VARCHAR2 (20) DEFAULT 'AnyOrder',
	EventReliability VARCHAR2 (20) DEFAULT 'BestEffort',
	ConnectionReliability VARCHAR2 (20) DEFAULT 'BestEffort',
	Priority NUMBER (5) DEFAULT 0,
	Timeout NUMBER (10) DEFAULT 0,
	OrderPolicy VARCHAR2 (20) DEFAULT 'AnyOrder',
	StartTimeSupported CHAR (1) DEFAULT '0',
	StopTimeSupported CHAR (1) DEFAULT '0',
	MaxEventsPerConsumer NUMBER (10) DEFAULT 0,
	CONSTRAINT EventChannelIntegrL CHECK (IntegrationLogs IN ('0', '1')),
	CONSTRAINT EventChannelRejectNE CHECK (RejectNewEvents IN ('0', '1')),
	CONSTRAINT EventChannelStartTS CHECK (StartTimeSupported IN ('0', '1')),
	CONSTRAINT EventChannelStopTiS CHECK (StopTimeSupported IN ('0', '1')),
	CONSTRAINT EventChannelAltKey UNIQUE (Name, Path, ConfigurationId),
	CONSTRAINT EventChannelConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT EventChannelDiscardPolicy CHECK (DiscardPolicy IN ('AnyOrder', 'FifoOrder', 'LifoOrder', 'PriorityOrder', 'DeadlineOrder')),
	CONSTRAINT EventChannelOrderPolicy CHECK (OrderPolicy IN ('AnyOrder', 'FifoOrder', 'LifoOrder', 'PriorityOrder', 'DeadlineOrder')),
	CONSTRAINT EventChannelEventReliability CHECK (EventReliability IN ('BestEffort', 'Persistent')),
	CONSTRAINT EventChannelConReliability CHECK (ConnectionReliability IN ('BestEffort', 'Persistent')),
	CONSTRAINT EventChannelKey PRIMARY KEY (EventChannelId)
);

CREATE SEQUENCE EventChannel_seq;

CREATE TABLE Event (
	EventId NUMBER (10) NOT NULL,
	EventChannelId NUMBER (10) NOT NULL,
	Name VARCHAR2 (256) NOT NULL,
	MaxProcessTime BINARY_DOUBLE DEFAULT '2.0',
	CONSTRAINT EventAltKey UNIQUE (EventChannelId, Name),
	CONSTRAINT EventEventChannelRef FOREIGN KEY (EventChannelId) REFERENCES EventChannel,
	CONSTRAINT EventKey PRIMARY KEY (EventId)
);

CREATE SEQUENCE Event_seq;

CREATE TABLE NotificationServiceMapping (
	NotificationServiceMappingId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	DefaultNotificationService VARCHAR2 (256) NOT NULL,
	CONSTRAINT NotifiSMAltKey UNIQUE (ConfigurationId),
	CONSTRAINT NotServMapConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT NotifiSMKey PRIMARY KEY (NotificationServiceMappingId)
);

CREATE SEQUENCE NotifiSM_seq;

CREATE TABLE DomainsMapping (
	DomainsMappingId NUMBER (10) NOT NULL,
	Name VARCHAR2 (256) NOT NULL,
	NotificationService VARCHAR2 (256) NOT NULL,
	NotificationServiceMappingId NUMBER (10) NOT NULL,
	CONSTRAINT DomainMAltKey UNIQUE (NotificationServiceMappingId, Name),
	CONSTRAINT DomainsNotServMapRef FOREIGN KEY (NotificationServiceMappingId) REFERENCES NotificationServiceMapping,
	CONSTRAINT DomainMKey PRIMARY KEY (DomainsMappingId)
);

CREATE SEQUENCE DomainM_seq;

CREATE TABLE ChannelMapping (
	ChannelMappingId NUMBER (10) NOT NULL,
	Name VARCHAR2 (256) NOT NULL,
	NotificationService VARCHAR2 (256) NOT NULL,
	NotificationServiceMappingId NUMBER (10) NOT NULL,
	CONSTRAINT ChanneMAltKey UNIQUE (NotificationServiceMappingId, Name),
	CONSTRAINT ChannelNotServMapRef FOREIGN KEY (NotificationServiceMappingId) REFERENCES NotificationServiceMapping,
	CONSTRAINT ChanneMKey PRIMARY KEY (ChannelMappingId)
);

CREATE SEQUENCE ChanneM_seq;

 


