-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE HWConfiguration (
	ConfigurationId NUMBER (10) NOT NULL,
	SwConfigurationId NUMBER (10) NOT NULL,
	ArrayReferenceX BINARY_DOUBLE NULL,
	ArrayReferenceY BINARY_DOUBLE NULL,
	ArrayReferenceZ BINARY_DOUBLE NULL,
	CONSTRAINT HWConfAltKey UNIQUE (SwConfigurationId),
	CONSTRAINT SwConfigId FOREIGN KEY (SwConfigurationId) REFERENCES Configuration,
	CONSTRAINT HWConfKey PRIMARY KEY (ConfigurationId)
);

CREATE SEQUENCE HWConf_seq;

CREATE TABLE Startup (
	StartupId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	StartupName VARCHAR2 (256) NOT NULL,
	CONSTRAINT StartupAltKey UNIQUE (StartupName, ConfigurationId),
	CONSTRAINT StartupConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT StartupKey PRIMARY KEY (StartupId)
);

CREATE SEQUENCE Startup_seq;

CREATE TABLE LRUType (
	LRUName VARCHAR2 (128) NOT NULL,
	FullName VARCHAR2 (256) NOT NULL,
	ICD VARCHAR2 (256) NOT NULL,
	ICDDate NUMBER (19) NOT NULL,
	Description VARCHAR2 (1024) NOT NULL,
	Notes VARCHAR2 (1024) NULL,
	CONSTRAINT LRUTypeKey PRIMARY KEY (LRUName)
);


CREATE TABLE HwSchemas (
	SchemaId NUMBER (10) NOT NULL,
	URN VARCHAR2 (512) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	Schema XMLTYPE NULL,
	CONSTRAINT HwSchemasAltKey UNIQUE (URN, ConfigurationId),
	CONSTRAINT AssemblySchemasConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT HwSchemasKey PRIMARY KEY (SchemaId)
) XMLTYPE COLUMN Schema STORE AS CLOB;

CREATE SEQUENCE HwSchemas_seq;

CREATE TABLE AssemblyType (
	AssemblyTypeName VARCHAR2 (256) NOT NULL,
	BaseElementType VARCHAR2 (24) NOT NULL,
	LRUName VARCHAR2 (128) NOT NULL,
	FullName VARCHAR2 (256) NOT NULL,
	Description VARCHAR2 (1024) NOT NULL,
	Notes VARCHAR2 (1024) NULL,
	ComponentTypeId NUMBER (10) NOT NULL,
	SchemaId NUMBER (10) NULL,
	CONSTRAINT AssemblyTypeLRUName FOREIGN KEY (LRUName) REFERENCES LRUType,
	CONSTRAINT AssemblyTypeHwSchema FOREIGN KEY (SchemaId) REFERENCES HwSchemas,
	CONSTRAINT AssemblyTypeCompType FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT AssemblyTypeBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array')),
	CONSTRAINT AssemblyTypeKey PRIMARY KEY (AssemblyTypeName)
);


CREATE TABLE DefaultComponent (
	DefaultComponentId NUMBER (10) NOT NULL,
	ComponentTypeId NUMBER (10) NOT NULL,
	AssemblyTypeName VARCHAR2 (256) NOT NULL,
	ImplLang VARCHAR2 (6) NOT NULL,
	RealTime CHAR (1) NOT NULL,
	Code VARCHAR2 (256) NOT NULL,
	Path VARCHAR2 (256) NOT NULL,
	IsAutostart CHAR (1) NOT NULL,
	IsDefault CHAR (1) NOT NULL,
	IsStandaloneDefined CHAR (1) NULL,
	KeepAliveTime NUMBER (10) NOT NULL,
	MinLogLevel NUMBER (3) DEFAULT -1,
	MinLogLevelLocal NUMBER (3) DEFAULT -1,
	XMLDoc XMLTYPE NULL,
	CONSTRAINT DefaulCRealTime CHECK (RealTime IN ('0', '1')),
	CONSTRAINT DefaulCIsAutostart CHECK (IsAutostart IN ('0', '1')),
	CONSTRAINT DefaulCIsDefault CHECK (IsDefault IN ('0', '1')),
	CONSTRAINT DefaulCIsStanD CHECK (IsStandaloneDefined IN ('0', '1')),
	CONSTRAINT DefaultComponentTypeId FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT DefaultComponentAssemblyId FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT DefaultComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT DefaulCKey PRIMARY KEY (DefaultComponentId)
) XMLTYPE COLUMN XMLDoc STORE AS CLOB;


CREATE TABLE DefaultBaciProperty (
	DefaultBaciPropId NUMBER (10) NOT NULL,
	DefaultComponentId NUMBER (10) NOT NULL,
	PropertyName VARCHAR2 (128) NOT NULL,
	description VARCHAR2 (1024) NOT NULL,
	format VARCHAR2 (16) NOT NULL,
	units VARCHAR2 (24) NOT NULL,
	resolution VARCHAR2 (10) NOT NULL,
	archive_priority NUMBER (10) NOT NULL,
	archive_min_int BINARY_DOUBLE NOT NULL,
	archive_max_int BINARY_DOUBLE NOT NULL,
	default_timer_trig BINARY_DOUBLE NOT NULL,
	min_timer_trig BINARY_DOUBLE NOT NULL,
	initialize_devio CHAR (1) NOT NULL,
	min_delta_trig BINARY_DOUBLE NULL,
	default_value VARCHAR2 (1024) NOT NULL,
	graph_min BINARY_DOUBLE NULL,
	graph_max BINARY_DOUBLE NULL,
	min_step BINARY_DOUBLE NULL,
	archive_delta BINARY_DOUBLE NOT NULL,
	alarm_high_on BINARY_DOUBLE NULL,
	alarm_low_on BINARY_DOUBLE NULL,
	alarm_high_off BINARY_DOUBLE NULL,
	alarm_low_off BINARY_DOUBLE NULL,
	alarm_timer_trig BINARY_DOUBLE NULL,
	min_value BINARY_DOUBLE NULL,
	max_value BINARY_DOUBLE NULL,
	bitDescription VARCHAR2 (1024) NULL,
	whenSet VARCHAR2 (1024) NULL,
	whenCleared VARCHAR2 (1024) NULL,
	statesDescription VARCHAR2 (1024) NULL,
	condition VARCHAR2 (1024) NULL,
	alarm_on VARCHAR2 (1024) NULL,
	alarm_off VARCHAR2 (1024) NULL,
	Data VARCHAR2 (1024) NULL,
	CONSTRAINT DefaulBPinitia CHECK (initialize_devio IN ('0', '1')),
	CONSTRAINT DefBACIDefaultComponentTypeId FOREIGN KEY (DefaultComponentId) REFERENCES DefaultComponent,
	CONSTRAINT DefaulBPKey PRIMARY KEY (DefaultBaciPropId)
);


CREATE TABLE DefaultMonitorPoint (
	DefaultMonitorPointId NUMBER (10) NOT NULL,
	DefaultBACIPropertyId NUMBER (10) NOT NULL,
	MonitorPointName VARCHAR2 (128) NOT NULL,
	Indice NUMBER (10) NOT NULL,
	DataType VARCHAR2 (16) NOT NULL,
	RCA VARCHAR2 (16) NOT NULL,
	TeRelated CHAR (1) NOT NULL,
	RawDataType VARCHAR2 (24) NOT NULL,
	WorldDataType VARCHAR2 (24) NOT NULL,
	Units VARCHAR2 (24) NULL,
	Scale BINARY_DOUBLE NULL,
	Offset BINARY_DOUBLE NULL,
	MinRange VARCHAR2 (24) NULL,
	MaxRange VARCHAR2 (24) NULL,
	Description VARCHAR2 (1024) NOT NULL,
	CONSTRAINT DefaulMPTeRelated CHECK (TeRelated IN ('0', '1')),
	CONSTRAINT DefaulPntId FOREIGN KEY (DefaultBACIPropertyId) REFERENCES DefaultBaciProperty,
	CONSTRAINT DefaulMPKey PRIMARY KEY (DefaultMonitorPointId)
);


CREATE TABLE Assembly (
	AssemblyId NUMBER (10) NOT NULL,
	AssemblyTypeName VARCHAR2 (256) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	SerialNumber VARCHAR2 (256) NOT NULL,
	Data XMLTYPE NULL,
	CONSTRAINT AssemblyAltKey UNIQUE (SerialNumber, ConfigurationId),
	CONSTRAINT AssemblyConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT AssemblyName FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT AssemblyKey PRIMARY KEY (AssemblyId)
) XMLTYPE COLUMN Data STORE AS CLOB;

CREATE SEQUENCE Assembly_seq;

CREATE TABLE AssemblyRole (
	RoleName VARCHAR2 (128) NOT NULL,
	AssemblyTypeName VARCHAR2 (256) NOT NULL,
	CONSTRAINT AssemblyRoleAssembly FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT AssemblyRoleKey PRIMARY KEY (RoleName)
);


CREATE TABLE MonitorPoint (
	MonitorPointId NUMBER (10) NOT NULL,
	BACIPropertyId NUMBER (10) NOT NULL,
	MonitorPointName VARCHAR2 (128) NOT NULL,
	AssemblyId NUMBER (10) NOT NULL,
	Indice NUMBER (10) NOT NULL,
	DataType VARCHAR2 (16) NOT NULL,
	RCA VARCHAR2 (16) NOT NULL,
	TeRelated CHAR (1) NOT NULL,
	RawDataType VARCHAR2 (24) NOT NULL,
	WorldDataType VARCHAR2 (24) NOT NULL,
	Units VARCHAR2 (24) NULL,
	Scale BINARY_DOUBLE NULL,
	Offset BINARY_DOUBLE NULL,
	MinRange VARCHAR2 (24) NULL,
	MaxRange VARCHAR2 (24) NULL,
	Description VARCHAR2 (1024) NOT NULL,
	CONSTRAINT MonitorPointTeRelated CHECK (TeRelated IN ('0', '1')),
	CONSTRAINT MonitorPointAltKey UNIQUE (BACIPropertyId, AssemblyId, Indice),
	CONSTRAINT MonitorPointAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
	CONSTRAINT MonitorPointBACIPropertyId FOREIGN KEY (BACIPropertyId) REFERENCES BACIProperty,
	CONSTRAINT MonitorPointDatatype CHECK (DataType IN ('float', 'double', 'boolean', 'string', 'integer', 'enum', 'clob')),
	CONSTRAINT MonitorPointKey PRIMARY KEY (MonitorPointId)
);

CREATE SEQUENCE MonitorPoint_seq;

CREATE TABLE MonitorData (
	MonitorPointId NUMBER (10) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NOT NULL,
	MonitorTS TIMESTAMP (6) NOT NULL,
	SampleSize NUMBER (10) NOT NULL,
	MonitorClob CLOB NOT NULL,
	MinStat BINARY_DOUBLE NULL,
	MaxStat BINARY_DOUBLE NULL,
	MeanStat BINARY_DOUBLE NULL,
	StdDevStat BINARY_DOUBLE NULL,
	CONSTRAINT MonitorDataMonitorPointId FOREIGN KEY (MonitorPointId) REFERENCES MonitorPoint,
	CONSTRAINT MonitorDataKey PRIMARY KEY (MonitorPointId, MonitorTS)
);


CREATE TABLE BaseElement (
	BaseElementId NUMBER (10) NOT NULL,
	BaseType VARCHAR2 (24) NOT NULL,
	BaseElementName VARCHAR2 (24) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	CONSTRAINT BaseElementAltKey UNIQUE (BaseElementName, ConfigurationId),
	CONSTRAINT BEConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT BEType CHECK (BaseType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array')),
	CONSTRAINT BaseElementKey PRIMARY KEY (BaseElementId)
);

CREATE SEQUENCE BaseElement_seq;

CREATE TABLE BaseElementOnline (
	BaseElementOnlineId NUMBER (10) NOT NULL,
	BaseElementId NUMBER (10) NOT NULL,
	ConfigurationId NUMBER (10) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	NormalTermination CHAR (1) NOT NULL,
	CONSTRAINT BaseElONormalT CHECK (NormalTermination IN ('0', '1')),
	CONSTRAINT BaseElOAltKey UNIQUE (BaseElementId, ConfigurationId, StartTime),
	CONSTRAINT BEOnlineId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT BEOnlineConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT BaseElOKey PRIMARY KEY (BaseElementOnlineId)
);

CREATE SEQUENCE BaseElO_seq;

CREATE TABLE Antenna (
	BaseElementId NUMBER (10) NOT NULL,
	AntennaName VARCHAR2 (128) NULL,
	AntennaType VARCHAR2 (4) NOT NULL,
	DishDiameter BINARY_DOUBLE NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	XPosition BINARY_DOUBLE NOT NULL,
	YPosition BINARY_DOUBLE NOT NULL,
	ZPosition BINARY_DOUBLE NOT NULL,
	XOffset BINARY_DOUBLE NOT NULL,
	YOffset BINARY_DOUBLE NOT NULL,
	ZOffset BINARY_DOUBLE NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	AvgDelay BINARY_DOUBLE NULL,
	CONSTRAINT AntennaBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT AntennaComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT AntennaType CHECK (AntennaType IN ('VA', 'AEC', 'ACA')),
	CONSTRAINT AntennaKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE Pad (
	BaseElementId NUMBER (10) NOT NULL,
	PadName VARCHAR2 (128) NULL,
	CommissionDate NUMBER (19) NOT NULL,
	XPosition BINARY_DOUBLE NOT NULL,
	YPosition BINARY_DOUBLE NOT NULL,
	ZPosition BINARY_DOUBLE NOT NULL,
	AvgDelay BINARY_DOUBLE NULL,
	CONSTRAINT PadBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT PadKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE CorrHWConfiguration (
	BaseElementId NUMBER (10) NOT NULL,
	CorrHWName VARCHAR2 (128) NOT NULL,
	CorrHWType VARCHAR2 (30) NOT NULL,
	CONSTRAINT CorrHWBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT CorrelatorHWType CHECK (CorrHWType IN ('CORRELATOR_12m_2ANTS', 'CORRELATOR_12m_1QUADRANT', 'CORRELATOR_12m_2QUADRANT', 'CORRELATOR_12m_4QUADRANT')),
	CONSTRAINT CorrHWCKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE CorrQuadrant (
	CorrQuadrantId NUMBER (10) NOT NULL,
	CorrHWConfigId NUMBER (10) NOT NULL,
	BaseElementId NUMBER (10) NOT NULL,
	CorrName VARCHAR2 (128) NOT NULL,
	Quadrant NUMBER (3) NOT NULL,
	ChannelNumber NUMBER (3) NOT NULL,
	NumberOfAntennas NUMBER (3) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	NumberOfRacks NUMBER (3) NOT NULL,
	NumberOfBins NUMBER (3) NOT NULL,
	Active CHAR (1) NOT NULL,
	CONSTRAINT CorrQuadrantActive CHECK (Active IN ('0', '1')),
	CONSTRAINT CorrQuadrantAltKey UNIQUE (CorrName, Quadrant, BaseElementId),
	CONSTRAINT CorrHWConfig FOREIGN KEY (BaseElementId) REFERENCES CorrHWConfiguration,
	CONSTRAINT CorrQuadNumber CHECK (Quadrant IN (0, 1, 2, 3)),
	CONSTRAINT CorrQuadrantKey PRIMARY KEY (CorrQuadrantId)
);

CREATE SEQUENCE CorrQuadrant_seq;

CREATE TABLE CorrQuadrantRack (
	CorrQuadrantRackId NUMBER (10) NOT NULL,
	CorrQuadrantId NUMBER (10) NOT NULL,
	RackName VARCHAR2 (128) NOT NULL,
	RackType VARCHAR2 (10) NOT NULL,
	NumberOfBins NUMBER (3) NOT NULL,
	Active CHAR (1) NOT NULL,
	CONSTRAINT CorrQuRActive CHECK (Active IN ('0', '1')),
	CONSTRAINT CorrQuRAltKey UNIQUE (RackName, CorrQuadrantId),
	CONSTRAINT CorrQuad FOREIGN KEY (CorrQuadrantId) REFERENCES CorrQuadrant,
	CONSTRAINT CorrRackType CHECK (RackType IN ('Station', 'Correlator')),
	CONSTRAINT CorrQuRKey PRIMARY KEY (CorrQuadrantRackId)
);

CREATE SEQUENCE CorrQuR_seq;

CREATE TABLE CorrStationBin (
	CorrStationBinId NUMBER (10) NOT NULL,
	CorrQuadrantRackId NUMBER (10) NOT NULL,
	StationBinName VARCHAR2 (128) NOT NULL,
	StationNodeAddr NUMBER (10) NOT NULL,
	NumberOfStationCards NUMBER (5) NOT NULL,
	NumberOfTFBCards NUMBER (5) NOT NULL,
	NumberOfDRXCards NUMBER (5) NOT NULL,
	NumberOfInterfaceCards NUMBER (5) NOT NULL,
	NumberOfPSCards NUMBER (5) NOT NULL,
	Active CHAR (1) NOT NULL,
	CONSTRAINT CorrStBActive CHECK (Active IN ('0', '1')),
	CONSTRAINT CorrStBAltKey UNIQUE (StationBinName, CorrQuadrantRackId),
	CONSTRAINT CorrRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack,
	CONSTRAINT CorrStBKey PRIMARY KEY (CorrStationBinId)
);

CREATE SEQUENCE CorrStB_seq;

CREATE TABLE CorrelatorBin (
	CorrelatorBinId NUMBER (10) NOT NULL,
	CorrQuadrantRackId NUMBER (10) NOT NULL,
	CorrelatorBinName VARCHAR2 (128) NOT NULL,
	LTANodeAddr NUMBER (10) NOT NULL,
	NumberOfCorrelatorCards NUMBER (5) NOT NULL,
	NumberOfInterfaceCards NUMBER (5) NOT NULL,
	NumberOfPSCards NUMBER (5) NOT NULL,
	Active CHAR (1) NOT NULL,
	CONSTRAINT CorrelBActive CHECK (Active IN ('0', '1')),
	CONSTRAINT CorrelBAltKey UNIQUE (CorrelatorBinName, CorrQuadrantRackId),
	CONSTRAINT CorrStationRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack,
	CONSTRAINT CorrelBKey PRIMARY KEY (CorrelatorBinId)
);

CREATE SEQUENCE CorrelB_seq;

CREATE TABLE FrontEnd (
	BaseElementId NUMBER (10) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	CONSTRAINT FrontEndBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT FrontEndComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT FrontEndKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE WeatherStation (
	BaseElementId NUMBER (10) NOT NULL,
	SerialNumber VARCHAR2 (128) NOT NULL,
	WeatherStationType VARCHAR2 (128) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	XPosition BINARY_DOUBLE NOT NULL,
	YPosition BINARY_DOUBLE NOT NULL,
	ZPosition BINARY_DOUBLE NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	CONSTRAINT WeatherStationComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT WeatherStationBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT WeatheSKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE CentralRack (
	BaseElementId NUMBER (10) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	CONSTRAINT CentralRackComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT CentralRackBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT CentralRackKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE MasterClock (
	BaseElementId NUMBER (10) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	CONSTRAINT MasterClockComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT MasterClockBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT MasterClockKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE HolographyTower (
	BaseElementId NUMBER (10) NOT NULL,
	CommissionDate NUMBER (19) NOT NULL,
	XPosition BINARY_DOUBLE NOT NULL,
	YPosition BINARY_DOUBLE NOT NULL,
	ZPosition BINARY_DOUBLE NOT NULL,
	CONSTRAINT HolographyTowerBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT HologrTKey PRIMARY KEY (BaseElementId)
);


CREATE TABLE Array (
	ArrayId NUMBER (10) NOT NULL,
	BaseElementId NUMBER (10) NOT NULL,
	Type VARCHAR2 (9) NOT NULL,
	UserId VARCHAR2 (256) NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	NormalTermination CHAR (1) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	CONSTRAINT ArrayNormalT CHECK (NormalTermination IN ('0', '1')),
	CONSTRAINT ArrayAltKey UNIQUE (StartTime, BaseElementId),
	CONSTRAINT ArrayComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT ArrayBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT ArrayType CHECK (Type IN ('automatic', 'manual')),
	CONSTRAINT ArrayKey PRIMARY KEY (ArrayId)
);

CREATE SEQUENCE Array_seq;

CREATE TABLE SBExecution (
	ArrayId NUMBER (10) NOT NULL,
	SbUID VARCHAR2 (256) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	NormalTermination CHAR (1) NOT NULL,
	CONSTRAINT SBExecutionNormalT CHECK (NormalTermination IN ('0', '1')),
	CONSTRAINT SBExecutionArrayId FOREIGN KEY (ArrayId) REFERENCES Array,
	CONSTRAINT SBExecutionKey PRIMARY KEY (ArrayId, SbUID, StartTime)
);


CREATE TABLE AntennaToPad (
	AntennaId NUMBER (10) NOT NULL,
	PadId NUMBER (10) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	Planned CHAR (1) NOT NULL,
	MountMetrologyAN0Coeff BINARY_DOUBLE NULL,
	MountMetrologyAW0Coeff BINARY_DOUBLE NULL,
	CONSTRAINT AntennaToPadPlanned CHECK (Planned IN ('0', '1')),
	CONSTRAINT AntennaToPadAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToPadPadId FOREIGN KEY (PadId) REFERENCES Pad,
	CONSTRAINT AntennaToPadKey PRIMARY KEY (AntennaId, PadId, StartTime)
);


CREATE TABLE AntennaPointingModel (
	PointingModelId NUMBER (10) NOT NULL,
	AntennaId NUMBER (10) NOT NULL,
	PadId NUMBER (10) NOT NULL,
	ReceiverBand VARCHAR2 (128) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	StartValidTime NUMBER (19) NOT NULL,
	EndValidTime NUMBER (19) NULL,
	AsdmUID VARCHAR2 (256) NOT NULL,
	CONSTRAINT AntennPMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime),
	CONSTRAINT AntennaPMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad,
	CONSTRAINT AntennaPMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10')),
	CONSTRAINT AntennPMKey PRIMARY KEY (PointingModelId)
);

CREATE SEQUENCE AntennPM_seq;

CREATE TABLE AntennaPointingModelTerm (
	PointingModelId NUMBER (10) NOT NULL,
	CoeffName VARCHAR2 (128) NOT NULL,
	CoeffValue BINARY_FLOAT NOT NULL,
	CoeffError BINARY_FLOAT NOT NULL,
	CONSTRAINT AntPMTermPointingModelId FOREIGN KEY (PointingModelId) REFERENCES AntennaPointingModel,
	CONSTRAINT AntennPMTKey PRIMARY KEY (PointingModelId, CoeffName)
);


CREATE TABLE AntennaFocusModel (
	FocusModelId NUMBER (10) NOT NULL,
	AntennaId NUMBER (10) NOT NULL,
	ReceiverBand VARCHAR2 (128) NOT NULL,
	StartValidTime NUMBER (19) NOT NULL,
	EndValidTime NUMBER (19) NULL,
	AsdmUID VARCHAR2 (256) NOT NULL,
	CONSTRAINT AntennFMAltKey UNIQUE (AntennaId, ReceiverBand, StartValidTime),
	CONSTRAINT AntennaFPMAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaFMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10')),
	CONSTRAINT AntennFMKey PRIMARY KEY (FocusModelId)
);

CREATE SEQUENCE AntennFM_seq;

CREATE TABLE AntennaFocusModelTerm (
	FocusModelId NUMBER (10) NOT NULL,
	CoeffName VARCHAR2 (128) NOT NULL,
	CoeffValue BINARY_FLOAT NOT NULL,
	CoeffError BINARY_FLOAT NOT NULL,
	CONSTRAINT AntFMTermFocusModelId FOREIGN KEY (FocusModelId) REFERENCES AntennaFocusModel,
	CONSTRAINT AntennFMTKey PRIMARY KEY (FocusModelId, CoeffName)
);


CREATE TABLE AntennaDelayModel (
	DelayModelId NUMBER (10) NOT NULL,
	AntennaId NUMBER (10) NOT NULL,
	PadId NUMBER (10) NOT NULL,
	ReceiverBand VARCHAR2 (128) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	StartValidTime NUMBER (19) NOT NULL,
	EndValidTime NUMBER (19) NULL,
	AsdmUID VARCHAR2 (256) NOT NULL,
	CONSTRAINT AntennDMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime),
	CONSTRAINT AntennaDMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad,
	CONSTRAINT AntennDMKey PRIMARY KEY (DelayModelId)
);

CREATE SEQUENCE AntennDM_seq;

CREATE TABLE AntennaDelayModelTerm (
	DelayModelId NUMBER (10) NOT NULL,
	CoeffName VARCHAR2 (128) NOT NULL,
	CoeffValue BINARY_DOUBLE NOT NULL,
	CoeffError BINARY_DOUBLE NOT NULL,
	CONSTRAINT DelayTermDelayModelId FOREIGN KEY (DelayModelId) REFERENCES AntennaDelayModel,
	CONSTRAINT AntennDMTKey PRIMARY KEY (DelayModelId, CoeffName)
);


CREATE TABLE AntennaToFrontEnd (
	AntennaId NUMBER (10) NOT NULL,
	FrontEndId NUMBER (10) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	CONSTRAINT AntennaToFEAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToFEFrontEndId FOREIGN KEY (FrontEndId) REFERENCES FrontEnd,
	CONSTRAINT AntennTFEKey PRIMARY KEY (AntennaId, FrontEndId, StartTime)
);


CREATE TABLE AntennaToArray (
	AntennaId NUMBER (10) NOT NULL,
	ArrayId NUMBER (10) NOT NULL,
	CONSTRAINT AntennaToArrayAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToArrayArrayid FOREIGN KEY (ArrayId) REFERENCES Array,
	CONSTRAINT AntennTAKey PRIMARY KEY (AntennaId, ArrayId)
);


CREATE TABLE AntennaToCorr (
	AntennaId NUMBER (10) NOT NULL,
	CorrId NUMBER (10) NOT NULL,
	AntennaNumber NUMBER (3) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	CONSTRAINT AntToCorrAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntToCorrId FOREIGN KEY (CorrId) REFERENCES CorrQuadrant,
	CONSTRAINT AntennTCKey PRIMARY KEY (AntennaId, CorrId, StartTime)
);


CREATE TABLE WeatherStationToPad (
	WeatherStationId NUMBER (10) NOT NULL,
	PadId NUMBER (10) NOT NULL,
	StartTime NUMBER (19) NOT NULL,
	EndTime NUMBER (19) NULL,
	Planned CHAR (1) NOT NULL,
	CONSTRAINT WeatheSTPPlanned CHECK (Planned IN ('0', '1')),
	CONSTRAINT WSToPadWeatherStationId FOREIGN KEY (WeatherStationId) REFERENCES WeatherStation,
	CONSTRAINT WSToPadPadId FOREIGN KEY (PadId) REFERENCES Pad,
	CONSTRAINT WeatheSTPKey PRIMARY KEY (WeatherStationId, PadId, StartTime)
);


CREATE TABLE BaseElementAssemblyList (
	AssemblyId NUMBER (10) NOT NULL,
	BaseElementOnlineId NUMBER (10) NOT NULL,
	GroupName VARCHAR2 (128) NULL,
	OrderTag NUMBER (5) NULL,
	ComponentId NUMBER (10) NOT NULL,
	RoleName VARCHAR2 (128) NULL,
	ChannelNumber NUMBER (3) NULL,
	NodeAddress VARCHAR2 (16) NULL,
	BaseAddress VARCHAR2 (16) NULL,
	CONSTRAINT BEAssemblyListId FOREIGN KEY (BaseElementOnlineId) REFERENCES BaseElementOnline,
	CONSTRAINT BEAssemblyListAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
	CONSTRAINT BEAssemblyListComponentId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT BaseElALKey PRIMARY KEY (AssemblyId, BaseElementOnlineId)
);


CREATE TABLE BaseElementStartup (
	BaseElementStartupId NUMBER (10) NOT NULL,
	BaseElementId NUMBER (10) NULL,
	StartupId NUMBER (10) NULL,
	BaseElementType VARCHAR (24) NOT NULL,
	Parent NUMBER (10) NULL,
	IsGeneric VARCHAR (5) NOT NULL,
	CONSTRAINT BaseElSAltKey UNIQUE (StartupId, BaseElementId, Parent, BaseElementType),
	CONSTRAINT BEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
	CONSTRAINT BEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT BEStartupParent FOREIGN KEY (Parent) REFERENCES BaseElementStartup,
	CONSTRAINT BEStartupBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array', 'PhotonicReference1', 'PhotonicReference2', 'PhotonicReference3', 'PhotonicReference4', 'PhotonicReference5', 'PhotonicReference6')),
	CONSTRAINT BaseElSKey PRIMARY KEY (BaseElementStartupId)
);

CREATE SEQUENCE BaseElS_seq;

CREATE TABLE AssociatedBaseElement (
	BaseElementId NUMBER (10) NOT NULL,
	StartupId NUMBER (10) NOT NULL,
	AssociatedId NUMBER (10) NOT NULL,
	AssociationType VARCHAR2 (24) NOT NULL,
	CONSTRAINT ABEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT ABEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
	CONSTRAINT ABEAssociated FOREIGN KEY (AssociatedId) REFERENCES BaseElement,
	CONSTRAINT ABEAssociationType CHECK (AssociationType IN ('AntennaToPad', 'AntennaToFrontEnd', 'AntennaToCorr')),
	CONSTRAINT AssociBEKey PRIMARY KEY (BaseElementId, StartupId, AssociatedId)
);


CREATE TABLE AssemblyStartup (
	AssemblyStartupId NUMBER (10) NOT NULL,
	RoleName VARCHAR2 (128) NOT NULL,
	ComponentId NUMBER (10) NOT NULL,
	BaseElementStartupId NUMBER (10) NOT NULL,
	CONSTRAINT AssembSAltKey UNIQUE (BaseElementStartupId, RoleName),
	CONSTRAINT AssemblyStartupComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT AssemblyStartupRole FOREIGN KEY (RoleName) REFERENCES AssemblyRole,
	CONSTRAINT AssemblyStartupBEStartup FOREIGN KEY (BaseElementStartupId) REFERENCES BaseElementStartup,
	CONSTRAINT AssembSKey PRIMARY KEY (AssemblyStartupId)
);

CREATE SEQUENCE AssembS_seq;

CREATE TABLE SystemCounters (
	ConfigurationId NUMBER (10) NOT NULL,
	UpdateTime NUMBER (19) NOT NULL,
	AutoArrayCount NUMBER (5) NOT NULL,
	ManArrayCount NUMBER (5) NOT NULL,
	DataCaptureCount NUMBER (5) NOT NULL,
	CONSTRAINT SystemCountersConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT SystemCKey PRIMARY KEY (ConfigurationId)
);


CREATE TABLE DefaultCanAddress (
	ComponentId NUMBER (10) NOT NULL,
	IsEthernet CHAR (1) NOT NULL,
	NodeAddress VARCHAR (16) NULL,
	ChannelNumber NUMBER (3) NULL,
	Hostname VARCHAR (80) NULL,
	Port NUMBER (10) NULL,
	MacAddress VARCHAR (80) NULL,
	Retries NUMBER (5) NULL,
	TimeOutRxTx BINARY_DOUBLE NULL,
	LingerTime NUMBER (10) NULL,
	CONSTRAINT DefaulCAIsEthernet CHECK (IsEthernet IN ('0', '1')),
	CONSTRAINT DefCanAddComp FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT DefaulCAKey PRIMARY KEY (ComponentId)
);


 


