-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE TMCDBVersion (
	DBName LONGVARCHAR NOT NULL,
	DBVersion LONGVARCHAR NOT NULL,
	DBDate LONGVARCHAR NOT NULL,
	CONSTRAINT TMCDBVersionKey PRIMARY KEY (DBName)
);
CREATE TABLE AcsService (
	AcsServiceId INTEGER IDENTITY,
	ConfigurationId INTEGER NOT NULL,
	ServiceType LONGVARCHAR NOT NULL,
	ServiceInstanceName VARCHAR (256) NULL,
	ComputerId INTEGER NOT NULL,
	CONSTRAINT AcsServiceConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT AcsServiceComputer FOREIGN KEY (ComputerId) REFERENCES Computer,
	CONSTRAINT AcsServiceServiceType CHECK (ServiceType IN ('NAMING', 'IFR', 'CDB', 'NOTIFICATION', 'LOGGING', 'MANAGER', 'ALARM', 'LOGPROXY'))
);
CREATE TABLE MasterComponent (
	MasterComponentId INTEGER IDENTITY,
	ComponentId INTEGER NOT NULL,
	SubsystemName VARCHAR (256) NOT NULL,
	CONSTRAINT MComponentId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT MasterCAltKey UNIQUE (ComponentId)
);
CREATE TABLE NetworkDeviceSnmpConfig (
	NetworkDeviceId INTEGER NOT NULL,
	SnmpXmlClob LONGVARCHAR NOT NULL,
	PropagateNA BOOLEAN DEFAULT FALSE,
	AcsAlarm LONGVARCHAR DEFAULT 'NEVER',
	SnmpCommunity VARCHAR (256) NULL,
	Netgroup VARCHAR (256) NULL,
	CONSTRAINT NetDevSnmpConfigNetDev FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT NetDevSnmpConfigAcsAlarm CHECK (AcsAlarm IN ('NEVER', 'ALWAYS', 'ALLOWSUPPRESSION')),
	CONSTRAINT NetworDSCKey PRIMARY KEY (NetworkDeviceId)
);
CREATE TABLE SnmpTrapSink (
	ConfigurationId INTEGER NOT NULL,
	TrapSinkComputerId INTEGER NOT NULL,
	TrapPort INTEGER NOT NULL,
	TrapSourcesNetworkMask VARCHAR (256) NOT NULL,
	SnmpTrapCommunity VARCHAR (256) NULL,
	CONSTRAINT SnmpTrapSinkConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT SnmpTrapSinkComputer FOREIGN KEY (TrapSinkComputerId) REFERENCES Computer,
	CONSTRAINT SnmpTrapSinkKey PRIMARY KEY (ConfigurationId)
);
CREATE TABLE NetworkPowerstrip (
	NetworkDeviceId INTEGER,
	CONSTRAINT NetworPKey PRIMARY KEY (NetworkDeviceId),
	CONSTRAINT NetworPNetworDFKey FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice
);
CREATE TABLE PowerstripSocket (
	PowerstripSocketId INTEGER IDENTITY,
	NetworkPowerstripId INTEGER NOT NULL,
	SocketNumber INTEGER NOT NULL,
	PoweredNetworkDeviceId INTEGER NULL,
	SocketName VARCHAR (256) NULL,
	CONSTRAINT PwrstripSockNetPowerstrip FOREIGN KEY (NetworkPowerstripId) REFERENCES NetworkPowerstrip,
	CONSTRAINT PwrstripSockNetDevice FOREIGN KEY (PoweredNetworkDeviceId) REFERENCES NetworkDevice,
	CONSTRAINT PowersSAltKey UNIQUE (NetworkPowerstripId, SocketNumber)
);
 



INSERT INTO TMCDBVersion VALUES ( 'TMCDB', '2.1.13', '2009-10-17T0022:30:10.0' );

COMMIT;
