-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE ComponentType (
	ComponentTypeId INTEGER IDENTITY,
	IDL VARCHAR (256) NOT NULL,
	URN LONGVARCHAR NULL,
	CONSTRAINT ComponTAltKey UNIQUE (IDL)
);
CREATE TABLE Configuration (
	ConfigurationId INTEGER IDENTITY,
	ConfigurationName VARCHAR (128) NOT NULL,
	FullName VARCHAR (256) NOT NULL,
	Active BOOLEAN NOT NULL,
	CreationTime TIMESTAMP (6) NOT NULL,
	Description LONGVARCHAR NOT NULL,
	CONSTRAINT ConfigAltKey UNIQUE (ConfigurationName)
);
CREATE TABLE Schemas (
	SchemaId INTEGER IDENTITY,
	URN LONGVARCHAR NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	Schema LONGVARCHAR NULL,
	CONSTRAINT SchemasConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT SchemasAltKey UNIQUE (URN, ConfigurationId)
);
CREATE TABLE NetworkDevice (
	NetworkDeviceId INTEGER IDENTITY,
	NetworkName VARCHAR (256) NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	PhysicalLocation VARCHAR (256) NULL,
	Name VARCHAR (256) NULL,
	CONSTRAINT NetworkDeviceConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT NetworDAltKey UNIQUE (NetworkName, ConfigurationId)
);
CREATE TABLE Computer (
	NetworkDeviceId INTEGER,
	ProcessorType CHAR (3) NOT NULL,
	RealTime BOOLEAN NOT NULL,
	Diskless BOOLEAN NOT NULL,
	CONSTRAINT ChildComputerProcessorType CHECK (ProcessorType IN ('uni', 'smp')),
	CONSTRAINT ComputerKey PRIMARY KEY (NetworkDeviceId),
	CONSTRAINT ComputerNetworDFKey FOREIGN KEY (NetworkDeviceId) REFERENCES NetworkDevice
);
CREATE TABLE LoggingConfig (
	LoggingConfigId INTEGER IDENTITY,
	MinLogLevelDefault TINYINT DEFAULT 2,
	MinLogLevelLocalDefault TINYINT DEFAULT 2,
	CentralizedLogger LONGVARCHAR DEFAULT 'Log',
	DispatchPacketSize TINYINT DEFAULT 10,
	ImmediateDispatchLevel TINYINT DEFAULT 10,
	FlushPeriodSeconds TINYINT DEFAULT 10,
	MaxLogQueueSize INTEGER DEFAULT 1000
);
CREATE TABLE NamedLoggerConfig (
	NamedLoggerConfigId INTEGER IDENTITY,
	LoggingConfigId INTEGER NOT NULL,
	Name LONGVARCHAR NOT NULL,
	MinLogLevel TINYINT DEFAULT 2,
	MinLogLevelLocal TINYINT DEFAULT 2,
	CONSTRAINT NamedLoggerConfigLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT NamedLCAltKey UNIQUE (LoggingConfigId, Name)
);
CREATE TABLE Manager (
	ManagerId INTEGER IDENTITY,
	ConfigurationId INTEGER NOT NULL,
	LoggingConfigId INTEGER NOT NULL,
	Startup LONGVARCHAR NULL,
	ServiceComponents LONGVARCHAR NULL,
	Timeout INTEGER DEFAULT 50,
	ClientPingInterval INTEGER DEFAULT 60,
	AdministratorPingInterval INTEGER DEFAULT 45,
	ContainerPingInterval INTEGER DEFAULT 30,
	ServerThreads TINYINT DEFAULT 10,
	DeadlockTimeout INTEGER DEFAULT 180,
	CONSTRAINT ManagerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT ManagerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ManagerAltKey UNIQUE (ConfigurationId, LoggingConfigId, Startup, ServiceComponents, Timeout, ClientPingInterval, AdministratorPingInterval, ContainerPingInterval, ServerThreads, DeadlockTimeout)
);
CREATE TABLE Container (
	ContainerId INTEGER IDENTITY,
	ContainerName VARCHAR (256) NOT NULL,
	Path VARCHAR (256) NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	LoggingConfigId INTEGER NOT NULL,
	ImplLang LONGVARCHAR NOT NULL,
	RealTime BOOLEAN DEFAULT FALSE,
	RealTimeType LONGVARCHAR DEFAULT 'NONE',
	KernelModuleLocation LONGVARCHAR NULL,
	KernelModule LONGVARCHAR NULL,
	ComputerId INTEGER NULL,
	TypeModifiers LONGVARCHAR NULL,
	StartOnDemand BOOLEAN DEFAULT FALSE,
	KeepAliveTime INTEGER DEFAULT -1,
	ServerThreads INTEGER DEFAULT 5,
	ManagerRetry INTEGER DEFAULT 10,
	CallTimeout INTEGER DEFAULT 30,
	PingInterval INTEGER NULL,
	Recovery BOOLEAN DEFAULT TRUE,
	AutoloadSharedLibs LONGVARCHAR NULL,
	CONSTRAINT ContainerConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ContainerLoggingConfig FOREIGN KEY (LoggingConfigId) REFERENCES LoggingConfig,
	CONSTRAINT ContainerComputer FOREIGN KEY (ComputerId) REFERENCES Computer,
	CONSTRAINT ContainerImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT ContainerRealTimeType CHECK (RealTimeType IN ('NONE', 'ABM', 'CORR')),
	CONSTRAINT ContainerAltKey UNIQUE (ContainerName, Path, ConfigurationId)
);
CREATE TABLE ContainerStartupOption (
	ContStartOptId INTEGER IDENTITY,
	ContainerId INTEGER NOT NULL,
	OptionType LONGVARCHAR NOT NULL,
	OptionName VARCHAR (256) NOT NULL,
	OptionValue VARCHAR (256) NOT NULL,
	CONSTRAINT ContStartOptContainer FOREIGN KEY (ContainerId) REFERENCES Container,
	CONSTRAINT ContStartOptType CHECK (OptionType IN ('ENV_VAR', 'EXEC_ARG', 'EXEC_ARG_LANG', 'CONT_ARG'))
);
CREATE TABLE Component (
	ComponentId INTEGER IDENTITY,
	ComponentTypeId INTEGER NOT NULL,
	ComponentName VARCHAR (256) NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	ContainerId INTEGER NULL,
	ImplLang LONGVARCHAR NOT NULL,
	RealTime BOOLEAN NOT NULL,
	Code VARCHAR (256) NOT NULL,
	Path VARCHAR (256) NOT NULL,
	IsAutostart BOOLEAN NOT NULL,
	IsDefault BOOLEAN NOT NULL,
	IsStandaloneDefined BOOLEAN NULL,
	IsControl BOOLEAN NOT NULL,
	KeepAliveTime INTEGER NOT NULL,
	MinLogLevel TINYINT DEFAULT -1,
	MinLogLevelLocal TINYINT DEFAULT -1,
	XMLDoc LONGVARCHAR NULL,
	CONSTRAINT ComponentIDL FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT ComponentContainer FOREIGN KEY (ContainerId) REFERENCES Container,
	CONSTRAINT ComponentConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT ComponentAltKey UNIQUE (Path, ComponentName, ConfigurationId)
);
CREATE TABLE BACIProperty (
	BACIPropertyId INTEGER IDENTITY,
	ComponentId INTEGER NOT NULL,
	PropertyName VARCHAR (128) NOT NULL,
	description LONGVARCHAR NOT NULL,
	isSequence BOOLEAN NOT NULL,
	format LONGVARCHAR NOT NULL,
	units LONGVARCHAR NOT NULL,
	resolution LONGVARCHAR NOT NULL,
	archive_priority INTEGER NOT NULL,
	archive_min_int DOUBLE NOT NULL,
	archive_max_int DOUBLE NOT NULL,
	default_timer_trig DOUBLE NOT NULL,
	min_timer_trig DOUBLE NOT NULL,
	initialize_devio BOOLEAN NOT NULL,
	min_delta_trig DOUBLE NULL,
	default_value LONGVARCHAR NOT NULL,
	graph_min DOUBLE NULL,
	graph_max DOUBLE NULL,
	min_step DOUBLE NULL,
	archive_delta DOUBLE NOT NULL,
	alarm_high_on DOUBLE NULL,
	alarm_low_on DOUBLE NULL,
	alarm_high_off DOUBLE NULL,
	alarm_low_off DOUBLE NULL,
	alarm_timer_trig DOUBLE NULL,
	min_value DOUBLE NULL,
	max_value DOUBLE NULL,
	bitDescription LONGVARCHAR NULL,
	whenSet LONGVARCHAR NULL,
	whenCleared LONGVARCHAR NULL,
	statesDescription LONGVARCHAR NULL,
	condition LONGVARCHAR NULL,
	alarm_on LONGVARCHAR NULL,
	alarm_off LONGVARCHAR NULL,
	alarm_fault_family LONGVARCHAR NULL,
	alarm_fault_member LONGVARCHAR NULL,
	alarm_level INTEGER NULL,
	Data LONGVARCHAR NULL,
	CONSTRAINT BACIPropertyCompId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT BACIPropertyAltKey UNIQUE (PropertyName, ComponentId)
);
CREATE TABLE Location (
	LocationId INTEGER IDENTITY,
	Building VARCHAR (256) NULL,
	Floor VARCHAR (128) NULL,
	Room VARCHAR (256) NULL,
	Mnemonic VARCHAR (256) NULL,
	LocationPosition VARCHAR (256) NULL,
	CONSTRAINT LocationAltKey UNIQUE (Building, Floor, Room, Mnemonic, LocationPosition)
);
CREATE TABLE Contact (
	ContactId INTEGER IDENTITY,
	ContactName VARCHAR (256) NOT NULL,
	Email VARCHAR (256) NULL,
	Gsm VARCHAR (256) NULL,
	CONSTRAINT ContactAltKey UNIQUE (ContactName)
);
CREATE TABLE AlarmCategory (
	AlarmCategoryId INTEGER IDENTITY,
	AlarmCategoryName VARCHAR (128) NOT NULL,
	Description LONGVARCHAR NOT NULL,
	Path VARCHAR (256) NOT NULL,
	IsDefault BOOLEAN NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	CONSTRAINT AlarmCategoryConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT AlarmCAltKey UNIQUE (AlarmCategoryName, ConfigurationId)
);
CREATE TABLE FaultFamily (
	FaultFamilyId INTEGER IDENTITY,
	FamilyName VARCHAR (256) NOT NULL,
	AlarmSource VARCHAR (256) DEFAULT 'ALARM_SYSTEM_SOURCES',
	HelpURL VARCHAR (256) NULL,
	ContactId INTEGER NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	CONSTRAINT FaultFamilyContact FOREIGN KEY (ContactId) REFERENCES Contact,
	CONSTRAINT FaultFamilyConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT FaultFamilyAltKey UNIQUE (FamilyName, ConfigurationId)
);
CREATE TABLE AlarmCategoryFamily (
	AlarmCategoryId INTEGER NOT NULL,
	FaultFamilyId INTEGER NOT NULL,
	CONSTRAINT ACFCategoryId FOREIGN KEY (AlarmCategoryId) REFERENCES AlarmCategory,
	CONSTRAINT ACFFamilyId FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT AlarmCFKey PRIMARY KEY (AlarmCategoryId, FaultFamilyId)
);
CREATE TABLE FaultMember (
	FaultMemberId INTEGER IDENTITY,
	MemberName VARCHAR (256) NOT NULL,
	FaultFamilyId INTEGER NOT NULL,
	LocationId INTEGER NULL,
	CONSTRAINT FaultMemFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT FaultMemLocationRef FOREIGN KEY (LocationId) REFERENCES Location,
	CONSTRAINT FaultMemberAltKey UNIQUE (MemberName, FaultFamilyId)
);
CREATE TABLE DefaultMember (
	DefaultMemberId INTEGER IDENTITY,
	FaultFamilyId INTEGER NOT NULL,
	LocationID INTEGER NULL,
	CONSTRAINT DefaultMemberFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT DefaultMemberLocationRef FOREIGN KEY (LocationID) REFERENCES Location,
	CONSTRAINT DefaulMAltKey UNIQUE (FaultFamilyId)
);
CREATE TABLE FaultCode (
	FaultCodeId INTEGER IDENTITY,
	FaultFamilyId INTEGER NOT NULL,
	CodeValue INTEGER NOT NULL,
	Priority INTEGER NOT NULL,
	Cause VARCHAR (256) NULL,
	Action LONGVARCHAR NULL,
	Consequence LONGVARCHAR NULL,
	ProblemDescription LONGVARCHAR NOT NULL,
	IsInstant BOOLEAN NOT NULL,
	CONSTRAINT CodeFaultFamilyRef FOREIGN KEY (FaultFamilyId) REFERENCES FaultFamily,
	CONSTRAINT PriorityValue CHECK (Priority IN (0, 1, 2, 3)),
	CONSTRAINT FaultCodeAltKey UNIQUE (FaultFamilyId, CodeValue)
);
CREATE TABLE AlarmDefinition (
	AlarmDefinitionId INTEGER IDENTITY,
	FaultMemberId INTEGER NOT NULL,
	FaultCodeId INTEGER NOT NULL,
	CONSTRAINT AlarmDefMmemberRef FOREIGN KEY (FaultMemberId) REFERENCES FaultMember,
	CONSTRAINT AlarmDefCodeRef FOREIGN KEY (FaultCodeId) REFERENCES FaultCode,
	CONSTRAINT AlarmDAltKey UNIQUE (FaultMemberId, FaultCodeId)
);
CREATE TABLE ReductionLink (
	ParentAlarmDefId INTEGER NOT NULL,
	ChildAlarmDefId INTEGER NOT NULL,
	Type LONGVARCHAR NOT NULL,
	Action LONGVARCHAR NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	CONSTRAINT RLParentRef FOREIGN KEY (ParentAlarmDefId) REFERENCES AlarmDefinition,
	CONSTRAINT RLChildRef FOREIGN KEY (ChildAlarmDefId) REFERENCES AlarmDefinition,
	CONSTRAINT ReductionLinkConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ReductionLinkType CHECK (Type IN ('MULTIPLICITY', 'NODE')),
	CONSTRAINT ReductionLinkAction CHECK (Action IN ('CREATE', 'REMOVE')),
	CONSTRAINT ReductLKey PRIMARY KEY (ParentAlarmDefId, ChildAlarmDefId)
);
CREATE TABLE ReductionThreshold (
	AlarmDefinitionId INTEGER NOT NULL,
	Value INTEGER NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	CONSTRAINT RTAlarmRef FOREIGN KEY (AlarmDefinitionId) REFERENCES AlarmDefinition,
	CONSTRAINT RTConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT ReductTKey PRIMARY KEY (AlarmDefinitionId)
);
CREATE TABLE EventChannel (
	EventChannelId INTEGER IDENTITY,
	ConfigurationId INTEGER NOT NULL,
	Name VARCHAR (256) NOT NULL,
	Path VARCHAR (256) NOT NULL,
	IntegrationLogs BOOLEAN DEFAULT FALSE,
	MaxQueueLength INTEGER DEFAULT 0,
	MaxConsumers INTEGER DEFAULT 0,
	MaxSuppliers INTEGER DEFAULT 0,
	RejectNewEvents BOOLEAN DEFAULT TRUE,
	DiscardPolicy LONGVARCHAR DEFAULT 'AnyOrder',
	EventReliability LONGVARCHAR DEFAULT 'BestEffort',
	ConnectionReliability LONGVARCHAR DEFAULT 'BestEffort',
	Priority SMALLINT DEFAULT 0,
	Timeout INTEGER DEFAULT 0,
	OrderPolicy LONGVARCHAR DEFAULT 'AnyOrder',
	StartTimeSupported BOOLEAN DEFAULT FALSE,
	StopTimeSupported BOOLEAN DEFAULT FALSE,
	MaxEventsPerConsumer INTEGER DEFAULT 0,
	CONSTRAINT EventChannelConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT EventChannelDiscardPolicy CHECK (DiscardPolicy IN ('AnyOrder', 'FifoOrder', 'LifoOrder', 'PriorityOrder', 'DeadlineOrder')),
	CONSTRAINT EventChannelOrderPolicy CHECK (OrderPolicy IN ('AnyOrder', 'FifoOrder', 'LifoOrder', 'PriorityOrder', 'DeadlineOrder')),
	CONSTRAINT EventChannelEventReliability CHECK (EventReliability IN ('BestEffort', 'Persistent')),
	CONSTRAINT EventChannelConReliability CHECK (ConnectionReliability IN ('BestEffort', 'Persistent')),
	CONSTRAINT EventChannelAltKey UNIQUE (Name, Path, ConfigurationId)
);
CREATE TABLE Event (
	EventId INTEGER IDENTITY,
	EventChannelId INTEGER NOT NULL,
	Name VARCHAR (256) NOT NULL,
	MaxProcessTime DOUBLE DEFAULT '2.0',
	CONSTRAINT EventEventChannelRef FOREIGN KEY (EventChannelId) REFERENCES EventChannel,
	CONSTRAINT EventAltKey UNIQUE (EventChannelId, Name)
);
CREATE TABLE NotificationServiceMapping (
	NotificationServiceMappingId INTEGER IDENTITY,
	ConfigurationId INTEGER NOT NULL,
	DefaultNotificationService VARCHAR (256) NOT NULL,
	CONSTRAINT NotServMapConfig FOREIGN KEY (ConfigurationId) REFERENCES Configuration,
	CONSTRAINT NotifiSMAltKey UNIQUE (ConfigurationId)
);
CREATE TABLE DomainsMapping (
	DomainsMappingId INTEGER IDENTITY,
	Name VARCHAR (256) NOT NULL,
	NotificationService VARCHAR (256) NOT NULL,
	NotificationServiceMappingId INTEGER NOT NULL,
	CONSTRAINT DomainsNotServMapRef FOREIGN KEY (NotificationServiceMappingId) REFERENCES NotificationServiceMapping,
	CONSTRAINT DomainMAltKey UNIQUE (NotificationServiceMappingId, Name)
);
CREATE TABLE ChannelMapping (
	ChannelMappingId INTEGER IDENTITY,
	Name VARCHAR (256) NOT NULL,
	NotificationService VARCHAR (256) NOT NULL,
	NotificationServiceMappingId INTEGER NOT NULL,
	CONSTRAINT ChannelNotServMapRef FOREIGN KEY (NotificationServiceMappingId) REFERENCES NotificationServiceMapping,
	CONSTRAINT ChanneMAltKey UNIQUE (NotificationServiceMappingId, Name)
);
 


