-- TMCDB SQL TABLE DEFINITIONS Version 2.1.13 2009-10-17T0022:30:10.0
--
-- /////////////////////////////////////////////////////////////////
-- // WARNING!  DO NOT MODIFY THIS FILE!                          //
-- //  ---------------------------------------------------------  //
-- // | This is generated code!  Do not modify this file.       | //
-- // | Any changes will be lost when the file is re-generated. | //
-- //  ---------------------------------------------------------  //
-- /////////////////////////////////////////////////////////////////

CREATE TABLE HWConfiguration (
	ConfigurationId INTEGER IDENTITY,
	SwConfigurationId INTEGER NOT NULL,
	ArrayReferenceX DOUBLE NULL,
	ArrayReferenceY DOUBLE NULL,
	ArrayReferenceZ DOUBLE NULL,
	CONSTRAINT SwConfigId FOREIGN KEY (SwConfigurationId) REFERENCES Configuration,
	CONSTRAINT HWConfAltKey UNIQUE (SwConfigurationId)
);
CREATE TABLE Startup (
	StartupId INTEGER IDENTITY,
	ConfigurationId INTEGER NOT NULL,
	StartupName VARCHAR (256) NOT NULL,
	CONSTRAINT StartupConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT StartupAltKey UNIQUE (StartupName, ConfigurationId)
);
CREATE TABLE LRUType (
	LRUName VARCHAR (128) NOT NULL,
	FullName VARCHAR (256) NOT NULL,
	ICD VARCHAR (256) NOT NULL,
	ICDDate BIGINT NOT NULL,
	Description LONGVARCHAR NOT NULL,
	Notes LONGVARCHAR NULL,
	CONSTRAINT LRUTypeKey PRIMARY KEY (LRUName)
);
CREATE TABLE HwSchemas (
	SchemaId INTEGER IDENTITY,
	URN LONGVARCHAR NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	Schema LONGVARCHAR NULL,
	CONSTRAINT AssemblySchemasConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT HwSchemasAltKey UNIQUE (URN, ConfigurationId)
);
CREATE TABLE AssemblyType (
	AssemblyTypeName VARCHAR (256) NOT NULL,
	BaseElementType LONGVARCHAR NOT NULL,
	LRUName VARCHAR (128) NOT NULL,
	FullName VARCHAR (256) NOT NULL,
	Description LONGVARCHAR NOT NULL,
	Notes LONGVARCHAR NULL,
	ComponentTypeId INTEGER NOT NULL,
	SchemaId INTEGER NULL,
	CONSTRAINT AssemblyTypeLRUName FOREIGN KEY (LRUName) REFERENCES LRUType,
	CONSTRAINT AssemblyTypeHwSchema FOREIGN KEY (SchemaId) REFERENCES HwSchemas,
	CONSTRAINT AssemblyTypeCompType FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT AssemblyTypeBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array')),
	CONSTRAINT AssemblyTypeKey PRIMARY KEY (AssemblyTypeName)
);
CREATE TABLE DefaultComponent (
	DefaultComponentId INTEGER NOT NULL,
	ComponentTypeId INTEGER NOT NULL,
	AssemblyTypeName VARCHAR (256) NOT NULL,
	ImplLang LONGVARCHAR NOT NULL,
	RealTime BOOLEAN NOT NULL,
	Code VARCHAR (256) NOT NULL,
	Path VARCHAR (256) NOT NULL,
	IsAutostart BOOLEAN NOT NULL,
	IsDefault BOOLEAN NOT NULL,
	IsStandaloneDefined BOOLEAN NULL,
	KeepAliveTime INTEGER NOT NULL,
	MinLogLevel TINYINT DEFAULT -1,
	MinLogLevelLocal TINYINT DEFAULT -1,
	XMLDoc LONGVARCHAR NULL,
	CONSTRAINT DefaultComponentTypeId FOREIGN KEY (ComponentTypeId) REFERENCES ComponentType,
	CONSTRAINT DefaultComponentAssemblyId FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT DefaultComponentImplLang CHECK (ImplLang IN ('java', 'cpp', 'py')),
	CONSTRAINT DefaulCKey PRIMARY KEY (DefaultComponentId)
);
CREATE TABLE DefaultBaciProperty (
	DefaultBaciPropId INTEGER NOT NULL,
	DefaultComponentId INTEGER NOT NULL,
	PropertyName VARCHAR (128) NOT NULL,
	description LONGVARCHAR NOT NULL,
	format LONGVARCHAR NOT NULL,
	units LONGVARCHAR NOT NULL,
	resolution LONGVARCHAR NOT NULL,
	archive_priority INTEGER NOT NULL,
	archive_min_int DOUBLE NOT NULL,
	archive_max_int DOUBLE NOT NULL,
	default_timer_trig DOUBLE NOT NULL,
	min_timer_trig DOUBLE NOT NULL,
	initialize_devio BOOLEAN NOT NULL,
	min_delta_trig DOUBLE NULL,
	default_value LONGVARCHAR NOT NULL,
	graph_min DOUBLE NULL,
	graph_max DOUBLE NULL,
	min_step DOUBLE NULL,
	archive_delta DOUBLE NOT NULL,
	alarm_high_on DOUBLE NULL,
	alarm_low_on DOUBLE NULL,
	alarm_high_off DOUBLE NULL,
	alarm_low_off DOUBLE NULL,
	alarm_timer_trig DOUBLE NULL,
	min_value DOUBLE NULL,
	max_value DOUBLE NULL,
	bitDescription LONGVARCHAR NULL,
	whenSet LONGVARCHAR NULL,
	whenCleared LONGVARCHAR NULL,
	statesDescription LONGVARCHAR NULL,
	condition LONGVARCHAR NULL,
	alarm_on LONGVARCHAR NULL,
	alarm_off LONGVARCHAR NULL,
	Data LONGVARCHAR NULL,
	CONSTRAINT DefBACIDefaultComponentTypeId FOREIGN KEY (DefaultComponentId) REFERENCES DefaultComponent,
	CONSTRAINT DefaulBPKey PRIMARY KEY (DefaultBaciPropId)
);
CREATE TABLE DefaultMonitorPoint (
	DefaultMonitorPointId INTEGER NOT NULL,
	DefaultBACIPropertyId INTEGER NOT NULL,
	MonitorPointName VARCHAR (128) NOT NULL,
	Indice INTEGER NOT NULL,
	DataType LONGVARCHAR NOT NULL,
	RCA LONGVARCHAR NOT NULL,
	TeRelated BOOLEAN NOT NULL,
	RawDataType LONGVARCHAR NOT NULL,
	WorldDataType LONGVARCHAR NOT NULL,
	Units LONGVARCHAR NULL,
	Scale DOUBLE NULL,
	Offset DOUBLE NULL,
	MinRange LONGVARCHAR NULL,
	MaxRange LONGVARCHAR NULL,
	Description LONGVARCHAR NOT NULL,
	CONSTRAINT DefaulPntId FOREIGN KEY (DefaultBACIPropertyId) REFERENCES DefaultBaciProperty,
	CONSTRAINT DefaulMPKey PRIMARY KEY (DefaultMonitorPointId)
);
CREATE TABLE Assembly (
	AssemblyId INTEGER IDENTITY,
	AssemblyTypeName VARCHAR (256) NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	SerialNumber VARCHAR (256) NOT NULL,
	Data LONGVARCHAR NULL,
	CONSTRAINT AssemblyConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT AssemblyName FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT AssemblyAltKey UNIQUE (SerialNumber, ConfigurationId)
);
CREATE TABLE AssemblyRole (
	RoleName VARCHAR (128) NOT NULL,
	AssemblyTypeName VARCHAR (256) NOT NULL,
	CONSTRAINT AssemblyRoleAssembly FOREIGN KEY (AssemblyTypeName) REFERENCES AssemblyType,
	CONSTRAINT AssemblyRoleKey PRIMARY KEY (RoleName)
);
CREATE TABLE MonitorPoint (
	MonitorPointId INTEGER IDENTITY,
	BACIPropertyId INTEGER NOT NULL,
	MonitorPointName VARCHAR (128) NOT NULL,
	AssemblyId INTEGER NOT NULL,
	Indice INTEGER NOT NULL,
	DataType LONGVARCHAR NOT NULL,
	RCA LONGVARCHAR NOT NULL,
	TeRelated BOOLEAN NOT NULL,
	RawDataType LONGVARCHAR NOT NULL,
	WorldDataType LONGVARCHAR NOT NULL,
	Units LONGVARCHAR NULL,
	Scale DOUBLE NULL,
	Offset DOUBLE NULL,
	MinRange LONGVARCHAR NULL,
	MaxRange LONGVARCHAR NULL,
	Description LONGVARCHAR NOT NULL,
	CONSTRAINT MonitorPointAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
	CONSTRAINT MonitorPointBACIPropertyId FOREIGN KEY (BACIPropertyId) REFERENCES BACIProperty,
	CONSTRAINT MonitorPointDatatype CHECK (DataType IN ('float', 'double', 'boolean', 'string', 'integer', 'enum', 'clob')),
	CONSTRAINT MonitorPointAltKey UNIQUE (BACIPropertyId, AssemblyId, Indice)
);
CREATE TABLE MonitorData (
	MonitorPointId INTEGER NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NOT NULL,
	MonitorTS TIMESTAMP (6) NOT NULL,
	SampleSize INTEGER NOT NULL,
	MonitorClob LONGVARCHAR NOT NULL,
	MinStat DOUBLE NULL,
	MaxStat DOUBLE NULL,
	MeanStat DOUBLE NULL,
	StdDevStat DOUBLE NULL,
	CONSTRAINT MonitorDataMonitorPointId FOREIGN KEY (MonitorPointId) REFERENCES MonitorPoint,
	CONSTRAINT MonitorDataKey PRIMARY KEY (MonitorPointId, MonitorTS)
);
CREATE TABLE BaseElement (
	BaseElementId INTEGER IDENTITY,
	BaseType LONGVARCHAR NOT NULL,
	BaseElementName LONGVARCHAR NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	CONSTRAINT BEConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT BEType CHECK (BaseType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array')),
	CONSTRAINT BaseElementAltKey UNIQUE (BaseElementName, ConfigurationId)
);
CREATE TABLE BaseElementOnline (
	BaseElementOnlineId INTEGER IDENTITY,
	BaseElementId INTEGER NOT NULL,
	ConfigurationId INTEGER NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	NormalTermination BOOLEAN NOT NULL,
	CONSTRAINT BEOnlineId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT BEOnlineConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT BaseElOAltKey UNIQUE (BaseElementId, ConfigurationId, StartTime)
);
CREATE TABLE Antenna (
	BaseElementId INTEGER NOT NULL,
	AntennaName VARCHAR (128) NULL,
	AntennaType LONGVARCHAR NOT NULL,
	DishDiameter DOUBLE NOT NULL,
	CommissionDate BIGINT NOT NULL,
	XPosition DOUBLE NOT NULL,
	YPosition DOUBLE NOT NULL,
	ZPosition DOUBLE NOT NULL,
	XOffset DOUBLE NOT NULL,
	YOffset DOUBLE NOT NULL,
	ZOffset DOUBLE NOT NULL,
	ComponentId INTEGER NOT NULL,
	AvgDelay DOUBLE NULL,
	CONSTRAINT AntennaBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT AntennaComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT AntennaType CHECK (AntennaType IN ('VA', 'AEC', 'ACA')),
	CONSTRAINT AntennaKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE Pad (
	BaseElementId INTEGER NOT NULL,
	PadName VARCHAR (128) NULL,
	CommissionDate BIGINT NOT NULL,
	XPosition DOUBLE NOT NULL,
	YPosition DOUBLE NOT NULL,
	ZPosition DOUBLE NOT NULL,
	AvgDelay DOUBLE NULL,
	CONSTRAINT PadBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT PadKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE CorrHWConfiguration (
	BaseElementId INTEGER NOT NULL,
	CorrHWName VARCHAR (128) NOT NULL,
	CorrHWType LONGVARCHAR NOT NULL,
	CONSTRAINT CorrHWBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT CorrelatorHWType CHECK (CorrHWType IN ('CORRELATOR_12m_2ANTS', 'CORRELATOR_12m_1QUADRANT', 'CORRELATOR_12m_2QUADRANT', 'CORRELATOR_12m_4QUADRANT')),
	CONSTRAINT CorrHWCKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE CorrQuadrant (
	CorrQuadrantId INTEGER IDENTITY,
	CorrHWConfigId INTEGER NOT NULL,
	BaseElementId INTEGER NOT NULL,
	CorrName VARCHAR (128) NOT NULL,
	Quadrant TINYINT NOT NULL,
	ChannelNumber TINYINT NOT NULL,
	NumberOfAntennas TINYINT NOT NULL,
	CommissionDate BIGINT NOT NULL,
	ComponentId INTEGER NOT NULL,
	NumberOfRacks TINYINT NOT NULL,
	NumberOfBins TINYINT NOT NULL,
	Active BOOLEAN NOT NULL,
	CONSTRAINT CorrHWConfig FOREIGN KEY (BaseElementId) REFERENCES CorrHWConfiguration,
	CONSTRAINT CorrQuadNumber CHECK (Quadrant IN (0, 1, 2, 3)),
	CONSTRAINT CorrQuadrantAltKey UNIQUE (CorrName, Quadrant, BaseElementId)
);
CREATE TABLE CorrQuadrantRack (
	CorrQuadrantRackId INTEGER IDENTITY,
	CorrQuadrantId INTEGER NOT NULL,
	RackName VARCHAR (128) NOT NULL,
	RackType LONGVARCHAR NOT NULL,
	NumberOfBins TINYINT NOT NULL,
	Active BOOLEAN NOT NULL,
	CONSTRAINT CorrQuad FOREIGN KEY (CorrQuadrantId) REFERENCES CorrQuadrant,
	CONSTRAINT CorrRackType CHECK (RackType IN ('Station', 'Correlator')),
	CONSTRAINT CorrQuRAltKey UNIQUE (RackName, CorrQuadrantId)
);
CREATE TABLE CorrStationBin (
	CorrStationBinId INTEGER IDENTITY,
	CorrQuadrantRackId INTEGER NOT NULL,
	StationBinName VARCHAR (128) NOT NULL,
	StationNodeAddr INTEGER NOT NULL,
	NumberOfStationCards SMALLINT NOT NULL,
	NumberOfTFBCards SMALLINT NOT NULL,
	NumberOfDRXCards SMALLINT NOT NULL,
	NumberOfInterfaceCards SMALLINT NOT NULL,
	NumberOfPSCards SMALLINT NOT NULL,
	Active BOOLEAN NOT NULL,
	CONSTRAINT CorrRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack,
	CONSTRAINT CorrStBAltKey UNIQUE (StationBinName, CorrQuadrantRackId)
);
CREATE TABLE CorrelatorBin (
	CorrelatorBinId INTEGER IDENTITY,
	CorrQuadrantRackId INTEGER NOT NULL,
	CorrelatorBinName VARCHAR (128) NOT NULL,
	LTANodeAddr INTEGER NOT NULL,
	NumberOfCorrelatorCards SMALLINT NOT NULL,
	NumberOfInterfaceCards SMALLINT NOT NULL,
	NumberOfPSCards SMALLINT NOT NULL,
	Active BOOLEAN NOT NULL,
	CONSTRAINT CorrStationRack FOREIGN KEY (CorrQuadrantRackId) REFERENCES CorrQuadrantRack,
	CONSTRAINT CorrelBAltKey UNIQUE (CorrelatorBinName, CorrQuadrantRackId)
);
CREATE TABLE FrontEnd (
	BaseElementId INTEGER NOT NULL,
	CommissionDate BIGINT NOT NULL,
	ComponentId INTEGER NOT NULL,
	CONSTRAINT FrontEndBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT FrontEndComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT FrontEndKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE WeatherStation (
	BaseElementId INTEGER NOT NULL,
	SerialNumber VARCHAR (128) NOT NULL,
	WeatherStationType VARCHAR (128) NOT NULL,
	CommissionDate BIGINT NOT NULL,
	XPosition DOUBLE NOT NULL,
	YPosition DOUBLE NOT NULL,
	ZPosition DOUBLE NOT NULL,
	ComponentId INTEGER NOT NULL,
	CONSTRAINT WeatherStationComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT WeatherStationBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT WeatheSKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE CentralRack (
	BaseElementId INTEGER NOT NULL,
	CommissionDate BIGINT NOT NULL,
	ComponentId INTEGER NOT NULL,
	CONSTRAINT CentralRackComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT CentralRackBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT CentralRackKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE MasterClock (
	BaseElementId INTEGER NOT NULL,
	CommissionDate BIGINT NOT NULL,
	ComponentId INTEGER NOT NULL,
	CONSTRAINT MasterClockComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT MasterClockBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT MasterClockKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE HolographyTower (
	BaseElementId INTEGER NOT NULL,
	CommissionDate BIGINT NOT NULL,
	XPosition DOUBLE NOT NULL,
	YPosition DOUBLE NOT NULL,
	ZPosition DOUBLE NOT NULL,
	CONSTRAINT HolographyTowerBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT HologrTKey PRIMARY KEY (BaseElementId)
);
CREATE TABLE Array (
	ArrayId INTEGER IDENTITY,
	BaseElementId INTEGER NOT NULL,
	Type LONGVARCHAR NOT NULL,
	UserId VARCHAR (256) NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	NormalTermination BOOLEAN NOT NULL,
	ComponentId INTEGER NOT NULL,
	CONSTRAINT ArrayComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT ArrayBEId FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT ArrayType CHECK (Type IN ('automatic', 'manual')),
	CONSTRAINT ArrayAltKey UNIQUE (StartTime, BaseElementId)
);
CREATE TABLE SBExecution (
	ArrayId INTEGER NOT NULL,
	SbUID VARCHAR (256) NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	NormalTermination BOOLEAN NOT NULL,
	CONSTRAINT SBExecutionArrayId FOREIGN KEY (ArrayId) REFERENCES Array,
	CONSTRAINT SBExecutionKey PRIMARY KEY (ArrayId, SbUID, StartTime)
);
CREATE TABLE AntennaToPad (
	AntennaId INTEGER NOT NULL,
	PadId INTEGER NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	Planned BOOLEAN NOT NULL,
	MountMetrologyAN0Coeff DOUBLE NULL,
	MountMetrologyAW0Coeff DOUBLE NULL,
	CONSTRAINT AntennaToPadAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToPadPadId FOREIGN KEY (PadId) REFERENCES Pad,
	CONSTRAINT AntennaToPadKey PRIMARY KEY (AntennaId, PadId, StartTime)
);
CREATE TABLE AntennaPointingModel (
	PointingModelId INTEGER IDENTITY,
	AntennaId INTEGER NOT NULL,
	PadId INTEGER NOT NULL,
	ReceiverBand VARCHAR (128) NOT NULL,
	StartTime BIGINT NOT NULL,
	StartValidTime BIGINT NOT NULL,
	EndValidTime BIGINT NULL,
	AsdmUID VARCHAR (256) NOT NULL,
	CONSTRAINT AntennaPMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad,
	CONSTRAINT AntennaPMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10')),
	CONSTRAINT AntennPMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime)
);
CREATE TABLE AntennaPointingModelTerm (
	PointingModelId INTEGER NOT NULL,
	CoeffName VARCHAR (128) NOT NULL,
	CoeffValue FLOAT NOT NULL,
	CoeffError FLOAT NOT NULL,
	CONSTRAINT AntPMTermPointingModelId FOREIGN KEY (PointingModelId) REFERENCES AntennaPointingModel,
	CONSTRAINT AntennPMTKey PRIMARY KEY (PointingModelId, CoeffName)
);
CREATE TABLE AntennaFocusModel (
	FocusModelId INTEGER IDENTITY,
	AntennaId INTEGER NOT NULL,
	ReceiverBand VARCHAR (128) NOT NULL,
	StartValidTime BIGINT NOT NULL,
	EndValidTime BIGINT NULL,
	AsdmUID VARCHAR (256) NOT NULL,
	CONSTRAINT AntennaFPMAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaFMBand CHECK (ReceiverBand IN ('band1', 'band2', 'band3', 'band4', 'band5', 'band6', 'band7', 'band8', 'band9', 'band10')),
	CONSTRAINT AntennFMAltKey UNIQUE (AntennaId, ReceiverBand, StartValidTime)
);
CREATE TABLE AntennaFocusModelTerm (
	FocusModelId INTEGER NOT NULL,
	CoeffName VARCHAR (128) NOT NULL,
	CoeffValue FLOAT NOT NULL,
	CoeffError FLOAT NOT NULL,
	CONSTRAINT AntFMTermFocusModelId FOREIGN KEY (FocusModelId) REFERENCES AntennaFocusModel,
	CONSTRAINT AntennFMTKey PRIMARY KEY (FocusModelId, CoeffName)
);
CREATE TABLE AntennaDelayModel (
	DelayModelId INTEGER IDENTITY,
	AntennaId INTEGER NOT NULL,
	PadId INTEGER NOT NULL,
	ReceiverBand VARCHAR (128) NOT NULL,
	StartTime BIGINT NOT NULL,
	StartValidTime BIGINT NOT NULL,
	EndValidTime BIGINT NULL,
	AsdmUID VARCHAR (256) NOT NULL,
	CONSTRAINT AntennaDMAntToPad FOREIGN KEY (AntennaId, PadId, StartTime) REFERENCES AntennaToPad,
	CONSTRAINT AntennDMAltKey UNIQUE (AntennaId, PadId, ReceiverBand, StartValidTime)
);
CREATE TABLE AntennaDelayModelTerm (
	DelayModelId INTEGER NOT NULL,
	CoeffName VARCHAR (128) NOT NULL,
	CoeffValue DOUBLE NOT NULL,
	CoeffError DOUBLE NOT NULL,
	CONSTRAINT DelayTermDelayModelId FOREIGN KEY (DelayModelId) REFERENCES AntennaDelayModel,
	CONSTRAINT AntennDMTKey PRIMARY KEY (DelayModelId, CoeffName)
);
CREATE TABLE AntennaToFrontEnd (
	AntennaId INTEGER NOT NULL,
	FrontEndId INTEGER NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	CONSTRAINT AntennaToFEAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToFEFrontEndId FOREIGN KEY (FrontEndId) REFERENCES FrontEnd,
	CONSTRAINT AntennTFEKey PRIMARY KEY (AntennaId, FrontEndId, StartTime)
);
CREATE TABLE AntennaToArray (
	AntennaId INTEGER NOT NULL,
	ArrayId INTEGER NOT NULL,
	CONSTRAINT AntennaToArrayAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntennaToArrayArrayid FOREIGN KEY (ArrayId) REFERENCES Array,
	CONSTRAINT AntennTAKey PRIMARY KEY (AntennaId, ArrayId)
);
CREATE TABLE AntennaToCorr (
	AntennaId INTEGER NOT NULL,
	CorrId INTEGER NOT NULL,
	AntennaNumber TINYINT NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	CONSTRAINT AntToCorrAntennaId FOREIGN KEY (AntennaId) REFERENCES Antenna,
	CONSTRAINT AntToCorrId FOREIGN KEY (CorrId) REFERENCES CorrQuadrant,
	CONSTRAINT AntennTCKey PRIMARY KEY (AntennaId, CorrId, StartTime)
);
CREATE TABLE WeatherStationToPad (
	WeatherStationId INTEGER NOT NULL,
	PadId INTEGER NOT NULL,
	StartTime BIGINT NOT NULL,
	EndTime BIGINT NULL,
	Planned BOOLEAN NOT NULL,
	CONSTRAINT WSToPadWeatherStationId FOREIGN KEY (WeatherStationId) REFERENCES WeatherStation,
	CONSTRAINT WSToPadPadId FOREIGN KEY (PadId) REFERENCES Pad,
	CONSTRAINT WeatheSTPKey PRIMARY KEY (WeatherStationId, PadId, StartTime)
);
CREATE TABLE BaseElementAssemblyList (
	AssemblyId INTEGER NOT NULL,
	BaseElementOnlineId INTEGER NOT NULL,
	GroupName VARCHAR (128) NULL,
	OrderTag SMALLINT NULL,
	ComponentId INTEGER NOT NULL,
	RoleName VARCHAR (128) NULL,
	ChannelNumber TINYINT NULL,
	NodeAddress LONGVARCHAR NULL,
	BaseAddress LONGVARCHAR NULL,
	CONSTRAINT BEAssemblyListId FOREIGN KEY (BaseElementOnlineId) REFERENCES BaseElementOnline,
	CONSTRAINT BEAssemblyListAssemblyId FOREIGN KEY (AssemblyId) REFERENCES Assembly,
	CONSTRAINT BEAssemblyListComponentId FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT BaseElALKey PRIMARY KEY (AssemblyId, BaseElementOnlineId)
);
CREATE TABLE BaseElementStartup (
	BaseElementStartupId INTEGER IDENTITY,
	BaseElementId INTEGER NULL,
	StartupId INTEGER NULL,
	BaseElementType VARCHAR (24) NOT NULL,
	Parent INTEGER NULL,
	IsGeneric VARCHAR (5) NOT NULL,
	CONSTRAINT BEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
	CONSTRAINT BEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT BEStartupParent FOREIGN KEY (Parent) REFERENCES BaseElementStartup,
	CONSTRAINT BEStartupBEType CHECK (BaseElementType IN ('Antenna', 'Pad', 'CorrHWConfiguration', 'FrontEnd', 'WeatherStation', 'CentralRack', 'MasterClock', 'HolographyTower', 'Array', 'PhotonicReference1', 'PhotonicReference2', 'PhotonicReference3', 'PhotonicReference4', 'PhotonicReference5', 'PhotonicReference6')),
	CONSTRAINT BaseElSAltKey UNIQUE (StartupId, BaseElementId, Parent, BaseElementType)
);
CREATE TABLE AssociatedBaseElement (
	BaseElementId INTEGER NOT NULL,
	StartupId INTEGER NOT NULL,
	AssociatedId INTEGER NOT NULL,
	AssociationType LONGVARCHAR NOT NULL,
	CONSTRAINT ABEStartupIdBE FOREIGN KEY (BaseElementId) REFERENCES BaseElement,
	CONSTRAINT ABEStartupId FOREIGN KEY (StartupId) REFERENCES Startup,
	CONSTRAINT ABEAssociated FOREIGN KEY (AssociatedId) REFERENCES BaseElement,
	CONSTRAINT ABEAssociationType CHECK (AssociationType IN ('AntennaToPad', 'AntennaToFrontEnd', 'AntennaToCorr')),
	CONSTRAINT AssociBEKey PRIMARY KEY (BaseElementId, StartupId, AssociatedId)
);
CREATE TABLE AssemblyStartup (
	AssemblyStartupId INTEGER IDENTITY,
	RoleName VARCHAR (128) NOT NULL,
	ComponentId INTEGER NOT NULL,
	BaseElementStartupId INTEGER NOT NULL,
	CONSTRAINT AssemblyStartupComponent FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT AssemblyStartupRole FOREIGN KEY (RoleName) REFERENCES AssemblyRole,
	CONSTRAINT AssemblyStartupBEStartup FOREIGN KEY (BaseElementStartupId) REFERENCES BaseElementStartup,
	CONSTRAINT AssembSAltKey UNIQUE (BaseElementStartupId, RoleName)
);
CREATE TABLE SystemCounters (
	ConfigurationId INTEGER NOT NULL,
	UpdateTime BIGINT NOT NULL,
	AutoArrayCount SMALLINT NOT NULL,
	ManArrayCount SMALLINT NOT NULL,
	DataCaptureCount SMALLINT NOT NULL,
	CONSTRAINT SystemCountersConfig FOREIGN KEY (ConfigurationId) REFERENCES HWConfiguration,
	CONSTRAINT SystemCKey PRIMARY KEY (ConfigurationId)
);
CREATE TABLE DefaultCanAddress (
	ComponentId INTEGER NOT NULL,
	IsEthernet BOOLEAN NOT NULL,
	NodeAddress VARCHAR (16) NULL,
	ChannelNumber TINYINT NULL,
	Hostname VARCHAR (80) NULL,
	Port INTEGER NULL,
	MacAddress VARCHAR (80) NULL,
	Retries SMALLINT NULL,
	TimeOutRxTx DOUBLE NULL,
	LingerTime INTEGER NULL,
	CONSTRAINT DefCanAddComp FOREIGN KEY (ComponentId) REFERENCES Component,
	CONSTRAINT DefaulCAKey PRIMARY KEY (ComponentId)
);
 


