// acs hack BEGIN
package org.jacorb.orb.acs;

import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.poa.POA;

/**
 * ACS patches the JacORB ORB 
 * to enable profiling beyond the features of 
 * <ul>
 *   <li>{@link POA#_addPOAEventListener(org.jacorb.poa.EventListener)}, because ACS offers notification also for rejected requests
 *       that never make it into the RequestQueue,
 *   <li> {@link StatisticsProvider}, because low-level notification happens for GIOP messages, not message fragments.
 * <p>
 * By patching {@link ORB} to implement this interface, the ACS application can test 
 * {@code ORB instanceof AcsProfilingORB} and thus easily hook up its implementation of 
 * {@link AcsORBProfiler}.
 * <p>
 * The purpose of using this interface is to abstract the ACS changes in JacORB code,
 * so that in the future we could implement similar changes in a different Java ORB.
 * However we do not yet follow this idea completely, as it would require us to define this interface
 * outside of JacORB code, and in a package like "acs.corba" to be neutral of JacORB.
 * This is too cumbersome to implement in the ACS/ExtProd/ structure so that we accept 
 * the small porting effort to move this file and change package names when we use a different Java ORB for profiling.
 */
public interface AcsProfilingORB
{
	/**
	 * Registers the {@link AcsORBProfiler} to be used by the ORB and other ORB-related classes.
	 * @param profiler
	 */
	public void registerAcsORBProfiler(AcsORBProfiler profiler);
}
//acs hack END
