#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import maciErrType
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################

class BaseException:
    '''
    Class serves as a base exception for all error type/code exception
    pairs defined within this module. The reason this is provided is so 
    that one can generically catch ACS Error System based Python 
    exceptions using a single Python "except BaseException, e:" type
    statement.
    '''
    pass
######################################################################
class ComponentCreationExImpl(maciErrType.ComponentCreationEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error creating component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.ComponentCreation,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.ComponentCreationEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotGetComponentExImpl(maciErrType.CannotGetComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error retrieving component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotGetComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotGetComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentNotAlreadyActivatedExImpl(maciErrType.ComponentNotAlreadyActivatedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested Component had not been already activated at request time"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.ComponentNotAlreadyActivated,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.ComponentNotAlreadyActivatedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentConfigurationNotFoundExImpl(maciErrType.ComponentConfigurationNotFoundEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The configuration for the requested Component could not be found"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.ComponentConfigurationNotFound,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.ComponentConfigurationNotFoundEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class IncompleteComponentSpecExImpl(maciErrType.IncompleteComponentSpecEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if the resulting structure is not complete."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.IncompleteComponentSpec,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.IncompleteComponentSpecEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setContainerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContainerName", value)
        return
        
    def getContainerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContainerName")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentSpecIncompatibleWithActiveComponentExImpl(maciErrType.ComponentSpecIncompatibleWithActiveComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if the resulting structure is incompatible with a component of the same name already active."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.ComponentSpecIncompatibleWithActiveComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.ComponentSpecIncompatibleWithActiveComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setContainerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContainerName", value)
        return
        
    def getContainerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContainerName")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class InvalidComponentSpecExImpl(maciErrType.InvalidComponentSpecEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if there is no valid dynamic component found for given resulting structure."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.InvalidComponentSpec,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.InvalidComponentSpecEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NoDefaultComponentExImpl(maciErrType.NoDefaultComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if no default component is found."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.NoDefaultComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.NoDefaultComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setIDLType(self, value):
        '''
        Member setter method.
        '''
        self.setData("IDLType", value)
        return
        
    def getIDLType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("IDLType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotGetServiceExImpl(maciErrType.CannotGetServiceEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error retrieving service"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotGetService,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotGetServiceEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotActivateComponentExImpl(maciErrType.CannotActivateComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error activating component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotActivateComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotActivateComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setDetailedReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("DetailedReason", value)
        return
        
    def getDetailedReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("DetailedReason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotDeactivateComponentExImpl(maciErrType.CannotDeactivateComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error deactivating component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotDeactivateComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotDeactivateComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotRestartComponentExImpl(maciErrType.CannotRestartComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error restarting component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotRestartComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotRestartComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotRegisterComponentExImpl(maciErrType.CannotRegisterComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error registering component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotRegisterComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotRegisterComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotUnregisterComponentExImpl(maciErrType.CannotUnregisterComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error unregistering component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotUnregisterComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotUnregisterComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotReleaseComponentExImpl(maciErrType.CannotReleaseComponentEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error releasing component"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.CannotReleaseComponent,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.CannotReleaseComponentEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentNotInUseExImpl(maciErrType.ComponentNotInUseEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Component is not in use"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.ComponentNotInUse,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.ComponentNotInUseEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NoPermissionExImpl(maciErrType.NoPermissionEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "No permission"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.NoPermission,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.NoPermissionEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setID(self, value):
        '''
        Member setter method.
        '''
        self.setData("ID", value)
        return
        
    def getID(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ID")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setProtectedResource(self, value):
        '''
        Member setter method.
        '''
        self.setData("ProtectedResource", value)
        return
        
    def getProtectedResource(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ProtectedResource")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class LoggerDoesNotExistExImpl(maciErrType.LoggerDoesNotExistEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Logger does not exist"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.maciErrType,
                          maciErrType.LoggerDoesNotExist,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        maciErrType.LoggerDoesNotExistEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getmaciErrTypeEx(self):
        '''
        Returns this exception converted into an maciErrTypeEx
        '''
        return maciErrType.maciErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setLoggerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("LoggerName", value)
        return
        
    def getLoggerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("LoggerName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentCreationCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error creating component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.ComponentCreation,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotGetComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error retrieving component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotGetComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentNotAlreadyActivatedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested Component had not been already activated at request time"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.ComponentNotAlreadyActivated,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentConfigurationNotFoundCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The configuration for the requested Component could not be found"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.ComponentConfigurationNotFound,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class IncompleteComponentSpecCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if the resulting structure is not complete."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.IncompleteComponentSpec,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setContainerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContainerName", value)
        return
        
    def getContainerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContainerName")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentSpecIncompatibleWithActiveComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if the resulting structure is incompatible with a component of the same name already active."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.ComponentSpecIncompatibleWithActiveComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setContainerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContainerName", value)
        return
        
    def getContainerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContainerName")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class InvalidComponentSpecCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if there is no valid dynamic component found for given resulting structure."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.InvalidComponentSpec,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NoDefaultComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Thrown if no default component is found."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.NoDefaultComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setIDLType(self, value):
        '''
        Member setter method.
        '''
        self.setData("IDLType", value)
        return
        
    def getIDLType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("IDLType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotGetServiceCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error retrieving service"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotGetService,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotActivateComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error activating component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotActivateComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentCode(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentCode", value)
        return
        
    def getComponentCode(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentCode")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setDetailedReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("DetailedReason", value)
        return
        
    def getDetailedReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("DetailedReason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotDeactivateComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error deactivating component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotDeactivateComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotRestartComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error restarting component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotRestartComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotRegisterComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error registering component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotRegisterComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setComponentType(self, value):
        '''
        Member setter method.
        '''
        self.setData("ComponentType", value)
        return
        
    def getComponentType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ComponentType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotUnregisterComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error unregistering component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotUnregisterComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CannotReleaseComponentCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Error releasing component"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.CannotReleaseComponent,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class ComponentNotInUseCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Component is not in use"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.ComponentNotInUse,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCURL(self, value):
        '''
        Member setter method.
        '''
        self.setData("CURL", value)
        return
        
    def getCURL(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("CURL")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class NoPermissionCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "No permission"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.NoPermission,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setID(self, value):
        '''
        Member setter method.
        '''
        self.setData("ID", value)
        return
        
    def getID(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ID")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setProtectedResource(self, value):
        '''
        Member setter method.
        '''
        self.setData("ProtectedResource", value)
        return
        
    def getProtectedResource(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ProtectedResource")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setReason(self, value):
        '''
        Member setter method.
        '''
        self.setData("Reason", value)
        return
        
    def getReason(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Reason")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class LoggerDoesNotExistCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Logger does not exist"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.maciErrType,
                          maciErrType.LoggerDoesNotExist,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setLoggerName(self, value):
        '''
        Member setter method.
        '''
        self.setData("LoggerName", value)
        return
        
    def getLoggerName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("LoggerName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
if __name__ == "__main__":

    try:
        raise ComponentCreationExImpl
    except maciErrType.ComponentCreationEx, e:
        print "Caught the correct type of exception:", e
        g = ComponentCreationExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotGetComponentExImpl
    except maciErrType.CannotGetComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotGetComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ComponentNotAlreadyActivatedExImpl
    except maciErrType.ComponentNotAlreadyActivatedEx, e:
        print "Caught the correct type of exception:", e
        g = ComponentNotAlreadyActivatedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ComponentConfigurationNotFoundExImpl
    except maciErrType.ComponentConfigurationNotFoundEx, e:
        print "Caught the correct type of exception:", e
        g = ComponentConfigurationNotFoundExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise IncompleteComponentSpecExImpl
    except maciErrType.IncompleteComponentSpecEx, e:
        print "Caught the correct type of exception:", e
        g = IncompleteComponentSpecExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ComponentSpecIncompatibleWithActiveComponentExImpl
    except maciErrType.ComponentSpecIncompatibleWithActiveComponentEx, e:
        print "Caught the correct type of exception:", e
        g = ComponentSpecIncompatibleWithActiveComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise InvalidComponentSpecExImpl
    except maciErrType.InvalidComponentSpecEx, e:
        print "Caught the correct type of exception:", e
        g = InvalidComponentSpecExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise NoDefaultComponentExImpl
    except maciErrType.NoDefaultComponentEx, e:
        print "Caught the correct type of exception:", e
        g = NoDefaultComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotGetServiceExImpl
    except maciErrType.CannotGetServiceEx, e:
        print "Caught the correct type of exception:", e
        g = CannotGetServiceExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotActivateComponentExImpl
    except maciErrType.CannotActivateComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotActivateComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotDeactivateComponentExImpl
    except maciErrType.CannotDeactivateComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotDeactivateComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotRestartComponentExImpl
    except maciErrType.CannotRestartComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotRestartComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotRegisterComponentExImpl
    except maciErrType.CannotRegisterComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotRegisterComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotUnregisterComponentExImpl
    except maciErrType.CannotUnregisterComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotUnregisterComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CannotReleaseComponentExImpl
    except maciErrType.CannotReleaseComponentEx, e:
        print "Caught the correct type of exception:", e
        g = CannotReleaseComponentExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise ComponentNotInUseExImpl
    except maciErrType.ComponentNotInUseEx, e:
        print "Caught the correct type of exception:", e
        g = ComponentNotInUseExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise NoPermissionExImpl
    except maciErrType.NoPermissionEx, e:
        print "Caught the correct type of exception:", e
        g = NoPermissionExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise LoggerDoesNotExistExImpl
    except maciErrType.LoggerDoesNotExistEx, e:
        print "Caught the correct type of exception:", e
        g = LoggerDoesNotExistExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e


    joe = ComponentCreationCompletionImpl()
    joe.Print()


    joe = CannotGetComponentCompletionImpl()
    joe.Print()


    joe = ComponentNotAlreadyActivatedCompletionImpl()
    joe.Print()


    joe = ComponentConfigurationNotFoundCompletionImpl()
    joe.Print()


    joe = IncompleteComponentSpecCompletionImpl()
    joe.Print()


    joe = ComponentSpecIncompatibleWithActiveComponentCompletionImpl()
    joe.Print()


    joe = InvalidComponentSpecCompletionImpl()
    joe.Print()


    joe = NoDefaultComponentCompletionImpl()
    joe.Print()


    joe = CannotGetServiceCompletionImpl()
    joe.Print()


    joe = CannotActivateComponentCompletionImpl()
    joe.Print()


    joe = CannotDeactivateComponentCompletionImpl()
    joe.Print()


    joe = CannotRestartComponentCompletionImpl()
    joe.Print()


    joe = CannotRegisterComponentCompletionImpl()
    joe.Print()


    joe = CannotUnregisterComponentCompletionImpl()
    joe.Print()


    joe = CannotReleaseComponentCompletionImpl()
    joe.Print()


    joe = ComponentNotInUseCompletionImpl()
    joe.Print()


    joe = NoPermissionCompletionImpl()
    joe.Print()


    joe = LoggerDoesNotExistCompletionImpl()
    joe.Print()


    print
