#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import cdbErrType
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################

class BaseException:
    '''
    Class serves as a base exception for all error type/code exception
    pairs defined within this module. The reason this is provided is so 
    that one can generically catch ACS Error System based Python 
    exceptions using a single Python "except BaseException, e:" type
    statement.
    '''
    pass
######################################################################
class CouldntReadCDBExImpl(cdbErrType.CouldntReadCDBEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data couldn't be read"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CouldntReadCDB,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CouldntReadCDBEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())


######################################################################
class CouldntWriteCDBExImpl(cdbErrType.CouldntWriteCDBEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data couldn't be written"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CouldntWriteCDB,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CouldntWriteCDBEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())


######################################################################
class CDBRecordIsReadOnlyExImpl(cdbErrType.CDBRecordIsReadOnlyEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record is readonly"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordIsReadOnly,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBRecordIsReadOnlyEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBFieldIsReadOnlyExImpl(cdbErrType.CDBFieldIsReadOnlyEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB field is readonly"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBFieldIsReadOnly,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBFieldIsReadOnlyEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setFieldName(self, value):
        '''
        Member setter method.
        '''
        self.setData("FieldName", value)
        return
        
    def getFieldName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("FieldName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBReadoOnlyDataExImpl(cdbErrType.CDBReadoOnlyDataEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data are readonly"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBReadoOnlyData,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBReadoOnlyDataEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())


######################################################################
class WrongCDBDataTypeExImpl(cdbErrType.WrongCDBDataTypeEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Wrong CDB data type"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.WrongCDBDataType,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.WrongCDBDataTypeEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setValue(self, value):
        '''
        Member setter method.
        '''
        self.setData("Value", value)
        return
        
    def getValue(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Value")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setDataType(self, value):
        '''
        Member setter method.
        '''
        self.setData("DataType", value)
        return
        
    def getDataType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("DataType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBRecordAlreadyExistsExImpl(cdbErrType.CDBRecordAlreadyExistsEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record already exists"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordAlreadyExists,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBRecordAlreadyExistsEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBExceptionExImpl(cdbErrType.CDBExceptionEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Unknow exception"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBException,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBExceptionEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())


######################################################################
class CDBFieldDoesNotExistExImpl(cdbErrType.CDBFieldDoesNotExistEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB field does not exist"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBFieldDoesNotExist,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBFieldDoesNotExistEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setFieldName(self, value):
        '''
        Member setter method.
        '''
        self.setData("FieldName", value)
        return
        
    def getFieldName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("FieldName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBRecordDoesNotExistExImpl(cdbErrType.CDBRecordDoesNotExistEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record does not exist"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordDoesNotExist,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBRecordDoesNotExistEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBXMLErrorExImpl(cdbErrType.CDBXMLErrorEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB XML error"
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.cdbErrType,
                          cdbErrType.CDBXMLError,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        cdbErrType.CDBXMLErrorEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getcdbErrTypeEx(self):
        '''
        Returns this exception converted into an cdbErrTypeEx
        '''
        return cdbErrType.cdbErrTypeEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setFilename(self, value):
        '''
        Member setter method.
        '''
        self.setData("Filename", value)
        return
        
    def getFilename(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Filename")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setNodename(self, value):
        '''
        Member setter method.
        '''
        self.setData("Nodename", value)
        return
        
    def getNodename(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Nodename")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setErrorString(self, value):
        '''
        Member setter method.
        '''
        self.setData("ErrorString", value)
        return
        
    def getErrorString(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ErrorString")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CouldntReadCDBCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data couldn't be read"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CouldntReadCDB,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class CouldntWriteCDBCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data couldn't be written"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CouldntWriteCDB,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class CDBRecordIsReadOnlyCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record is readonly"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordIsReadOnly,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBFieldIsReadOnlyCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB field is readonly"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBFieldIsReadOnly,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setFieldName(self, value):
        '''
        Member setter method.
        '''
        self.setData("FieldName", value)
        return
        
    def getFieldName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("FieldName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBReadoOnlyDataCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB data are readonly"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBReadoOnlyData,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class WrongCDBDataTypeCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Wrong CDB data type"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.WrongCDBDataType,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setValue(self, value):
        '''
        Member setter method.
        '''
        self.setData("Value", value)
        return
        
    def getValue(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Value")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setDataType(self, value):
        '''
        Member setter method.
        '''
        self.setData("DataType", value)
        return
        
    def getDataType(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("DataType")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBRecordAlreadyExistsCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record already exists"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordAlreadyExists,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBExceptionCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Unknow exception"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBException,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return


######################################################################
class CDBFieldDoesNotExistCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB field does not exist"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBFieldDoesNotExist,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setFieldName(self, value):
        '''
        Member setter method.
        '''
        self.setData("FieldName", value)
        return
        
    def getFieldName(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("FieldName")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBRecordDoesNotExistCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB record does not exist"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBRecordDoesNotExist,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class CDBXMLErrorCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "CDB XML error"
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.cdbErrType,
                          cdbErrType.CDBXMLError,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setFilename(self, value):
        '''
        Member setter method.
        '''
        self.setData("Filename", value)
        return
        
    def getFilename(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Filename")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setCurl(self, value):
        '''
        Member setter method.
        '''
        self.setData("Curl", value)
        return
        
    def getCurl(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Curl")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setNodename(self, value):
        '''
        Member setter method.
        '''
        self.setData("Nodename", value)
        return
        
    def getNodename(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Nodename")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setErrorString(self, value):
        '''
        Member setter method.
        '''
        self.setData("ErrorString", value)
        return
        
    def getErrorString(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ErrorString")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
if __name__ == "__main__":

    try:
        raise CouldntReadCDBExImpl
    except cdbErrType.CouldntReadCDBEx, e:
        print "Caught the correct type of exception:", e
        g = CouldntReadCDBExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CouldntWriteCDBExImpl
    except cdbErrType.CouldntWriteCDBEx, e:
        print "Caught the correct type of exception:", e
        g = CouldntWriteCDBExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBRecordIsReadOnlyExImpl
    except cdbErrType.CDBRecordIsReadOnlyEx, e:
        print "Caught the correct type of exception:", e
        g = CDBRecordIsReadOnlyExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBFieldIsReadOnlyExImpl
    except cdbErrType.CDBFieldIsReadOnlyEx, e:
        print "Caught the correct type of exception:", e
        g = CDBFieldIsReadOnlyExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBReadoOnlyDataExImpl
    except cdbErrType.CDBReadoOnlyDataEx, e:
        print "Caught the correct type of exception:", e
        g = CDBReadoOnlyDataExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise WrongCDBDataTypeExImpl
    except cdbErrType.WrongCDBDataTypeEx, e:
        print "Caught the correct type of exception:", e
        g = WrongCDBDataTypeExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBRecordAlreadyExistsExImpl
    except cdbErrType.CDBRecordAlreadyExistsEx, e:
        print "Caught the correct type of exception:", e
        g = CDBRecordAlreadyExistsExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBExceptionExImpl
    except cdbErrType.CDBExceptionEx, e:
        print "Caught the correct type of exception:", e
        g = CDBExceptionExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBFieldDoesNotExistExImpl
    except cdbErrType.CDBFieldDoesNotExistEx, e:
        print "Caught the correct type of exception:", e
        g = CDBFieldDoesNotExistExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBRecordDoesNotExistExImpl
    except cdbErrType.CDBRecordDoesNotExistEx, e:
        print "Caught the correct type of exception:", e
        g = CDBRecordDoesNotExistExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise CDBXMLErrorExImpl
    except cdbErrType.CDBXMLErrorEx, e:
        print "Caught the correct type of exception:", e
        g = CDBXMLErrorExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e


    joe = CouldntReadCDBCompletionImpl()
    joe.Print()


    joe = CouldntWriteCDBCompletionImpl()
    joe.Print()


    joe = CDBRecordIsReadOnlyCompletionImpl()
    joe.Print()


    joe = CDBFieldIsReadOnlyCompletionImpl()
    joe.Print()


    joe = CDBReadoOnlyDataCompletionImpl()
    joe.Print()


    joe = WrongCDBDataTypeCompletionImpl()
    joe.Print()


    joe = CDBRecordAlreadyExistsCompletionImpl()
    joe.Print()


    joe = CDBExceptionCompletionImpl()
    joe.Print()


    joe = CDBFieldDoesNotExistCompletionImpl()
    joe.Print()


    joe = CDBRecordDoesNotExistCompletionImpl()
    joe.Print()


    joe = CDBXMLErrorCompletionImpl()
    joe.Print()


    print
