#!/usr/bin/env python
# @(#) $Id: AES2Py.xslt,v 1.21 2009/02/18 00:36:46 agrimstrup Exp $
#
#    ALMA - Atacama Large Millimiter Array
#    (c) Associated Universities, Inc. Washington DC, USA,  2001
#    (c) European Southern Observatory, 2002
#    Copyright by ESO (in the framework of the ALMA collaboration)
#    and Cosylab 2002, All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from   Acspy.Common.Err import ACSError
import ACSErr
import ArchiveIdentifierError
from Acspy.Common.TimeHelper import getTimeStamp
######################################################################

class BaseException:
    '''
    Class serves as a base exception for all error type/code exception
    pairs defined within this module. The reason this is provided is so 
    that one can generically catch ACS Error System based Python 
    exceptions using a single Python "except BaseException, e:" type
    statement.
    '''
    pass
######################################################################
class IdentifierUnexpectedExImpl(ArchiveIdentifierError.IdentifierUnexpectedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "An unexpected error occured in the identifier archive or UID-related classes."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.IdentifierUnexpected,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.IdentifierUnexpectedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setContextInfo(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContextInfo", value)
        return
        
    def getContextInfo(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContextInfo")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class IdentifierUnavailableExImpl(ArchiveIdentifierError.IdentifierUnavailableEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The identifier archive is not available."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.IdentifierUnavailable,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.IdentifierUnavailableEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setContextInfo(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContextInfo", value)
        return
        
    def getContextInfo(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContextInfo")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class UidAlreadyExistsExImpl(ArchiveIdentifierError.UidAlreadyExistsEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Cannot replace an existing UID."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.UidAlreadyExists,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.UidAlreadyExistsEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setObjectDesc(self, value):
        '''
        Member setter method.
        '''
        self.setData("ObjectDesc", value)
        return
        
    def getObjectDesc(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ObjectDesc")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setUid(self, value):
        '''
        Member setter method.
        '''
        self.setData("Uid", value)
        return
        
    def getUid(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Uid")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeUnavailableExImpl(ArchiveIdentifierError.RangeUnavailableEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "UID range not available."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeUnavailable,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.RangeUnavailableEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeLockedExImpl(ArchiveIdentifierError.RangeLockedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested operation cannot be performed with a locked range of UIDs."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeLocked,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.RangeLockedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeUnlockedExImpl(ArchiveIdentifierError.RangeUnlockedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested operation cannot be performed with an unlocked range of UIDs."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeUnlocked,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.RangeUnlockedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeExhaustedExImpl(ArchiveIdentifierError.RangeExhaustedEx, ACSError, BaseException):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from the CORBA class of 
        similar name. The difference between the two is that this class
        provides many additional helper methods from Acspy.Common.Err.

        There are three different combinations of keyword parameter
        uses that make sense here:

            __init__()
              Using the default values creates a new exception which 
              does not include any previous error traces
            
            __init__(exception=someOldException)
              Specifying a previous ACS Error System exception or 
              without changing the value of create 
              creates a new exception which does in fact include 
              previous error traces from someOldException.

            __init__(exception=someOldException, create=0)
              Used to reconstruct someOldException without adding any
              new error trace information. It is absolutely critical
              that someOldException be of the same CORBA type as this
              class implements!

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              exception is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the exception. Only used when
        create has a value of 1/True
        - exception is an ACS Error System based CORBA exception
        Provide this to extract previous error trace 
        information and put this into the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this exception
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out what went wrong
        most likely you want create to have a value of 0. However, if you
        intend on rethrowing the exception a value of 1 makes more sense.
        - severity is used to set the severity of exception. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "No more UIDs can be extracted from the Range."
        description = self.shortDescription
        ACSError.__init__(self,  
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeExhausted,
                          exception,
                          description,
                          nvSeq,                          
                          create,
                          severity)
        ArchiveIdentifierError.RangeExhaustedEx.__init__(self, self.errorTrace)
        return
    #--------------------------------------------------------------------------        
    def getArchiveIdentifierErrorEx(self):
        '''
        Returns this exception converted into an ArchiveIdentifierErrorEx
        '''
        return ArchiveIdentifierError.ArchiveIdentifierErrorEx(self.getErrorTrace())

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setRangeMaxDocumentId(self, value):
        '''
        Member setter method.
        '''
        self.setData("RangeMaxDocumentId", value)
        return
        
    def getRangeMaxDocumentId(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("RangeMaxDocumentId")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class IdentifierUnexpectedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "An unexpected error occured in the identifier archive or UID-related classes."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.IdentifierUnexpected,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setContextInfo(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContextInfo", value)
        return
        
    def getContextInfo(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContextInfo")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class IdentifierUnavailableCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The identifier archive is not available."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.IdentifierUnavailable,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setContextInfo(self, value):
        '''
        Member setter method.
        '''
        self.setData("ContextInfo", value)
        return
        
    def getContextInfo(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ContextInfo")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class UidAlreadyExistsCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "Cannot replace an existing UID."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.UidAlreadyExists,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setObjectDesc(self, value):
        '''
        Member setter method.
        '''
        self.setData("ObjectDesc", value)
        return
        
    def getObjectDesc(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("ObjectDesc")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setUid(self, value):
        '''
        Member setter method.
        '''
        self.setData("Uid", value)
        return
        
    def getUid(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Uid")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeUnavailableCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "UID range not available."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeUnavailable,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeLockedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested operation cannot be performed with a locked range of UIDs."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeLocked,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeUnlockedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "The requested operation cannot be performed with an unlocked range of UIDs."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeUnlocked,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
class RangeExhaustedCompletionImpl(ACSErr.Completion, ACSError):
    '''
    Some form of custom documentation goes here...
    '''
    #-----------------------------------------------------------------
    def __init__(self,
                 nvSeq = None,
                 exception = None,
                 create = 1,
                 severity = None):
        '''
        Constructor
        
        An instance of this class is derived from ACSErr.Completion. 
        It provides many helper methods from Acspy.Common.Err.
        
        There are three different combinations of keyword parameter
        uses that make sense here:
            
            __init__()
              Using the default values creates a new Completion which 
              does not include any previous error traces
            
            __init__(exception=acsException)
              Specifying a previous ACS Error System exception without
              changing the value of create creates a new Completion which
              does in fact include previous error traces from
              acsException.
            
            __init__(exception=acsException, create=0)
              Used to reconstruct acsException without adding any
              new error trace information.

            nvSeq default keyword parameter
              This sequence of name/values is only used when a new 
              Completion is being created. In simple terms, the only
              time you can use it is when the create keyword parameter
              has the value of 1

            severity default keyword parameter
              This CORBA type corresponds to ACSErr.Severity. The
              only time you can use it is when the create keyword parameter
              has the value of 1

        Parameters:
        - nvSeq is a sequence of ACSErr.NameValue pairs used to add
        additional information about the Completion. Only used when
        create has a value of 1
        - exception is an ACS Error System based CORBA exception. 
	Provide this to extract previous error trace information and put this into
        the new object being constructed
        - create is a boolean value which defines whether or not traceback
        information should be extracted from the call to create this Completion
        and added to it's error trace. If you're simply trying to recreate
        a remote CORBA exception locally and figure out 
        what went wrong most likely you want create to have a value of 0. 
        However, if you intend on returning the Completion a value of 1 makes 
        more sense.
        - severity is used to set the severity of the completion. Only used when
        create has a value of 1/True
        '''
        if nvSeq == None:
            nvSeq = []
        self.shortDescription = "No more UIDs can be extracted from the Range."
        description = self.shortDescription
        ACSError.__init__(self,
                          ACSErr.ArchiveIdentifierError,
                          ArchiveIdentifierError.RangeExhausted,
                          exception,
                          description,
                          nvSeq,
                          create,
                          severity)

        #Create the CORBA object
        ACSErr.Completion.__init__(self,
                                   self.getTimeStamp(),
                                   self.getErrorType(),
                                   self.getErrorCode(),
                                   [self.errorTrace])
        return

    
    #--------------------------------------------------------------------------
    def setRange(self, value):
        '''
        Member setter method.
        '''
        self.setData("Range", value)
        return
        
    def getRange(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("Range")[0]
        ret_val = str(ret_val)
        return ret_val

    
    #--------------------------------------------------------------------------
    def setRangeMaxDocumentId(self, value):
        '''
        Member setter method.
        '''
        self.setData("RangeMaxDocumentId", value)
        return
        
    def getRangeMaxDocumentId(self):
        '''
        Member getter method.
        '''
        ret_val = self.getData("RangeMaxDocumentId")[0]
        ret_val = str(ret_val)
        return ret_val


######################################################################
if __name__ == "__main__":

    try:
        raise IdentifierUnexpectedExImpl
    except ArchiveIdentifierError.IdentifierUnexpectedEx, e:
        print "Caught the correct type of exception:", e
        g = IdentifierUnexpectedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise IdentifierUnavailableExImpl
    except ArchiveIdentifierError.IdentifierUnavailableEx, e:
        print "Caught the correct type of exception:", e
        g = IdentifierUnavailableExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise UidAlreadyExistsExImpl
    except ArchiveIdentifierError.UidAlreadyExistsEx, e:
        print "Caught the correct type of exception:", e
        g = UidAlreadyExistsExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RangeUnavailableExImpl
    except ArchiveIdentifierError.RangeUnavailableEx, e:
        print "Caught the correct type of exception:", e
        g = RangeUnavailableExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RangeLockedExImpl
    except ArchiveIdentifierError.RangeLockedEx, e:
        print "Caught the correct type of exception:", e
        g = RangeLockedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RangeUnlockedExImpl
    except ArchiveIdentifierError.RangeUnlockedEx, e:
        print "Caught the correct type of exception:", e
        g = RangeUnlockedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e

    try:
        raise RangeExhaustedExImpl
    except ArchiveIdentifierError.RangeExhaustedEx, e:
        print "Caught the correct type of exception:", e
        g = RangeExhaustedExImpl(exception=e)
        g.Print()
    except Exception, e:
        print "Caught the wrong type of exception:", e


    joe = IdentifierUnexpectedCompletionImpl()
    joe.Print()


    joe = IdentifierUnavailableCompletionImpl()
    joe.Print()


    joe = UidAlreadyExistsCompletionImpl()
    joe.Print()


    joe = RangeUnavailableCompletionImpl()
    joe.Print()


    joe = RangeLockedCompletionImpl()
    joe.Print()


    joe = RangeUnlockedCompletionImpl()
    joe.Print()


    joe = RangeExhaustedCompletionImpl()
    joe.Print()


    print
