#! /usr/bin/env python
#*******************************************************************************
# ALMA - Atacama Large Millimiter Array
# (c) Associated Universities Inc., 2007
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#
# "@(#) $Id: LTS2Py.xslt,v 1.3 2007/07/12 11:29:53 nbarriga Exp $"
#
# who       when      what
# --------  --------  ----------------------------------------------
# nbarriga  2007-01-29  created
#
######################################################################
'''
Some form of custom documentation goes here...
'''
######################################################################
from Acspy.Common.Log import getLogger
import ACSLog
from socket import gethostname
from Acspy.Common.TimeHelper import TimeUtil
import time
from os import getpid
from traceback import extract_stack
######################################################################
class LOG_NC_ChannelCreated_ATTEMPT:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_ChannelCreated_ATTEMPT"
		self.audience="Developer"
		self.shortDescription="About to create a notification channel"
                self.priority=ACSLog.ACS_LOG_TRACE
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_ChannelCreated_OK:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_ChannelCreated_OK"
		self.audience="Developer"
		self.shortDescription="Successfully created a notification channel"
                self.priority=ACSLog.ACS_LOG_INFO
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setChannelId(self, value):
		try:
			self._members["ChannelId"]=str(value)
		except KeyError, e:
			self._members["ChannelId"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_ChannelDestroyed_OK:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_ChannelDestroyed_OK"
		self.audience="Developer"
		self.shortDescription="Successfully destroyed a notification channel"
                self.priority=ACSLog.ACS_LOG_INFO
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_SubscriptionConnect_OK:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_SubscriptionConnect_OK"
		self.audience="Developer"
		self.shortDescription="Successfully connected to a notification channel"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_SubscriptionConnect_FAIL:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_SubscriptionConnect_FAIL"
		self.audience="Developer"
		self.shortDescription="Failed connecting to a notification channel"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_SubscriptionDisconnect_OK:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_SubscriptionDisconnect_OK"
		self.audience="Developer"
		self.shortDescription="Disconnected from a notification channel"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_SubscriptionDisconnect_FAIL:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_SubscriptionDisconnect_FAIL"
		self.audience="Developer"
		self.shortDescription="Failed to disconnect from a notification channel"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

class LOG_NC_ProcessingTimeExceeded:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_ProcessingTimeExceeded"
		self.audience="Developer"
		self.shortDescription="Took too long to process an event"
                self.priority=ACSLog.ACS_LOG_WARNING
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

	def setEventName(self, value):
		try:
			self._members["EventName"]=str(value)
		except KeyError, e:
			self._members["EventName"].update(str(value))

	def setLogOcurrencesNumber(self, value):
		try:
			self._members["LogOcurrencesNumber"]=str(value)
		except KeyError, e:
			self._members["LogOcurrencesNumber"].update(str(value))

class LOG_NC_ProcessingWithoutHandler:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_ProcessingWithoutHandler"
		self.audience="Developer"
		self.shortDescription="Event processed without handler"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

	def setEventName(self, value):
		try:
			self._members["EventName"]=str(value)
		except KeyError, e:
			self._members["EventName"].update(str(value))

class LOG_NC_EventReceive_OK:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_EventReceive_OK"
		self.audience="Developer"
		self.shortDescription="Event successfully received, ready to be processed"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

	def setEventName(self, value):
		try:
			self._members["EventName"]=str(value)
		except KeyError, e:
			self._members["EventName"].update(str(value))

class LOG_NC_EventReceive_FAIL:
        def __init__(self, array=None, antenna=None):
                self.init()
                self.array=array
                self.antenna=antenna
        def init(self):
		self._members={}
		self._logger=getLogger("loggingts --")
		self.name="LOG_NC_EventReceive_FAIL"
		self.audience="Developer"
		self.shortDescription="Failed to receive event, it won't be processed"
                self.priority=ACSLog.ACS_LOG_DEBUG
	def log(self):
		msg=self.shortDescription
		data=[ACSLog.NVPair("logName",self.name)]
		#data.append(ACSLog.NVPair("audience",self.audience))
		for key, value in self._members.items():
			data.append(ACSLog.NVPair(str(key),str(value)))
		cur_stack=extract_stack()
		rtCont=ACSLog.RTContext("",str(getpid()),str(gethostname()).replace("<", "").replace(">", ""),"","")
		srcInfo=ACSLog.SourceInfo(str(cur_stack[0][0]),str(cur_stack[0][2]),long(cur_stack[0][1]))
		timestamp=TimeUtil().py2epoch(time.time()).value
		self._logger.logTypeSafe(self.priority, timestamp, msg, rtCont, srcInfo, data, self.audience, self.array, self.antenna)
        def setArray(self, array):
                self.array=array
        def setAntenna(self, antenna):
                self.antenna=antenna
        def getArray(self):
                return self.array
        def getAntenna(self):
                return self.antenna

	def setChannelName(self, value):
		try:
			self._members["ChannelName"]=str(value)
		except KeyError, e:
			self._members["ChannelName"].update(str(value))

	def setService(self, value):
		try:
			self._members["Service"]=str(value)
		except KeyError, e:
			self._members["Service"].update(str(value))

	def setEventName(self, value):
		try:
			self._members["EventName"]=str(value)
		except KeyError, e:
			self._members["EventName"].update(str(value))

