#ifndef _rtlogTimeDataThread_H_
#define _rtlogTimeDataThread_H_
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: rtlogTimeDataThread.h,v 1.1 2007/07/17 07:41:03 bjeram Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* bjeram  yyyy-mm-dd  created
*/

/************************************************************************
 *
 *----------------------------------------------------------------------
 */

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <acsThread.h>
#include "rtLog.h"

/**
 * TimeData thread which reads time data from kerenl
 */
class TimeDataThread : public ACS::Thread
{
  public:
    TimeDataThread(const ACE_CString &_name);

    void runLoop();

    void onStart();
    void onStop();

    rtLogTimeData_t getTimeData();
 private:
    void setTimeData(rtLogTimeData_t &td);

    ACE_Recursive_Thread_Mutex m_TDMutex; // Mutex for protecting m_timeData
    rtLogTimeData_t m_timeData; // local time data
    RT_TASK* m_task; // rt task
};//TimeDataThread

#endif /*!_rtlogTimeDataThread_H_*/
