#ifndef _maciErrType_H_
#define _maciErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "maciErrTypeC.h"

#include "acserrExceptionManager.h"

namespace maciErrType
{

class ComponentCreationCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = ComponentCreation;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ComponentCreationCompletion::m_shortDescription; }
	ComponentCreationCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ComponentCreationCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentCreationCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentCreationCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentCreationCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ComponentCreationCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class CannotGetComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotGetComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotGetComponentCompletion::m_shortDescription; }
	CannotGetComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotGetComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotGetComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class ComponentNotAlreadyActivatedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = ComponentNotAlreadyActivated;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ComponentNotAlreadyActivatedCompletion::m_shortDescription; }
	ComponentNotAlreadyActivatedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ComponentNotAlreadyActivatedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotAlreadyActivatedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotAlreadyActivatedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotAlreadyActivatedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ComponentNotAlreadyActivatedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class ComponentConfigurationNotFoundCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = ComponentConfigurationNotFound;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ComponentConfigurationNotFoundCompletion::m_shortDescription; }
	ComponentConfigurationNotFoundCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ComponentConfigurationNotFoundCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentConfigurationNotFoundCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentConfigurationNotFoundCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentConfigurationNotFoundCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ComponentConfigurationNotFoundCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class IncompleteComponentSpecCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = IncompleteComponentSpec;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IncompleteComponentSpecCompletion::m_shortDescription; }
	IncompleteComponentSpecCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IncompleteComponentSpecCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncompleteComponentSpecCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncompleteComponentSpecCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IncompleteComponentSpecCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IncompleteComponentSpecCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setContainerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContainerName", value); }            				
	ACE_CString getContainerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContainerName");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class ComponentSpecIncompatibleWithActiveComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = ComponentSpecIncompatibleWithActiveComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ComponentSpecIncompatibleWithActiveComponentCompletion::m_shortDescription; }
	ComponentSpecIncompatibleWithActiveComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ComponentSpecIncompatibleWithActiveComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentSpecIncompatibleWithActiveComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentSpecIncompatibleWithActiveComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentSpecIncompatibleWithActiveComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ComponentSpecIncompatibleWithActiveComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setContainerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContainerName", value); }            				
	ACE_CString getContainerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContainerName");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class InvalidComponentSpecCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = InvalidComponentSpec;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return InvalidComponentSpecCompletion::m_shortDescription; }
	InvalidComponentSpecCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	InvalidComponentSpecCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidComponentSpecCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidComponentSpecCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	InvalidComponentSpecCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	InvalidComponentSpecCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class NoDefaultComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = NoDefaultComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NoDefaultComponentCompletion::m_shortDescription; }
	NoDefaultComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NoDefaultComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoDefaultComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoDefaultComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoDefaultComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NoDefaultComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setIDLType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("IDLType", value); }            				
	ACE_CString getIDLType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("IDLType");  }

	
};

class CannotGetServiceCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotGetService;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotGetServiceCompletion::m_shortDescription; }
	CannotGetServiceCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotGetServiceCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetServiceCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetServiceCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotGetServiceCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotGetServiceCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotActivateComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotActivateComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotActivateComponentCompletion::m_shortDescription; }
	CannotActivateComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotActivateComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotActivateComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotActivateComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotActivateComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotActivateComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setDetailedReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("DetailedReason", value); }            				
	ACE_CString getDetailedReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("DetailedReason");  }

	
};

class CannotDeactivateComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotDeactivateComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotDeactivateComponentCompletion::m_shortDescription; }
	CannotDeactivateComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotDeactivateComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotDeactivateComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotDeactivateComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotDeactivateComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotDeactivateComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotRestartComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotRestartComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotRestartComponentCompletion::m_shortDescription; }
	CannotRestartComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotRestartComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRestartComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRestartComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRestartComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotRestartComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotRegisterComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotRegisterComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotRegisterComponentCompletion::m_shortDescription; }
	CannotRegisterComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotRegisterComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRegisterComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRegisterComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotRegisterComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotRegisterComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

	
};

class CannotUnregisterComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotUnregisterComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotUnregisterComponentCompletion::m_shortDescription; }
	CannotUnregisterComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotUnregisterComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUnregisterComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUnregisterComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUnregisterComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotUnregisterComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotReleaseComponentCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = CannotReleaseComponent;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotReleaseComponentCompletion::m_shortDescription; }
	CannotReleaseComponentCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotReleaseComponentCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotReleaseComponentCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotReleaseComponentCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotReleaseComponentCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotReleaseComponentCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class ComponentNotInUseCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = ComponentNotInUse;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ComponentNotInUseCompletion::m_shortDescription; }
	ComponentNotInUseCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ComponentNotInUseCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotInUseCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotInUseCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ComponentNotInUseCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ComponentNotInUseCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

	         void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class NoPermissionCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = NoPermission;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NoPermissionCompletion::m_shortDescription; }
	NoPermissionCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NoPermissionCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoPermissionCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoPermissionCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NoPermissionCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NoPermissionCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

                void setID(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ID", value); }            				
	ACE_CString getID (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ID");  }

                void setProtectedResource(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ProtectedResource", value); }            				
	ACE_CString getProtectedResource (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ProtectedResource");  }

                void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

        
};

class LoggerDoesNotExistCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType; // = 25
	static const ACSErr::ErrorCode m_code = LoggerDoesNotExist;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return LoggerDoesNotExistCompletion::m_shortDescription; }
	LoggerDoesNotExistCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	LoggerDoesNotExistCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LoggerDoesNotExistCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LoggerDoesNotExistCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	LoggerDoesNotExistCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	LoggerDoesNotExistCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setLoggerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("LoggerName", value); }            				
	ACE_CString getLoggerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("LoggerName");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class maciErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	maciErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	maciErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	maciErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	maciErrTypeExImpl (maciErrType::maciErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	maciErrType::maciErrTypeEx getmaciErrTypeEx () { return maciErrType::maciErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class ComponentCreationExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = ComponentCreation;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ComponentCreationExImpl(const ComponentCreationExImpl& ex) :
			maciErrTypeExImpl(const_cast<ComponentCreationExImpl&>(ex).getErrorTrace()) {}
		
	ComponentCreationExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ComponentCreationExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentCreationExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentCreationExImpl (const maciErrType::ComponentCreationEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::ComponentCreationEx getComponentCreationEx () { return maciErrType::ComponentCreationEx (getErrorTrace()); }
	
	template <class T >
	ComponentCreationExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class CannotGetComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotGetComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotGetComponentExImpl(const CannotGetComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotGetComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotGetComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotGetComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotGetComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotGetComponentExImpl (const maciErrType::CannotGetComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotGetComponentEx getCannotGetComponentEx () { return maciErrType::CannotGetComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotGetComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class ComponentNotAlreadyActivatedExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = ComponentNotAlreadyActivated;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ComponentNotAlreadyActivatedExImpl(const ComponentNotAlreadyActivatedExImpl& ex) :
			maciErrTypeExImpl(const_cast<ComponentNotAlreadyActivatedExImpl&>(ex).getErrorTrace()) {}
		
	ComponentNotAlreadyActivatedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ComponentNotAlreadyActivatedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentNotAlreadyActivatedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentNotAlreadyActivatedExImpl (const maciErrType::ComponentNotAlreadyActivatedEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::ComponentNotAlreadyActivatedEx getComponentNotAlreadyActivatedEx () { return maciErrType::ComponentNotAlreadyActivatedEx (getErrorTrace()); }
	
	template <class T >
	ComponentNotAlreadyActivatedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class ComponentConfigurationNotFoundExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = ComponentConfigurationNotFound;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ComponentConfigurationNotFoundExImpl(const ComponentConfigurationNotFoundExImpl& ex) :
			maciErrTypeExImpl(const_cast<ComponentConfigurationNotFoundExImpl&>(ex).getErrorTrace()) {}
		
	ComponentConfigurationNotFoundExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ComponentConfigurationNotFoundExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentConfigurationNotFoundExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentConfigurationNotFoundExImpl (const maciErrType::ComponentConfigurationNotFoundEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::ComponentConfigurationNotFoundEx getComponentConfigurationNotFoundEx () { return maciErrType::ComponentConfigurationNotFoundEx (getErrorTrace()); }
	
	template <class T >
	ComponentConfigurationNotFoundExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class IncompleteComponentSpecExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = IncompleteComponentSpec;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IncompleteComponentSpecExImpl(const IncompleteComponentSpecExImpl& ex) :
			maciErrTypeExImpl(const_cast<IncompleteComponentSpecExImpl&>(ex).getErrorTrace()) {}
		
	IncompleteComponentSpecExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IncompleteComponentSpecExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IncompleteComponentSpecExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IncompleteComponentSpecExImpl (const maciErrType::IncompleteComponentSpecEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::IncompleteComponentSpecEx getIncompleteComponentSpecEx () { return maciErrType::IncompleteComponentSpecEx (getErrorTrace()); }
	
	template <class T >
	IncompleteComponentSpecExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setContainerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContainerName", value); }            				
	ACE_CString getContainerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContainerName");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class ComponentSpecIncompatibleWithActiveComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = ComponentSpecIncompatibleWithActiveComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ComponentSpecIncompatibleWithActiveComponentExImpl(const ComponentSpecIncompatibleWithActiveComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<ComponentSpecIncompatibleWithActiveComponentExImpl&>(ex).getErrorTrace()) {}
		
	ComponentSpecIncompatibleWithActiveComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ComponentSpecIncompatibleWithActiveComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentSpecIncompatibleWithActiveComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentSpecIncompatibleWithActiveComponentExImpl (const maciErrType::ComponentSpecIncompatibleWithActiveComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::ComponentSpecIncompatibleWithActiveComponentEx getComponentSpecIncompatibleWithActiveComponentEx () { return maciErrType::ComponentSpecIncompatibleWithActiveComponentEx (getErrorTrace()); }
	
	template <class T >
	ComponentSpecIncompatibleWithActiveComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setContainerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContainerName", value); }            				
	ACE_CString getContainerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContainerName");  }

		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class InvalidComponentSpecExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = InvalidComponentSpec;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	InvalidComponentSpecExImpl(const InvalidComponentSpecExImpl& ex) :
			maciErrTypeExImpl(const_cast<InvalidComponentSpecExImpl&>(ex).getErrorTrace()) {}
		
	InvalidComponentSpecExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	InvalidComponentSpecExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidComponentSpecExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	InvalidComponentSpecExImpl (const maciErrType::InvalidComponentSpecEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::InvalidComponentSpecEx getInvalidComponentSpecEx () { return maciErrType::InvalidComponentSpecEx (getErrorTrace()); }
	
	template <class T >
	InvalidComponentSpecExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

	
};

class NoDefaultComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = NoDefaultComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NoDefaultComponentExImpl(const NoDefaultComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<NoDefaultComponentExImpl&>(ex).getErrorTrace()) {}
		
	NoDefaultComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NoDefaultComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoDefaultComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoDefaultComponentExImpl (const maciErrType::NoDefaultComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::NoDefaultComponentEx getNoDefaultComponentEx () { return maciErrType::NoDefaultComponentEx (getErrorTrace()); }
	
	template <class T >
	NoDefaultComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setIDLType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("IDLType", value); }            				
	ACE_CString getIDLType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("IDLType");  }

	
};

class CannotGetServiceExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotGetService;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotGetServiceExImpl(const CannotGetServiceExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotGetServiceExImpl&>(ex).getErrorTrace()) {}
		
	CannotGetServiceExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotGetServiceExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotGetServiceExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotGetServiceExImpl (const maciErrType::CannotGetServiceEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotGetServiceEx getCannotGetServiceEx () { return maciErrType::CannotGetServiceEx (getErrorTrace()); }
	
	template <class T >
	CannotGetServiceExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotActivateComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotActivateComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotActivateComponentExImpl(const CannotActivateComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotActivateComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotActivateComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotActivateComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotActivateComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotActivateComponentExImpl (const maciErrType::CannotActivateComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotActivateComponentEx getCannotActivateComponentEx () { return maciErrType::CannotActivateComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotActivateComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

		void setComponentCode(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentCode", value); }            				
	ACE_CString getComponentCode (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentCode");  }

		void setDetailedReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("DetailedReason", value); }            				
	ACE_CString getDetailedReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("DetailedReason");  }

	
};

class CannotDeactivateComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotDeactivateComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotDeactivateComponentExImpl(const CannotDeactivateComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotDeactivateComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotDeactivateComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotDeactivateComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotDeactivateComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotDeactivateComponentExImpl (const maciErrType::CannotDeactivateComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotDeactivateComponentEx getCannotDeactivateComponentEx () { return maciErrType::CannotDeactivateComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotDeactivateComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotRestartComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotRestartComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotRestartComponentExImpl(const CannotRestartComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotRestartComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotRestartComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotRestartComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotRestartComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotRestartComponentExImpl (const maciErrType::CannotRestartComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotRestartComponentEx getCannotRestartComponentEx () { return maciErrType::CannotRestartComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotRestartComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotRegisterComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotRegisterComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotRegisterComponentExImpl(const CannotRegisterComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotRegisterComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotRegisterComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotRegisterComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotRegisterComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotRegisterComponentExImpl (const maciErrType::CannotRegisterComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotRegisterComponentEx getCannotRegisterComponentEx () { return maciErrType::CannotRegisterComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotRegisterComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setComponentType(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ComponentType", value); }            				
	ACE_CString getComponentType (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ComponentType");  }

	
};

class CannotUnregisterComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotUnregisterComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotUnregisterComponentExImpl(const CannotUnregisterComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotUnregisterComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotUnregisterComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotUnregisterComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotUnregisterComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotUnregisterComponentExImpl (const maciErrType::CannotUnregisterComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotUnregisterComponentEx getCannotUnregisterComponentEx () { return maciErrType::CannotUnregisterComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotUnregisterComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class CannotReleaseComponentExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = CannotReleaseComponent;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotReleaseComponentExImpl(const CannotReleaseComponentExImpl& ex) :
			maciErrTypeExImpl(const_cast<CannotReleaseComponentExImpl&>(ex).getErrorTrace()) {}
		
	CannotReleaseComponentExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotReleaseComponentExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotReleaseComponentExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotReleaseComponentExImpl (const maciErrType::CannotReleaseComponentEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::CannotReleaseComponentEx getCannotReleaseComponentEx () { return maciErrType::CannotReleaseComponentEx (getErrorTrace()); }
	
	template <class T >
	CannotReleaseComponentExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class ComponentNotInUseExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = ComponentNotInUse;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ComponentNotInUseExImpl(const ComponentNotInUseExImpl& ex) :
			maciErrTypeExImpl(const_cast<ComponentNotInUseExImpl&>(ex).getErrorTrace()) {}
		
	ComponentNotInUseExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ComponentNotInUseExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentNotInUseExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ComponentNotInUseExImpl (const maciErrType::ComponentNotInUseEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::ComponentNotInUseEx getComponentNotInUseEx () { return maciErrType::ComponentNotInUseEx (getErrorTrace()); }
	
	template <class T >
	ComponentNotInUseExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


	         void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

	
};

class NoPermissionExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = NoPermission;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NoPermissionExImpl(const NoPermissionExImpl& ex) :
			maciErrTypeExImpl(const_cast<NoPermissionExImpl&>(ex).getErrorTrace()) {}
		
	NoPermissionExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NoPermissionExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoPermissionExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NoPermissionExImpl (const maciErrType::NoPermissionEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::NoPermissionEx getNoPermissionEx () { return maciErrType::NoPermissionEx (getErrorTrace()); }
	
	template <class T >
	NoPermissionExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


                void setID(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ID", value); }            				
	ACE_CString getID (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ID");  }

                void setProtectedResource(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ProtectedResource", value); }            				
	ACE_CString getProtectedResource (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ProtectedResource");  }

                void setReason(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Reason", value); }            				
	ACE_CString getReason (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Reason");  }

        
};

class LoggerDoesNotExistExImpl: public maciErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::maciErrType;
	static const ACSErr::ErrorCode m_code = LoggerDoesNotExist;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	LoggerDoesNotExistExImpl(const LoggerDoesNotExistExImpl& ex) :
			maciErrTypeExImpl(const_cast<LoggerDoesNotExistExImpl&>(ex).getErrorTrace()) {}
		
	LoggerDoesNotExistExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	LoggerDoesNotExistExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	LoggerDoesNotExistExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	LoggerDoesNotExistExImpl (const maciErrType::LoggerDoesNotExistEx & ex) : 
			maciErrTypeExImpl(ex.errorTrace) {}
			
	maciErrType::LoggerDoesNotExistEx getLoggerDoesNotExistEx () { return maciErrType::LoggerDoesNotExistEx (getErrorTrace()); }
	
	template <class T >
	LoggerDoesNotExistExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			maciErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setLoggerName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("LoggerName", value); }            				
	ACE_CString getLoggerName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("LoggerName");  }

	
};

}

#endif
