#ifndef _jmanagerErrType_H_
#define _jmanagerErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "jmanagerErrTypeC.h"

#include "acserrExceptionManager.h"

namespace jmanagerErrType
{

class CyclicDependencyDetectedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::jmanagerErrType; // = 26
	static const ACSErr::ErrorCode m_code = CyclicDependencyDetected;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CyclicDependencyDetectedCompletion::m_shortDescription; }
	CyclicDependencyDetectedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CyclicDependencyDetectedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CyclicDependencyDetectedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CyclicDependencyDetectedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CyclicDependencyDetectedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CyclicDependencyDetectedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setRequestor(long value){ getErrorTraceHelper()->setMemberValue("Requestor", value); }            				
	long getRequestor (){ return getErrorTraceHelper()->getMemberValue<long>("Requestor");  }

	
};

class SyncLockFailedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::jmanagerErrType; // = 26
	static const ACSErr::ErrorCode m_code = SyncLockFailed;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return SyncLockFailedCompletion::m_shortDescription; }
	SyncLockFailedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	SyncLockFailedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	SyncLockFailedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	SyncLockFailedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	SyncLockFailedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	SyncLockFailedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setRequestor(long value){ getErrorTraceHelper()->setMemberValue("Requestor", value); }            				
	long getRequestor (){ return getErrorTraceHelper()->getMemberValue<long>("Requestor");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class jmanagerErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	jmanagerErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	jmanagerErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	jmanagerErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	jmanagerErrTypeExImpl (jmanagerErrType::jmanagerErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	jmanagerErrType::jmanagerErrTypeEx getjmanagerErrTypeEx () { return jmanagerErrType::jmanagerErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class CyclicDependencyDetectedExImpl: public jmanagerErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::jmanagerErrType;
	static const ACSErr::ErrorCode m_code = CyclicDependencyDetected;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CyclicDependencyDetectedExImpl(const CyclicDependencyDetectedExImpl& ex) :
			jmanagerErrTypeExImpl(const_cast<CyclicDependencyDetectedExImpl&>(ex).getErrorTrace()) {}
		
	CyclicDependencyDetectedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CyclicDependencyDetectedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CyclicDependencyDetectedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CyclicDependencyDetectedExImpl (const jmanagerErrType::CyclicDependencyDetectedEx & ex) : 
			jmanagerErrTypeExImpl(ex.errorTrace) {}
			
	jmanagerErrType::CyclicDependencyDetectedEx getCyclicDependencyDetectedEx () { return jmanagerErrType::CyclicDependencyDetectedEx (getErrorTrace()); }
	
	template <class T >
	CyclicDependencyDetectedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setRequestor(long value){ getErrorTraceHelper()->setMemberValue("Requestor", value); }            				
	long getRequestor (){ return getErrorTraceHelper()->getMemberValue<long>("Requestor");  }

	
};

class SyncLockFailedExImpl: public jmanagerErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::jmanagerErrType;
	static const ACSErr::ErrorCode m_code = SyncLockFailed;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	SyncLockFailedExImpl(const SyncLockFailedExImpl& ex) :
			jmanagerErrTypeExImpl(const_cast<SyncLockFailedExImpl&>(ex).getErrorTrace()) {}
		
	SyncLockFailedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	SyncLockFailedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	SyncLockFailedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	SyncLockFailedExImpl (const jmanagerErrType::SyncLockFailedEx & ex) : 
			jmanagerErrTypeExImpl(ex.errorTrace) {}
			
	jmanagerErrType::SyncLockFailedEx getSyncLockFailedEx () { return jmanagerErrType::SyncLockFailedEx (getErrorTrace()); }
	
	template <class T >
	SyncLockFailedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			jmanagerErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setCURL(ACE_CString value){ getErrorTraceHelper()->setMemberValue("CURL", value); }            				
	ACE_CString getCURL (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("CURL");  }

		void setRequestor(long value){ getErrorTraceHelper()->setMemberValue("Requestor", value); }            				
	long getRequestor (){ return getErrorTraceHelper()->getMemberValue<long>("Requestor");  }

	
};

}

#endif
