#ifndef _ARCHIVE_BULK_RECEIVER_IMPL_H
#define _ARCHIVE_BULK_RECEIVER_IMPL_H
/*******************************************************************************
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration)
 *    and Cosylab 2002, All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *
 * "@(#)"
 *
 * who       when      what
 * --------  --------  ----------------------------------------------
 * oat       30/03/04  created
 */

/************************************************************************
 *
 *----------------------------------------------------------------------
 */

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <archive_xmlstore_ifC.h>
#include "archiveBulkReceiverS.h"

#include "bulkDataReceiverImpl.h"
#include "EventComponentS.h"
#include "acsncSimpleSupplier.h"

#include "archiveBulkReceiverBuffer.h"
#include "archiveBulkReceiverCb.h"
//using namespace baci;
//using namespace maci;
using namespace std;

extern "C" {
# include "ngams.h"
}
/** @file bulkDataReceiverEx2Impl.h
 */

class ArchiveBulkReceiverImpl : public virtual BulkDataReceiverImpl<ArchiveBulkReceiverCb>, public virtual POA_archive::ArchiveBulkReceiver {
public:

	/**
	 * Constructor
	 * @param poa Poa which will activate this and also all other Components.
	 * @param name component name.
	 */
	ArchiveBulkReceiverImpl(const ACE_CString& name, ContainerServices* containerServices);

	/**
	 * Destructor
	 */
	virtual ~ArchiveBulkReceiverImpl();

	void cleanUp() throw (acsErrTypeLifeCycle::acsErrTypeLifeCycleExImpl);

	void initialize() throw (acsErrTypeLifeCycle::LifeCycleExImpl);

	virtual bool ping() throw (CORBA::SystemException);

	// create event supplier and pass reference of it to callbacks
	void passSupplier2cbs() throw (CORBA::SystemException);

	char* getBRHostName() throw (CORBA::SystemException);

	CORBA::ULong getMaxBufferUsage() throw (CORBA::SystemException);
	CORBA::ULong getAvgThroughput() throw (CORBA::SystemException);
	CORBA::ULongLong getTotalSaveTime() throw (CORBA::SystemException);
	CORBA::ULongLong getTotalFileLength() throw (CORBA::SystemException);
	CORBA::Boolean isFinish() throw (CORBA::SystemException);
	void getThreadInfo() throw (CORBA::SystemException);
	void resetAllThread() throw (CORBA::SystemException);
	void resetStatistics() throw (CORBA::SystemException);
	
	// let master component control execution of ngasArchiveClient to avoid duplicated instance
	bool startNGASArchiveClient() throw (CORBA::SystemException);
	void shutdownNGASArchiveClient() throw (CORBA::SystemException);

private:
	// for sending out events:
	nc::SimpleSupplier *m_eventSupplier;

	xmlstore::ArchiveConnection_var archConn;
	xmlstore::Operational_var xmlOp;
	xmlstore::Administrative_var xmlAdmin;
	ArchiveBulkReceiverBuffer *bufferMaster;

	// name of host where BR is running (for report)
	char* BR_HOST;
	// config of storeInNgast to avoid call administrative too often
	ACE_CString storeInNgast;
	// ngas destionation, default almadev1 7777, 
	// in dbConfig.properties = archive.ngas.server , serverA serverB ...
	vector<NGAS_DEST *> ngasList;
	// ngasArchiveClient start command
	string ngasArchiveClientCmd;
	// ngasArchiveClient pid file
	string ngasArchiveClientPid;
};

#endif
