#ifndef _acsncErrType_H_
#define _acsncErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "acsncErrTypeC.h"

#include "acserrExceptionManager.h"

namespace acsncErrType
{

class WrongEventReceivedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType; // = 38
	static const ACSErr::ErrorCode m_code = WrongEventReceived;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return WrongEventReceivedCompletion::m_shortDescription; }
	WrongEventReceivedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	WrongEventReceivedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongEventReceivedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongEventReceivedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	WrongEventReceivedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	WrongEventReceivedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setExpectedEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ExpectedEvent", value); }            				
	ACE_CString getExpectedEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ExpectedEvent");  }

		void setReceivedEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ReceivedEvent", value); }            				
	ACE_CString getReceivedEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ReceivedEvent");  }

	
};

class EventSubscriptionFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType; // = 38
	static const ACSErr::ErrorCode m_code = EventSubscriptionFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return EventSubscriptionFailureCompletion::m_shortDescription; }
	EventSubscriptionFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	EventSubscriptionFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EventSubscriptionFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EventSubscriptionFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	EventSubscriptionFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	EventSubscriptionFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setEventName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("EventName", value); }            				
	ACE_CString getEventName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("EventName");  }

		void setChannelName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ChannelName", value); }            				
	ACE_CString getChannelName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ChannelName");  }

	
};

class PublishEventFailureCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType; // = 38
	static const ACSErr::ErrorCode m_code = PublishEventFailure;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PublishEventFailureCompletion::m_shortDescription; }
	PublishEventFailureCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PublishEventFailureCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PublishEventFailureCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PublishEventFailureCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PublishEventFailureCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PublishEventFailureCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

		void setEventName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("EventName", value); }            				
	ACE_CString getEventName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("EventName");  }

		void setChannelName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ChannelName", value); }            				
	ACE_CString getChannelName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ChannelName");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class acsncErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	acsncErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	acsncErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	acsncErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	acsncErrTypeExImpl (acsncErrType::acsncErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	acsncErrType::acsncErrTypeEx getacsncErrTypeEx () { return acsncErrType::acsncErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class WrongEventReceivedExImpl: public acsncErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType;
	static const ACSErr::ErrorCode m_code = WrongEventReceived;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	WrongEventReceivedExImpl(const WrongEventReceivedExImpl& ex) :
			acsncErrTypeExImpl(const_cast<WrongEventReceivedExImpl&>(ex).getErrorTrace()) {}
		
	WrongEventReceivedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	WrongEventReceivedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongEventReceivedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	WrongEventReceivedExImpl (const acsncErrType::WrongEventReceivedEx & ex) : 
			acsncErrTypeExImpl(ex.errorTrace) {}
			
	acsncErrType::WrongEventReceivedEx getWrongEventReceivedEx () { return acsncErrType::WrongEventReceivedEx (getErrorTrace()); }
	
	template <class T >
	WrongEventReceivedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setExpectedEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ExpectedEvent", value); }            				
	ACE_CString getExpectedEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ExpectedEvent");  }

		void setReceivedEvent(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ReceivedEvent", value); }            				
	ACE_CString getReceivedEvent (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ReceivedEvent");  }

	
};

class EventSubscriptionFailureExImpl: public acsncErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType;
	static const ACSErr::ErrorCode m_code = EventSubscriptionFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	EventSubscriptionFailureExImpl(const EventSubscriptionFailureExImpl& ex) :
			acsncErrTypeExImpl(const_cast<EventSubscriptionFailureExImpl&>(ex).getErrorTrace()) {}
		
	EventSubscriptionFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	EventSubscriptionFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	EventSubscriptionFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	EventSubscriptionFailureExImpl (const acsncErrType::EventSubscriptionFailureEx & ex) : 
			acsncErrTypeExImpl(ex.errorTrace) {}
			
	acsncErrType::EventSubscriptionFailureEx getEventSubscriptionFailureEx () { return acsncErrType::EventSubscriptionFailureEx (getErrorTrace()); }
	
	template <class T >
	EventSubscriptionFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setEventName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("EventName", value); }            				
	ACE_CString getEventName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("EventName");  }

		void setChannelName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ChannelName", value); }            				
	ACE_CString getChannelName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ChannelName");  }

	
};

class PublishEventFailureExImpl: public acsncErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsncErrType;
	static const ACSErr::ErrorCode m_code = PublishEventFailure;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PublishEventFailureExImpl(const PublishEventFailureExImpl& ex) :
			acsncErrTypeExImpl(const_cast<PublishEventFailureExImpl&>(ex).getErrorTrace()) {}
		
	PublishEventFailureExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PublishEventFailureExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PublishEventFailureExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PublishEventFailureExImpl (const acsncErrType::PublishEventFailureEx & ex) : 
			acsncErrTypeExImpl(ex.errorTrace) {}
			
	acsncErrType::PublishEventFailureEx getPublishEventFailureEx () { return acsncErrType::PublishEventFailureEx (getErrorTrace()); }
	
	template <class T >
	PublishEventFailureExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsncErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


		void setEventName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("EventName", value); }            				
	ACE_CString getEventName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("EventName");  }

		void setChannelName(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ChannelName", value); }            				
	ACE_CString getChannelName (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ChannelName");  }

	
};

}

#endif
