#ifndef _acsdaemonErrType_H_
#define _acsdaemonErrType_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "acsdaemonErrTypeC.h"

#include "acserrExceptionManager.h"

namespace acsdaemonErrType
{

class FailedToStartContainerCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = FailedToStartContainer;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToStartContainerCompletion::m_shortDescription; }
	FailedToStartContainerCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToStartContainerCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStartContainerCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStartContainerCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStartContainerCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToStartContainerCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class FailedToStopContainerCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = FailedToStopContainer;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToStopContainerCompletion::m_shortDescription; }
	FailedToStopContainerCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToStopContainerCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopContainerCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopContainerCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopContainerCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToStopContainerCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class AcsStartServicesCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = AcsStartServices;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return AcsStartServicesCompletion::m_shortDescription; }
	AcsStartServicesCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	AcsStartServicesCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AcsStartServicesCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AcsStartServicesCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	AcsStartServicesCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	AcsStartServicesCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class FailedToStopAcsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = FailedToStopAcs;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToStopAcsCompletion::m_shortDescription; }
	FailedToStopAcsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToStopAcsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopAcsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopAcsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToStopAcsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToStopAcsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ServiceAlreadyRunningCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = ServiceAlreadyRunning;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ServiceAlreadyRunningCompletion::m_shortDescription; }
	ServiceAlreadyRunningCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ServiceAlreadyRunningCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceAlreadyRunningCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceAlreadyRunningCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceAlreadyRunningCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ServiceAlreadyRunningCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setService(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Service", value); }            				
	ACE_CString getService (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Service");  }

	
};

class ServiceNotRunningCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = ServiceNotRunning;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ServiceNotRunningCompletion::m_shortDescription; }
	ServiceNotRunningCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ServiceNotRunningCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceNotRunningCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceNotRunningCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ServiceNotRunningCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ServiceNotRunningCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class FailedToGetAcsStatusCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = FailedToGetAcsStatus;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToGetAcsStatusCompletion::m_shortDescription; }
	FailedToGetAcsStatusCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToGetAcsStatusCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToGetAcsStatusCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToGetAcsStatusCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToGetAcsStatusCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToGetAcsStatusCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class ProcessingAbortedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = ProcessingAborted;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ProcessingAbortedCompletion::m_shortDescription; }
	ProcessingAbortedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ProcessingAbortedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ProcessingAbortedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ProcessingAbortedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ProcessingAbortedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ProcessingAbortedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CannotCreateInstanceCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = CannotCreateInstance;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotCreateInstanceCompletion::m_shortDescription; }
	CannotCreateInstanceCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotCreateInstanceCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotCreateInstanceCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotCreateInstanceCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotCreateInstanceCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotCreateInstanceCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class CannotUseInstanceCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = CannotUseInstance;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CannotUseInstanceCompletion::m_shortDescription; }
	CannotUseInstanceCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CannotUseInstanceCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUseInstanceCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUseInstanceCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CannotUseInstanceCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CannotUseInstanceCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class FailedToProcessRequestCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = FailedToProcessRequest;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return FailedToProcessRequestCompletion::m_shortDescription; }
	FailedToProcessRequestCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	FailedToProcessRequestCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToProcessRequestCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToProcessRequestCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	FailedToProcessRequestCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	FailedToProcessRequestCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class BadArgumentsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = BadArguments;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return BadArgumentsCompletion::m_shortDescription; }
	BadArgumentsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	BadArgumentsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadArgumentsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadArgumentsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	BadArgumentsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	BadArgumentsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PortInUseCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = PortInUse;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PortInUseCompletion::m_shortDescription; }
	PortInUseCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PortInUseCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PortInUseCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PortInUseCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PortInUseCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PortInUseCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class RequestProcessingTimedOutCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType; // = 55
	static const ACSErr::ErrorCode m_code = RequestProcessingTimedOut;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RequestProcessingTimedOutCompletion::m_shortDescription; }
	RequestProcessingTimedOutCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RequestProcessingTimedOutCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RequestProcessingTimedOutCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RequestProcessingTimedOutCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RequestProcessingTimedOutCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RequestProcessingTimedOutCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class acsdaemonErrTypeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	acsdaemonErrTypeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	acsdaemonErrTypeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	acsdaemonErrTypeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	acsdaemonErrTypeExImpl (acsdaemonErrType::acsdaemonErrTypeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::acsdaemonErrTypeEx getacsdaemonErrTypeEx () { return acsdaemonErrType::acsdaemonErrTypeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class FailedToStartContainerExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = FailedToStartContainer;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToStartContainerExImpl(const FailedToStartContainerExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<FailedToStartContainerExImpl&>(ex).getErrorTrace()) {}
		
	FailedToStartContainerExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToStartContainerExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStartContainerExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStartContainerExImpl (const acsdaemonErrType::FailedToStartContainerEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::FailedToStartContainerEx getFailedToStartContainerEx () { return acsdaemonErrType::FailedToStartContainerEx (getErrorTrace()); }
	
	template <class T >
	FailedToStartContainerExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class FailedToStopContainerExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = FailedToStopContainer;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToStopContainerExImpl(const FailedToStopContainerExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<FailedToStopContainerExImpl&>(ex).getErrorTrace()) {}
		
	FailedToStopContainerExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToStopContainerExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStopContainerExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStopContainerExImpl (const acsdaemonErrType::FailedToStopContainerEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::FailedToStopContainerEx getFailedToStopContainerEx () { return acsdaemonErrType::FailedToStopContainerEx (getErrorTrace()); }
	
	template <class T >
	FailedToStopContainerExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class AcsStartServicesExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = AcsStartServices;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	AcsStartServicesExImpl(const AcsStartServicesExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<AcsStartServicesExImpl&>(ex).getErrorTrace()) {}
		
	AcsStartServicesExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	AcsStartServicesExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AcsStartServicesExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	AcsStartServicesExImpl (const acsdaemonErrType::AcsStartServicesEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::AcsStartServicesEx getAcsStartServicesEx () { return acsdaemonErrType::AcsStartServicesEx (getErrorTrace()); }
	
	template <class T >
	AcsStartServicesExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class FailedToStopAcsExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = FailedToStopAcs;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToStopAcsExImpl(const FailedToStopAcsExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<FailedToStopAcsExImpl&>(ex).getErrorTrace()) {}
		
	FailedToStopAcsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToStopAcsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStopAcsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToStopAcsExImpl (const acsdaemonErrType::FailedToStopAcsEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::FailedToStopAcsEx getFailedToStopAcsEx () { return acsdaemonErrType::FailedToStopAcsEx (getErrorTrace()); }
	
	template <class T >
	FailedToStopAcsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ServiceAlreadyRunningExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = ServiceAlreadyRunning;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ServiceAlreadyRunningExImpl(const ServiceAlreadyRunningExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<ServiceAlreadyRunningExImpl&>(ex).getErrorTrace()) {}
		
	ServiceAlreadyRunningExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ServiceAlreadyRunningExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ServiceAlreadyRunningExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ServiceAlreadyRunningExImpl (const acsdaemonErrType::ServiceAlreadyRunningEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::ServiceAlreadyRunningEx getServiceAlreadyRunningEx () { return acsdaemonErrType::ServiceAlreadyRunningEx (getErrorTrace()); }
	
	template <class T >
	ServiceAlreadyRunningExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setService(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Service", value); }            				
	ACE_CString getService (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Service");  }

	
};

class ServiceNotRunningExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = ServiceNotRunning;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ServiceNotRunningExImpl(const ServiceNotRunningExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<ServiceNotRunningExImpl&>(ex).getErrorTrace()) {}
		
	ServiceNotRunningExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ServiceNotRunningExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ServiceNotRunningExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ServiceNotRunningExImpl (const acsdaemonErrType::ServiceNotRunningEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::ServiceNotRunningEx getServiceNotRunningEx () { return acsdaemonErrType::ServiceNotRunningEx (getErrorTrace()); }
	
	template <class T >
	ServiceNotRunningExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class FailedToGetAcsStatusExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = FailedToGetAcsStatus;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToGetAcsStatusExImpl(const FailedToGetAcsStatusExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<FailedToGetAcsStatusExImpl&>(ex).getErrorTrace()) {}
		
	FailedToGetAcsStatusExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToGetAcsStatusExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToGetAcsStatusExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToGetAcsStatusExImpl (const acsdaemonErrType::FailedToGetAcsStatusEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::FailedToGetAcsStatusEx getFailedToGetAcsStatusEx () { return acsdaemonErrType::FailedToGetAcsStatusEx (getErrorTrace()); }
	
	template <class T >
	FailedToGetAcsStatusExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class ProcessingAbortedExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = ProcessingAborted;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ProcessingAbortedExImpl(const ProcessingAbortedExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<ProcessingAbortedExImpl&>(ex).getErrorTrace()) {}
		
	ProcessingAbortedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ProcessingAbortedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ProcessingAbortedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ProcessingAbortedExImpl (const acsdaemonErrType::ProcessingAbortedEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::ProcessingAbortedEx getProcessingAbortedEx () { return acsdaemonErrType::ProcessingAbortedEx (getErrorTrace()); }
	
	template <class T >
	ProcessingAbortedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CannotCreateInstanceExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = CannotCreateInstance;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotCreateInstanceExImpl(const CannotCreateInstanceExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<CannotCreateInstanceExImpl&>(ex).getErrorTrace()) {}
		
	CannotCreateInstanceExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotCreateInstanceExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotCreateInstanceExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotCreateInstanceExImpl (const acsdaemonErrType::CannotCreateInstanceEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::CannotCreateInstanceEx getCannotCreateInstanceEx () { return acsdaemonErrType::CannotCreateInstanceEx (getErrorTrace()); }
	
	template <class T >
	CannotCreateInstanceExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class CannotUseInstanceExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = CannotUseInstance;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CannotUseInstanceExImpl(const CannotUseInstanceExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<CannotUseInstanceExImpl&>(ex).getErrorTrace()) {}
		
	CannotUseInstanceExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CannotUseInstanceExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotUseInstanceExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CannotUseInstanceExImpl (const acsdaemonErrType::CannotUseInstanceEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::CannotUseInstanceEx getCannotUseInstanceEx () { return acsdaemonErrType::CannotUseInstanceEx (getErrorTrace()); }
	
	template <class T >
	CannotUseInstanceExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class FailedToProcessRequestExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = FailedToProcessRequest;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	FailedToProcessRequestExImpl(const FailedToProcessRequestExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<FailedToProcessRequestExImpl&>(ex).getErrorTrace()) {}
		
	FailedToProcessRequestExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	FailedToProcessRequestExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToProcessRequestExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	FailedToProcessRequestExImpl (const acsdaemonErrType::FailedToProcessRequestEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::FailedToProcessRequestEx getFailedToProcessRequestEx () { return acsdaemonErrType::FailedToProcessRequestEx (getErrorTrace()); }
	
	template <class T >
	FailedToProcessRequestExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class BadArgumentsExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = BadArguments;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	BadArgumentsExImpl(const BadArgumentsExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<BadArgumentsExImpl&>(ex).getErrorTrace()) {}
		
	BadArgumentsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	BadArgumentsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	BadArgumentsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	BadArgumentsExImpl (const acsdaemonErrType::BadArgumentsEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::BadArgumentsEx getBadArgumentsEx () { return acsdaemonErrType::BadArgumentsEx (getErrorTrace()); }
	
	template <class T >
	BadArgumentsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PortInUseExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = PortInUse;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PortInUseExImpl(const PortInUseExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<PortInUseExImpl&>(ex).getErrorTrace()) {}
		
	PortInUseExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PortInUseExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PortInUseExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PortInUseExImpl (const acsdaemonErrType::PortInUseEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::PortInUseEx getPortInUseEx () { return acsdaemonErrType::PortInUseEx (getErrorTrace()); }
	
	template <class T >
	PortInUseExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class RequestProcessingTimedOutExImpl: public acsdaemonErrTypeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::acsdaemonErrType;
	static const ACSErr::ErrorCode m_code = RequestProcessingTimedOut;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RequestProcessingTimedOutExImpl(const RequestProcessingTimedOutExImpl& ex) :
			acsdaemonErrTypeExImpl(const_cast<RequestProcessingTimedOutExImpl&>(ex).getErrorTrace()) {}
		
	RequestProcessingTimedOutExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RequestProcessingTimedOutExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RequestProcessingTimedOutExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RequestProcessingTimedOutExImpl (const acsdaemonErrType::RequestProcessingTimedOutEx & ex) : 
			acsdaemonErrTypeExImpl(ex.errorTrace) {}
			
	acsdaemonErrType::RequestProcessingTimedOutEx getRequestProcessingTimedOutEx () { return acsdaemonErrType::RequestProcessingTimedOutEx (getErrorTrace()); }
	
	template <class T >
	RequestProcessingTimedOutExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			acsdaemonErrTypeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
