#ifndef _JavaContainerError_H_
#define _JavaContainerError_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "JavaContainerErrorC.h"

#include "acserrExceptionManager.h"

namespace JavaContainerError
{

class ContainerServicesCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError; // = 6666
	static const ACSErr::ErrorCode m_code = ContainerServices;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ContainerServicesCompletion::m_shortDescription; }
	ContainerServicesCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ContainerServicesCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerServicesCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerServicesCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerServicesCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ContainerServicesCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class JavaComponentHelperCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError; // = 6666
	static const ACSErr::ErrorCode m_code = JavaComponentHelper;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return JavaComponentHelperCompletion::m_shortDescription; }
	JavaComponentHelperCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	JavaComponentHelperCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	JavaComponentHelperCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	JavaComponentHelperCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	JavaComponentHelperCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	JavaComponentHelperCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class ContainerCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError; // = 6666
	static const ACSErr::ErrorCode m_code = Container;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return ContainerCompletion::m_shortDescription; }
	ContainerCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	ContainerCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	ContainerCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	ContainerCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class JavaContainerErrorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	JavaContainerErrorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	JavaContainerErrorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	JavaContainerErrorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	JavaContainerErrorExImpl (JavaContainerError::JavaContainerErrorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	JavaContainerError::JavaContainerErrorEx getJavaContainerErrorEx () { return JavaContainerError::JavaContainerErrorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class ContainerServicesExImpl: public JavaContainerErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError;
	static const ACSErr::ErrorCode m_code = ContainerServices;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ContainerServicesExImpl(const ContainerServicesExImpl& ex) :
			JavaContainerErrorExImpl(const_cast<ContainerServicesExImpl&>(ex).getErrorTrace()) {}
		
	ContainerServicesExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ContainerServicesExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ContainerServicesExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ContainerServicesExImpl (const JavaContainerError::ContainerServicesEx & ex) : 
			JavaContainerErrorExImpl(ex.errorTrace) {}
			
	JavaContainerError::ContainerServicesEx getContainerServicesEx () { return JavaContainerError::ContainerServicesEx (getErrorTrace()); }
	
	template <class T >
	ContainerServicesExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class JavaComponentHelperExImpl: public JavaContainerErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError;
	static const ACSErr::ErrorCode m_code = JavaComponentHelper;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	JavaComponentHelperExImpl(const JavaComponentHelperExImpl& ex) :
			JavaContainerErrorExImpl(const_cast<JavaComponentHelperExImpl&>(ex).getErrorTrace()) {}
		
	JavaComponentHelperExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	JavaComponentHelperExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	JavaComponentHelperExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	JavaComponentHelperExImpl (const JavaContainerError::JavaComponentHelperEx & ex) : 
			JavaContainerErrorExImpl(ex.errorTrace) {}
			
	JavaContainerError::JavaComponentHelperEx getJavaComponentHelperEx () { return JavaContainerError::JavaComponentHelperEx (getErrorTrace()); }
	
	template <class T >
	JavaComponentHelperExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class ContainerExImpl: public JavaContainerErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::JavaContainerError;
	static const ACSErr::ErrorCode m_code = Container;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	ContainerExImpl(const ContainerExImpl& ex) :
			JavaContainerErrorExImpl(const_cast<ContainerExImpl&>(ex).getErrorTrace()) {}
		
	ContainerExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	ContainerExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ContainerExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	ContainerExImpl (const JavaContainerError::ContainerEx & ex) : 
			JavaContainerErrorExImpl(ex.errorTrace) {}
			
	JavaContainerError::ContainerEx getContainerEx () { return JavaContainerError::ContainerEx (getErrorTrace()); }
	
	template <class T >
	ContainerExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			JavaContainerErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

}

#endif
