#ifndef _ErrorSystemExample_H_
#define _ErrorSystemExample_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ErrorSystemExampleC.h"

#include "acserrExceptionManager.h"

namespace ErrorSystemExample
{

class NothingCanBeScheduledErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemExample; // = 904
	static const ACSErr::ErrorCode m_code = NothingCanBeScheduledError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return NothingCanBeScheduledErrorCompletion::m_shortDescription; }
	NothingCanBeScheduledErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	NothingCanBeScheduledErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NothingCanBeScheduledErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NothingCanBeScheduledErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	NothingCanBeScheduledErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	NothingCanBeScheduledErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};

class PipelineProcessingRequestErrorCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemExample; // = 904
	static const ACSErr::ErrorCode m_code = PipelineProcessingRequestError;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return PipelineProcessingRequestErrorCompletion::m_shortDescription; }
	PipelineProcessingRequestErrorCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	PipelineProcessingRequestErrorCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PipelineProcessingRequestErrorCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PipelineProcessingRequestErrorCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	PipelineProcessingRequestErrorCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	PipelineProcessingRequestErrorCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ErrorSystemExampleExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ErrorSystemExampleExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ErrorSystemExampleExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ErrorSystemExampleExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ErrorSystemExampleExImpl (ErrorSystemExample::ErrorSystemExampleEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ErrorSystemExample::ErrorSystemExampleEx getErrorSystemExampleEx () { return ErrorSystemExample::ErrorSystemExampleEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class NothingCanBeScheduledErrorExImpl: public ErrorSystemExampleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemExample;
	static const ACSErr::ErrorCode m_code = NothingCanBeScheduledError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	NothingCanBeScheduledErrorExImpl(const NothingCanBeScheduledErrorExImpl& ex) :
			ErrorSystemExampleExImpl(const_cast<NothingCanBeScheduledErrorExImpl&>(ex).getErrorTrace()) {}
		
	NothingCanBeScheduledErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	NothingCanBeScheduledErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NothingCanBeScheduledErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	NothingCanBeScheduledErrorExImpl (const ErrorSystemExample::NothingCanBeScheduledErrorEx & ex) : 
			ErrorSystemExampleExImpl(ex.errorTrace) {}
			
	ErrorSystemExample::NothingCanBeScheduledErrorEx getNothingCanBeScheduledErrorEx () { return ErrorSystemExample::NothingCanBeScheduledErrorEx (getErrorTrace()); }
	
	template <class T >
	NothingCanBeScheduledErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

class PipelineProcessingRequestErrorExImpl: public ErrorSystemExampleExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ErrorSystemExample;
	static const ACSErr::ErrorCode m_code = PipelineProcessingRequestError;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	PipelineProcessingRequestErrorExImpl(const PipelineProcessingRequestErrorExImpl& ex) :
			ErrorSystemExampleExImpl(const_cast<PipelineProcessingRequestErrorExImpl&>(ex).getErrorTrace()) {}
		
	PipelineProcessingRequestErrorExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	PipelineProcessingRequestErrorExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PipelineProcessingRequestErrorExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	PipelineProcessingRequestErrorExImpl (const ErrorSystemExample::PipelineProcessingRequestErrorEx & ex) : 
			ErrorSystemExampleExImpl(ex.errorTrace) {}
			
	ErrorSystemExample::PipelineProcessingRequestErrorEx getPipelineProcessingRequestErrorEx () { return ErrorSystemExample::PipelineProcessingRequestErrorEx (getErrorTrace()); }
	
	template <class T >
	PipelineProcessingRequestErrorExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ErrorSystemExampleExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
