#ifndef _ArchiveIdentifierError_H_
#define _ArchiveIdentifierError_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ArchiveIdentifierErrorC.h"

#include "acserrExceptionManager.h"

namespace ArchiveIdentifierError
{

class IdentifierUnexpectedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = IdentifierUnexpected;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IdentifierUnexpectedCompletion::m_shortDescription; }
	IdentifierUnexpectedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IdentifierUnexpectedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnexpectedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnexpectedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnexpectedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IdentifierUnexpectedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class IdentifierUnavailableCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = IdentifierUnavailable;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return IdentifierUnavailableCompletion::m_shortDescription; }
	IdentifierUnavailableCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	IdentifierUnavailableCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnavailableCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnavailableCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	IdentifierUnavailableCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	IdentifierUnavailableCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class UidAlreadyExistsCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = UidAlreadyExists;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return UidAlreadyExistsCompletion::m_shortDescription; }
	UidAlreadyExistsCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	UidAlreadyExistsCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UidAlreadyExistsCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UidAlreadyExistsCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	UidAlreadyExistsCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	UidAlreadyExistsCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setObjectDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ObjectDesc", value); }            				
	ACE_CString getObjectDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ObjectDesc");  }

			void setUid(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Uid", value); }            				
	ACE_CString getUid (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Uid");  }

	
};

class RangeUnavailableCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = RangeUnavailable;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RangeUnavailableCompletion::m_shortDescription; }
	RangeUnavailableCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RangeUnavailableCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnavailableCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnavailableCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnavailableCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RangeUnavailableCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeLockedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = RangeLocked;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RangeLockedCompletion::m_shortDescription; }
	RangeLockedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RangeLockedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeLockedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeLockedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeLockedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RangeLockedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeUnlockedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = RangeUnlocked;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RangeUnlockedCompletion::m_shortDescription; }
	RangeUnlockedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RangeUnlockedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnlockedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnlockedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeUnlockedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RangeUnlockedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeExhaustedCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError; // = 8000
	static const ACSErr::ErrorCode m_code = RangeExhausted;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return RangeExhaustedCompletion::m_shortDescription; }
	RangeExhaustedCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	RangeExhaustedCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeExhaustedCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeExhaustedCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	RangeExhaustedCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	RangeExhaustedCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

			
			void setRangeMaxDocumentId(ACE_CString value){ getErrorTraceHelper()->setMemberValue("RangeMaxDocumentId", value); }            				
	ACE_CString getRangeMaxDocumentId (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("RangeMaxDocumentId");  }

	
};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ArchiveIdentifierErrorExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ArchiveIdentifierErrorExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ArchiveIdentifierErrorExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ArchiveIdentifierErrorExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ArchiveIdentifierErrorExImpl (ArchiveIdentifierError::ArchiveIdentifierErrorEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::ArchiveIdentifierErrorEx getArchiveIdentifierErrorEx () { return ArchiveIdentifierError::ArchiveIdentifierErrorEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class IdentifierUnexpectedExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = IdentifierUnexpected;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IdentifierUnexpectedExImpl(const IdentifierUnexpectedExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<IdentifierUnexpectedExImpl&>(ex).getErrorTrace()) {}
		
	IdentifierUnexpectedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IdentifierUnexpectedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IdentifierUnexpectedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IdentifierUnexpectedExImpl (const ArchiveIdentifierError::IdentifierUnexpectedEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::IdentifierUnexpectedEx getIdentifierUnexpectedEx () { return ArchiveIdentifierError::IdentifierUnexpectedEx (getErrorTrace()); }
	
	template <class T >
	IdentifierUnexpectedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class IdentifierUnavailableExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = IdentifierUnavailable;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	IdentifierUnavailableExImpl(const IdentifierUnavailableExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<IdentifierUnavailableExImpl&>(ex).getErrorTrace()) {}
		
	IdentifierUnavailableExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	IdentifierUnavailableExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IdentifierUnavailableExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	IdentifierUnavailableExImpl (const ArchiveIdentifierError::IdentifierUnavailableEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::IdentifierUnavailableEx getIdentifierUnavailableEx () { return ArchiveIdentifierError::IdentifierUnavailableEx (getErrorTrace()); }
	
	template <class T >
	IdentifierUnavailableExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setContextInfo(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ContextInfo", value); }            				
	ACE_CString getContextInfo (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ContextInfo");  }

	
};

class UidAlreadyExistsExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = UidAlreadyExists;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	UidAlreadyExistsExImpl(const UidAlreadyExistsExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<UidAlreadyExistsExImpl&>(ex).getErrorTrace()) {}
		
	UidAlreadyExistsExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	UidAlreadyExistsExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UidAlreadyExistsExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	UidAlreadyExistsExImpl (const ArchiveIdentifierError::UidAlreadyExistsEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::UidAlreadyExistsEx getUidAlreadyExistsEx () { return ArchiveIdentifierError::UidAlreadyExistsEx (getErrorTrace()); }
	
	template <class T >
	UidAlreadyExistsExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setObjectDesc(ACE_CString value){ getErrorTraceHelper()->setMemberValue("ObjectDesc", value); }            				
	ACE_CString getObjectDesc (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("ObjectDesc");  }

			void setUid(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Uid", value); }            				
	ACE_CString getUid (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Uid");  }

	
};

class RangeUnavailableExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = RangeUnavailable;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RangeUnavailableExImpl(const RangeUnavailableExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<RangeUnavailableExImpl&>(ex).getErrorTrace()) {}
		
	RangeUnavailableExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RangeUnavailableExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeUnavailableExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeUnavailableExImpl (const ArchiveIdentifierError::RangeUnavailableEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::RangeUnavailableEx getRangeUnavailableEx () { return ArchiveIdentifierError::RangeUnavailableEx (getErrorTrace()); }
	
	template <class T >
	RangeUnavailableExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeLockedExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = RangeLocked;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RangeLockedExImpl(const RangeLockedExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<RangeLockedExImpl&>(ex).getErrorTrace()) {}
		
	RangeLockedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RangeLockedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeLockedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeLockedExImpl (const ArchiveIdentifierError::RangeLockedEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::RangeLockedEx getRangeLockedEx () { return ArchiveIdentifierError::RangeLockedEx (getErrorTrace()); }
	
	template <class T >
	RangeLockedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeUnlockedExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = RangeUnlocked;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RangeUnlockedExImpl(const RangeUnlockedExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<RangeUnlockedExImpl&>(ex).getErrorTrace()) {}
		
	RangeUnlockedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RangeUnlockedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeUnlockedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeUnlockedExImpl (const ArchiveIdentifierError::RangeUnlockedEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::RangeUnlockedEx getRangeUnlockedEx () { return ArchiveIdentifierError::RangeUnlockedEx (getErrorTrace()); }
	
	template <class T >
	RangeUnlockedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

	
};

class RangeExhaustedExImpl: public ArchiveIdentifierErrorExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ArchiveIdentifierError;
	static const ACSErr::ErrorCode m_code = RangeExhausted;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	RangeExhaustedExImpl(const RangeExhaustedExImpl& ex) :
			ArchiveIdentifierErrorExImpl(const_cast<RangeExhaustedExImpl&>(ex).getErrorTrace()) {}
		
	RangeExhaustedExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	RangeExhaustedExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeExhaustedExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	RangeExhaustedExImpl (const ArchiveIdentifierError::RangeExhaustedEx & ex) : 
			ArchiveIdentifierErrorExImpl(ex.errorTrace) {}
			
	ArchiveIdentifierError::RangeExhaustedEx getRangeExhaustedEx () { return ArchiveIdentifierError::RangeExhaustedEx (getErrorTrace()); }
	
	template <class T >
	RangeExhaustedExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ArchiveIdentifierErrorExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


			void setRange(ACE_CString value){ getErrorTraceHelper()->setMemberValue("Range", value); }            				
	ACE_CString getRange (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("Range");  }

			
			void setRangeMaxDocumentId(ACE_CString value){ getErrorTraceHelper()->setMemberValue("RangeMaxDocumentId", value); }            				
	ACE_CString getRangeMaxDocumentId (){ return getErrorTraceHelper()->getMemberValue<ACE_CString>("RangeMaxDocumentId");  }

	
};

}

#endif
