#ifndef _ACSErrTypeCppNative_H_
#define _ACSErrTypeCppNative_H_

/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: AES2H.xslt,v 1.22 2007/05/23 08:55:56 nbarriga Exp $"
*************  THIS FILE IS AUTOMATICALLY GENERATED !!!!!!
*/
	
#include "ACSErrTypeCppNativeC.h"

#include "acserrExceptionManager.h"

namespace ACSErrTypeCppNative
{

class CppAnyCompletion: public ACSErr::CompletionImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCppNative; // = 8
	static const ACSErr::ErrorCode m_code = CppAny;
	static const char m_shortDescription[];
		
	public:

	const char * getShortDescription() { return CppAnyCompletion::m_shortDescription; }
	CppAnyCompletion (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
					
	CppAnyCompletion (ACSErr::Completion *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(*pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CppAnyCompletion (const ACSErr::Completion &pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CppAnyCompletion (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(pc, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
		
	CppAnyCompletion (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}	
						
	template <class T >
	CppAnyCompletion (const T &pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
		ACSErr::CompletionImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}

};


 // ******************************************************************* 
 //                                excptions for type:
 // ******************************************************************* 
class ACSErrTypeCppNativeExImpl : public ACSErr::ACSbaseExImpl
{
	protected:
	ACSErrTypeCppNativeExImpl(const ACSErr::ErrorTrace &et) : ACSErr::ACSbaseExImpl(et) {}
	
	ACSErrTypeCppNativeExImpl (ACSErr::ACSErrType et, ACSErr::ErrorCode ec, const char* file, 
						int line, const char* routine, const char* sd,
					   	ACSErr::Severity severity):
		   			ACSErr::ACSbaseExImpl(et, ec, file, line, routine, sd, severity) {}
				
	ACSErrTypeCppNativeExImpl (const ACSErr::ErrorTrace &pet,
						   ACSErr::ACSErrType et, ACSErr::ErrorCode ec,
						   const char* file, int line, const char* routine, const char* sd, 
						   ACSErr::Severity severity) :
					ACSErr::ACSbaseExImpl(pet, et, ec, file, line, routine, sd, severity) {}
	
	public:
					
	ACSErrTypeCppNativeExImpl (ACSErrTypeCppNative::ACSErrTypeCppNativeEx & ex) : ACSErr::ACSbaseExImpl(ex.errorTrace) {}
			
	ACSErrTypeCppNative::ACSErrTypeCppNativeEx getACSErrTypeCppNativeEx () { return ACSErrTypeCppNative::ACSErrTypeCppNativeEx (getErrorTrace()); }
};


 // ******************************************************************* 
 //                                excptions for codes:
 // ******************************************************************* 
class CppAnyExImpl: public ACSErrTypeCppNativeExImpl
{
	static const ACSErr::ACSErrType m_etype=ACSErr::ACSErrTypeCppNative;
	static const ACSErr::ErrorCode m_code = CppAny;
	static const char m_shortDescription[]  ;
	
	public:

        static const char * getShortDescription() { return m_shortDescription;}
	CppAnyExImpl(const CppAnyExImpl& ex) :
			ACSErrTypeCppNativeExImpl(const_cast<CppAnyExImpl&>(ex).getErrorTrace()) {}
		
	CppAnyExImpl (const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCppNativeExImpl(m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
	
	CppAnyExImpl (const ACSErr::ErrorTrace &et, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCppNativeExImpl(et, m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CppAnyExImpl (ACSErr::CompletionImpl *pc, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCppNativeExImpl((pc->isErrorFree() ? ACSErr::ErrorTrace()  : pc->getErrorTraceHelper()->getErrorTrace()), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}
				
	CppAnyExImpl (const ACSErrTypeCppNative::CppAnyEx & ex) : 
			ACSErrTypeCppNativeExImpl(ex.errorTrace) {}
			
	ACSErrTypeCppNative::CppAnyEx getCppAnyEx () { return ACSErrTypeCppNative::CppAnyEx (getErrorTrace()); }
	
	template <class T >
	CppAnyExImpl (const T& pe, const char* file, int line, const char* routine, ACSErr::Severity severity=DEFAULT_SEVERITY) : 
			ACSErrTypeCppNativeExImpl(ETHolder<T>(pe).getErrorTrace(), m_etype, m_code, file, line, routine, m_shortDescription, severity) {}


};

}

#endif
